/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.inner;

import arc.Core;
import arc.func.Cons;
import arc.func.Func;
import arc.graphics.g2d.TextureRegion;
import arc.scene.Element;
import arc.scene.ui.layout.Table;
import mindustry.Vars;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.type.Item;
import mindustry.type.Liquid;
import mindustry.type.PayloadSeq;
import mindustry.ui.Bar;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.consumers.Consume;
import mindustry.world.meta.BuildVisibility;
import newhorizon.expand.block.production.factory.MultiBlockEntity;

public class LinkBlock
extends Block {
    public LinkBlock(String name) {
        super(name);
        this.update = true;
        this.squareSprite = false;
        this.destructible = true;
        this.breakable = false;
        this.solid = true;
        this.rebuildable = false;
        this.canOverdrive = false;
        this.instantDeconstruct = true;
        this.hasItems = true;
        this.hasLiquids = true;
        this.hasPower = false;
        this.buildVisibility = BuildVisibility.hidden;
        this.inEditor = false;
        this.drawCracks = false;
        this.drawArrow = false;
        this.drawTeamOverlay = false;
        this.ambientSound = Sounds.none;
        this.breakSound = Sounds.none;
        this.destroySound = Sounds.none;
        this.placeSound = Sounds.none;
        this.acceptsItems = true;
        this.acceptsPayload = true;
        this.acceptsUnitPayloads = true;
        this.outputsPayload = false;
        this.localizedName = Core.bundle.get(this.getContentType() + ".new-horizon-inner-entity.name", this.name);
        this.description = Core.bundle.getOrNull(this.getContentType() + ".new-horizon-inner-entity.description");
        this.details = Core.bundle.getOrNull(this.getContentType() + ".new-horizon-inner-entity.details");
    }

    public boolean canBreak(Tile tile) {
        return false;
    }

    public boolean isHidden() {
        return true;
    }

    public void load() {
        super.load();
        this.region = Core.atlas.find("status-blasted");
    }

    public void loadIcon() {
        this.fullIcon = this.uiIcon = Core.atlas.find("status-blasted");
    }

    public boolean unlockedNow() {
        return false;
    }

    public class LinkBuild
    extends Building {
        public Building linkBuild;

        public void updateLink(Building link) {
            if (link instanceof MultiBlockEntity) {
                this.linkBuild = link;
                this.items = link.items;
                this.liquids = link.liquids;
            } else {
                this.linkBuild = null;
                this.tile.remove();
            }
        }

        public void updateTile() {
            if (this.linkBuild == null || !this.linkBuild.isValid()) {
                this.kill();
            }
        }

        public void draw() {
        }

        public void drawSelect() {
            if (this.linkBuild != null) {
                this.linkBuild.drawSelect();
            }
        }

        public TextureRegion getDisplayIcon() {
            return this.linkBuild == null ? this.block.uiIcon : this.linkBuild.getDisplayIcon();
        }

        public String getDisplayName() {
            String name;
            String string = name = this.linkBuild == null ? this.block.localizedName : this.linkBuild.block.localizedName;
            return this.team == Team.derelict ? name + "\n" + Core.bundle.get("block.derelict") : name + (this.team != Vars.player.team() && !this.team.emoji.isEmpty() ? " " + this.team.emoji : "");
        }

        public void displayBars(Table table) {
            if (this.linkBuild != null) {
                for (Func buildingBarFunc : this.linkBuild.block.listBars()) {
                    Bar result = (Bar)buildingBarFunc.get((Object)this.linkBuild);
                    if (result == null) continue;
                    table.add((Element)result).growX();
                    table.row();
                }
            }
        }

        public void displayConsumption(Table table) {
            if (this.linkBuild != null) {
                table.left();
                for (Consume cons : this.linkBuild.block.consumers) {
                    if (cons.optional && cons.booster) continue;
                    cons.build(this.linkBuild, table);
                }
            }
        }

        public boolean acceptItem(Building source, Item item) {
            return this.linkBuild != null && this.linkBuild.acceptItem(source, item);
        }

        public int acceptStack(Item item, int amount, Teamc source) {
            if (this.linkBuild != null) {
                return this.linkBuild.acceptStack(item, amount, source);
            }
            return 0;
        }

        public boolean acceptLiquid(Building source, Liquid liquid) {
            return this.linkBuild != null && this.linkBuild.acceptLiquid(source, liquid);
        }

        public boolean acceptPayload(Building source, Payload payload) {
            return this.linkBuild != null && this.linkBuild.acceptPayload(source, payload);
        }

        public float handleDamage(float amount) {
            if (this.linkBuild != null) {
                return this.linkBuild.handleDamage(amount);
            }
            return 0.0f;
        }

        public void damage(float damage) {
            if (this.linkBuild != null) {
                this.linkBuild.damage(damage);
            }
        }

        public void handleItem(Building source, Item item) {
            if (this.linkBuild != null) {
                this.linkBuild.handleItem(source, item);
            }
        }

        public void handleStack(Item item, int amount, Teamc source) {
            if (this.linkBuild != null) {
                this.linkBuild.handleStack(item, amount, source);
            }
        }

        public void handleLiquid(Building source, Liquid liquid, float amount) {
            if (this.linkBuild != null) {
                this.linkBuild.handleLiquid(source, liquid, amount);
            }
        }

        public void handlePayload(Building source, Payload payload) {
            if (this.linkBuild != null) {
                this.linkBuild.handlePayload(source, payload);
            }
        }

        public void handleString(Object value) {
            if (this.linkBuild != null) {
                this.linkBuild.handleString(value);
            }
        }

        public Payload getPayload() {
            return this.linkBuild == null ? null : this.linkBuild.getPayload();
        }

        public Payload takePayload() {
            return this.linkBuild == null ? null : this.linkBuild.takePayload();
        }

        public PayloadSeq getPayloads() {
            return this.linkBuild == null ? null : this.linkBuild.getPayloads();
        }

        public void handleUnitPayload(Unit unit, Cons<Payload> grabber) {
            if (this.linkBuild != null) {
                this.linkBuild.handleUnitPayload(unit, grabber);
            }
        }

        public void onProximityUpdate() {
            if (this.linkBuild != null) {
                ((MultiBlockEntity)this.linkBuild).updateLinkProximity();
            }
            super.onProximityUpdate();
        }

        public void onDestroyed() {
        }

        public void remove() {
            super.remove();
        }

        public boolean canPickup() {
            return false;
        }
    }
}

