/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.liquid;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Point2;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.graphics.Drawf;
import mindustry.type.Liquid;
import mindustry.world.Edges;
import mindustry.world.blocks.production.Pump;
import newhorizon.util.graphic.SpriteUtil;

public class AdaptPump
extends Pump {
    public TextureRegion[] splits;

    public AdaptPump(String name) {
        super(name);
    }

    public void load() {
        super.load();
        this.splits = this.size == 1 ? SpriteUtil.splitRegionArray((TextureRegion)Core.atlas.find(this.name + "-atlas"), 32, 32, 1, SpriteUtil.ATLAS_INDEX_4_4) : SpriteUtil.splitRegionArray((TextureRegion)Core.atlas.find(this.name + "-atlas"), 32, 32, 1);
    }

    public class AdaptPumpBuild
    extends Pump.PumpBuild {
        public boolean[] drawLink;
        public int[] drawIdx;
        public int drawIndex;

        public AdaptPumpBuild() {
            super((Pump)AdaptPump.this);
            this.drawLink = new boolean[8];
            this.drawIdx = new int[4];
            this.drawIndex = 0;
        }

        public void onProximityUpdate() {
            super.onProximityUpdate();
            if (AdaptPump.this.size == 1) {
                this.drawIndex = 0;
                for (int i = 0; i < SpriteUtil.orthogonalPos.length; ++i) {
                    Point2 p = SpriteUtil.orthogonalPos[i];
                    if (!(Vars.world.build(this.tileX() + p.x, this.tileY() + p.y) instanceof AdaptPumpBuild)) continue;
                    this.drawIndex += 1 << i;
                }
            } else {
                for (int i = 0; i < Edges.getEdges((int)2).length; ++i) {
                    Point2 p = Edges.getEdges((int)2)[i];
                    Building b = Vars.world.build(this.tileX() + p.x, this.tileY() + p.y);
                    this.drawLink[i] = b instanceof AdaptPumpBuild;
                }
                this.drawIdx[0] = Mathf.num((boolean)this.drawLink[1]) + Mathf.num((boolean)this.drawLink[2]) * 2;
                this.drawIdx[1] = Mathf.num((boolean)this.drawLink[3]) + Mathf.num((boolean)this.drawLink[4]) * 2;
                this.drawIdx[2] = Mathf.num((boolean)this.drawLink[5]) + Mathf.num((boolean)this.drawLink[6]) * 2;
                this.drawIdx[3] = Mathf.num((boolean)this.drawLink[7]) + Mathf.num((boolean)this.drawLink[0]) * 2;
            }
        }

        public void draw() {
            if (this.isPayload()) {
                Draw.rect((TextureRegion)AdaptPump.this.region, (float)this.x, (float)this.y);
            } else if (AdaptPump.this.size == 1) {
                Draw.rect((TextureRegion)AdaptPump.this.splits[this.drawIndex], (float)this.x, (float)this.y);
            } else if (AdaptPump.this.size == 2) {
                Draw.rect((TextureRegion)AdaptPump.this.splits[this.drawIdx[0]], (float)(this.x + 4.0f), (float)(this.y + 4.0f));
                Draw.rect((TextureRegion)AdaptPump.this.splits[this.drawIdx[1] + 4], (float)(this.x - 4.0f), (float)(this.y + 4.0f));
                Draw.rect((TextureRegion)AdaptPump.this.splits[this.drawIdx[2] + 8], (float)(this.x - 4.0f), (float)(this.y - 4.0f));
                Draw.rect((TextureRegion)AdaptPump.this.splits[this.drawIdx[3] + 12], (float)(this.x + 4.0f), (float)(this.y - 4.0f));
            }
            if (this.liquids != null && this.liquidDrop != null) {
                Drawf.liquid((TextureRegion)AdaptPump.this.liquidRegion, (float)this.x, (float)this.y, (float)(this.liquids.get(this.liquidDrop) / AdaptPump.this.liquidCapacity), (Color)this.liquidDrop.color);
            }
        }

        public void drawStatus() {
            if (this.drawIdx[3] == 0) {
                super.drawStatus();
            }
        }

        public boolean acceptLiquid(Building source, Liquid liquid) {
            return super.acceptLiquid(source, liquid) || this.isValidPump(source) && this.liquidDrop == liquid;
        }

        public boolean isValidPump(Building e) {
            return e instanceof AdaptPumpBuild;
        }
    }
}

