/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.power;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Rand;
import mindustry.Vars;
import mindustry.gen.Building;
import mindustry.gen.Teamc;
import mindustry.graphics.Pal;
import mindustry.world.Block;
import mindustry.world.meta.StatUnit;
import newhorizon.content.NHStats;
import newhorizon.expand.entities.GravityTrapField;

public class GravityWell
extends Block {
    public float gravityRange = 80.0f;
    public final int effect = this.timers++;
    public static Rand rand = new Rand();

    public GravityWell(String name) {
        super(name);
        this.update = true;
    }

    public void init() {
        super.init();
        this.clipSize += this.gravityRange * 2.0f;
    }

    public void drawRangeRect(float x, float y, float range) {
        Lines.stroke((float)3.0f, (Color)Pal.gray);
        Lines.square((float)x, (float)y, (float)(range + 1.0f));
        Color color = Vars.player == null ? Pal.techBlue : Vars.player.team().color;
        Lines.stroke((float)1.0f, (Color)color);
        Lines.square((float)x, (float)y, (float)range);
        Draw.reset();
    }

    public void setStats() {
        super.setStats();
        this.stats.add(NHStats.gravityRange, this.gravityRange / 8.0f, StatUnit.blocks);
    }

    public class GravityWellBuild
    extends Building {
        public transient GravityTrapField field;

        public void created() {
            super.created();
            this.field = new GravityTrapField(this.team, GravityWell.this.gravityRange);
        }

        public void update() {
            this.field.update((Teamc)this);
        }

        public void draw() {
            super.draw();
            Draw.z((float)142.472f);
            Draw.color((Color)this.team.color);
            Draw.alpha((float)0.25f);
            Fill.square((float)this.x, (float)this.y, (float)GravityWell.this.gravityRange);
        }

        public void drawSelect() {
            super.drawSelect();
            GravityWell.this.drawRangeRect(this.x, this.y, GravityWell.this.gravityRange);
        }

        public void remove() {
            super.remove();
            this.field.remove();
        }
    }
}

