/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.production.factory;

import arc.math.geom.Point2;
import arc.struct.IntSeq;
import arc.struct.Seq;
import mindustry.Vars;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.Build;
import mindustry.world.Tile;
import newhorizon.content.blocks.InnerBlock;
import newhorizon.expand.block.inner.LinkBlock;
import newhorizon.expand.block.inner.PlaceholderBlock;

public interface MultiBlock {
    public Seq<Point2> linkBlockPos();

    public IntSeq linkBlockSize();

    public Block mirrorBlock();

    public boolean isMirror();

    default public Point2 calculateRotatedPosition(Point2 pos, int blockSize, int linkSize, int rotation) {
        Point2 point2;
        int shift = (blockSize + 1) % 2;
        int offset = (linkSize + 1) % 2;
        int px = pos.x;
        int py = pos.y;
        switch (rotation) {
            case 1: {
                point2 = new Point2(-py + shift - offset, px);
                break;
            }
            case 2: {
                point2 = new Point2(-px + shift - offset, -py + shift - offset);
                break;
            }
            case 3: {
                point2 = new Point2(py, -px + shift - offset);
                break;
            }
            default: {
                point2 = new Point2(px, py);
            }
        }
        return point2;
    }

    default public void addLink(int ... values) {
        for (int i = 0; i < values.length; i += 3) {
            this.linkBlockPos().add((Object)new Point2(values[i], values[i + 1]));
            this.linkBlockSize().add(values[i + 2]);
        }
    }

    default public boolean checkLink(Tile tile, Team team, int size, int rotation) {
        for (int i = 0; i < this.linkBlockPos().size; ++i) {
            Point2 p = (Point2)this.linkBlockPos().get(i);
            int s = this.linkBlockSize().get(i);
            Point2 rotated = this.calculateRotatedPosition(p, size, s, rotation);
            if (Build.validPlace((Block)InnerBlock.linkEntity[s - 1], (Team)team, (int)(tile.x + rotated.x), (int)(tile.y + rotated.y), (int)0, (boolean)false)) continue;
            return false;
        }
        return true;
    }

    default public void createPlaceholder(Tile tile, int size) {
        if (Vars.state.rules.infiniteResources || tile == null || tile.build == null) {
            return;
        }
        for (int i = 0; i < this.linkBlockPos().size; ++i) {
            Point2 p = (Point2)this.linkBlockPos().get(i);
            int s = this.linkBlockSize().get(i);
            Point2 rotated = this.calculateRotatedPosition(p, size, s, tile.build.rotation);
            Tile t = Vars.world.tile(tile.x + rotated.x, tile.y + rotated.y);
            t.setBlock((Block)InnerBlock.placeholderEntity[s - 1], tile.team(), 0);
            PlaceholderBlock.PlaceholderBuild b = (PlaceholderBlock.PlaceholderBuild)t.build;
            b.updateLink(tile);
        }
    }

    default public Seq<Building> setLinkBuild(Building building, Block block, Tile tile, Team team, int size, int rotation) {
        Seq out = new Seq();
        for (int i = 0; i < this.linkBlockPos().size; ++i) {
            Point2 p = (Point2)this.linkBlockPos().get(i);
            int s = this.linkBlockSize().get(i);
            Point2 rotated = this.calculateRotatedPosition(p, size, s, rotation);
            Tile t = Vars.world.tile(tile.x + rotated.x, tile.y + rotated.y);
            if (!block.outputsLiquid) {
                t.setBlock((Block)InnerBlock.linkEntity[s - 1], team, 0);
            } else {
                t.setBlock((Block)InnerBlock.linkEntityLiquid[s - 1], team, 0);
            }
            LinkBlock.LinkBuild b = (LinkBlock.LinkBuild)t.build;
            b.updateLink(building);
            out.add((Object)b);
        }
        return out;
    }

    default public Seq<Tile> getLinkTiles(Tile tile, int size, int rotation) {
        Seq out = new Seq();
        for (int i = 0; i < this.linkBlockPos().size; ++i) {
            Point2 p = (Point2)this.linkBlockPos().get(i);
            int s = this.linkBlockSize().get(i);
            Point2 rotated = this.calculateRotatedPosition(p, size, s, rotation);
            Tile t = Vars.world.tile(tile.x + rotated.x, tile.y + rotated.y);
            out.add((Object)t);
        }
        return out;
    }

    default public Seq<Tile> linkTiles(int x, int y, int size, int rotation) {
        Seq tiles = new Seq();
        Point2 lb = this.leftBottomPos(size);
        for (int tx = 0; tx < size; ++tx) {
            for (int ty = 0; ty < size; ++ty) {
                Tile other = Vars.world.tile(x + tx + lb.x, y + ty + lb.y);
                if (other == null) continue;
                tiles.add((Object)other);
            }
        }
        for (int i = 0; i < this.linkBlockPos().size; ++i) {
            Point2 p = (Point2)this.linkBlockPos().get(i);
            int s = this.linkBlockSize().get(i);
            Point2 rotated = this.calculateRotatedPosition(p, size, s, rotation);
            Point2 lb2 = this.leftBottomPos(s).add(rotated);
            for (int tx = 0; tx < s; ++tx) {
                for (int ty = 0; ty < s; ++ty) {
                    Tile other = Vars.world.tile(x + tx + lb2.x, y + ty + lb2.y);
                    if (other == null) continue;
                    tiles.add((Object)other);
                }
            }
        }
        return tiles;
    }

    default public Point2 teamOverlayPos(int size, int rotation) {
        Point2 out = this.leftBottomPos(size);
        for (int i = 0; i < this.linkBlockPos().size; ++i) {
            Point2 p = (Point2)this.linkBlockPos().get(i);
            int s = this.linkBlockSize().get(i);
            Point2 rotated = this.calculateRotatedPosition(p, size, s, rotation);
            Point2 lb = this.leftBottomPos(s).add(rotated);
            if (lb.x + lb.y >= out.x + out.y) continue;
            out.set(lb.x, lb.y);
        }
        return out;
    }

    default public Point2 statusOverlayPos(int size, int rotation) {
        Point2 out = this.rightBottomPos(size);
        for (int i = 0; i < this.linkBlockPos().size; ++i) {
            Point2 p = (Point2)this.linkBlockPos().get(i);
            int s = this.linkBlockSize().get(i);
            Point2 rotated = this.calculateRotatedPosition(p, size, s, rotation);
            Point2 rb = this.rightBottomPos(s).add(rotated);
            if (rb.x - rb.y <= out.x - out.y) continue;
            out.set(rb.x, rb.y);
        }
        return out;
    }

    default public Point2 leftBottomPos(int size) {
        int shift = (size + 1) % 2;
        return new Point2(-size / 2 + shift, -size / 2 + shift);
    }

    default public Point2 rightBottomPos(int size) {
        int shift = (size + 1) % 2;
        return new Point2(size / 2, -size / 2 + shift);
    }

    default public Point2 getMaxSize(int size, int rotation) {
        int shift = (size + 1) % 2;
        int left = -size / 2 + shift;
        int bot = -size / 2 + shift;
        int right = size / 2;
        int top = size / 2;
        Point2 out = new Point2(size, size);
        for (int i = 0; i < this.linkBlockPos().size; ++i) {
            Point2 p = (Point2)this.linkBlockPos().get(i);
            int s = this.linkBlockSize().get(i);
            Point2 rotated = this.calculateRotatedPosition(p, size, s, rotation);
            left = Math.min(left, rotated.x);
            right = Math.max(right, rotated.x);
            bot = Math.min(bot, rotated.y);
            top = Math.max(top, rotated.y);
        }
        out.set(right - left + 1, top - bot + 1);
        return out;
    }
}

