/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.production.factory;

import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.style.Style;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Stack;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Scaling;
import arc.util.Strings;
import arc.util.Time;
import mindustry.content.Items;
import mindustry.content.Liquids;
import mindustry.content.UnitTypes;
import mindustry.core.UI;
import mindustry.ctype.UnlockableContent;
import mindustry.gen.Building;
import mindustry.gen.Icon;
import mindustry.type.Item;
import mindustry.type.ItemStack;
import mindustry.type.Liquid;
import mindustry.type.LiquidStack;
import mindustry.type.PayloadStack;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.blocks.payloads.BuildPayload;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.meta.BlockStatus;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import mindustry.world.meta.StatValue;
import mindustry.world.meta.StatValues;
import newhorizon.expand.block.consumer.ConsumeRecipe;
import newhorizon.expand.block.production.factory.AdaptCrafter;
import newhorizon.expand.type.Recipe;

public class RecipeGenericCrafter
extends AdaptCrafter {
    public Seq<Recipe> recipes = new Seq();
    public Seq<Item> itemOutput = new Seq();
    public Seq<Liquid> liquidOutput = new Seq();
    public Seq<UnlockableContent> payloadOutput = new Seq();

    public RecipeGenericCrafter(String name) {
        super(name);
        this.consume(new ConsumeRecipe(RecipeGenericCrafterBuild::getRecipe, RecipeGenericCrafterBuild::getDisplayRecipe));
    }

    @Override
    public void init() {
        super.init();
        this.recipes.each(recipe -> {
            recipe.inputItem.each(stack -> {
                this.itemFilter[stack.item.id] = true;
            });
            recipe.inputLiquid.each(stack -> {
                this.liquidFilter[stack.liquid.id] = true;
            });
            recipe.inputPayload.each(stack -> this.payloadFilter.add((Object)stack.item));
            recipe.outputItem.each(stack -> this.itemOutput.add((Object)stack.item));
            recipe.outputLiquid.each(stack -> this.liquidOutput.add((Object)stack.liquid));
            recipe.outputPayload.each(stack -> this.payloadOutput.add((Object)stack.item));
        });
        this.outputItem = null;
        this.outputLiquid = null;
        if (this.recipes.isEmpty()) {
            this.outputItems = new ItemStack[]{new ItemStack(Items.copper, 0)};
            this.outputLiquids = new LiquidStack[]{new LiquidStack(Liquids.water, 0.0f)};
            this.outputPayloads = new PayloadStack[]{new PayloadStack((UnlockableContent)UnitTypes.dagger, 0)};
        } else {
            int i;
            Recipe firstRecipe = (Recipe)this.recipes.first();
            this.outputItems = new ItemStack[Math.max(firstRecipe.outputItem.size, 1)];
            for (i = 0; i < this.outputItems.length; ++i) {
                this.outputItems[i] = i < firstRecipe.outputItem.size ? (ItemStack)firstRecipe.outputItem.get(i) : new ItemStack(Items.copper, 0);
            }
            this.outputLiquids = new LiquidStack[Math.max(firstRecipe.outputLiquid.size, 1)];
            for (i = 0; i < this.outputLiquids.length; ++i) {
                this.outputLiquids[i] = i < firstRecipe.outputLiquid.size ? new LiquidStack(((LiquidStack)firstRecipe.outputLiquid.get((int)i)).liquid, 0.0f) : new LiquidStack(Liquids.water, 0.0f);
            }
            this.outputPayloads = new PayloadStack[Math.max(firstRecipe.outputPayload.size, 1)];
            for (i = 0; i < this.outputPayloads.length; ++i) {
                this.outputPayloads[i] = i < firstRecipe.outputPayload.size ? (PayloadStack)firstRecipe.outputPayload.get(i) : new PayloadStack((UnlockableContent)UnitTypes.dagger, 0);
            }
        }
        this.craftTime = 60.0f;
        if (!this.liquidOutput.isEmpty()) {
            this.outputsLiquid = true;
        }
    }

    public boolean outputsItems() {
        return !this.itemOutput.isEmpty();
    }

    @Override
    public void setStats() {
        super.setStats();
        this.stats.add(Stat.input, this.display());
        this.stats.remove(Stat.output);
        this.stats.remove(Stat.productionTime);
    }

    public StatValue display() {
        return table -> {
            table.row();
            table.table(cont -> {
                int i = 0;
                while (i < this.recipes.size) {
                    Recipe recipe = (Recipe)this.recipes.get(i);
                    int finalI = i++;
                    cont.table(t -> {
                        t.left().marginLeft(12.0f).add((CharSequence)("[accent][" + (finalI + 1) + "]:[]")).width(48.0f);
                        t.table(inner -> {
                            inner.table(row -> {
                                row.left();
                                recipe.inputItem.each(stack -> row.add((Element)RecipeGenericCrafter.display((UnlockableContent)stack.item, stack.amount, recipe.craftTime)));
                                recipe.inputLiquid.each(stack -> row.add((Element)RecipeGenericCrafter.display((UnlockableContent)stack.liquid, stack.amount * 60.0f, 60.0f)));
                                recipe.inputPayload.each(stack -> row.add((Element)RecipeGenericCrafter.display(stack.item, stack.amount, recipe.craftTime)));
                            }).growX();
                            inner.table(row -> {
                                row.left();
                                row.image((Drawable)Icon.right).size(32.0f).padLeft(8.0f).padRight(12.0f);
                                recipe.outputItem.each(stack -> row.add((Element)RecipeGenericCrafter.display((UnlockableContent)stack.item, stack.amount, recipe.craftTime)));
                                recipe.outputLiquid.each(stack -> row.add((Element)RecipeGenericCrafter.display((UnlockableContent)stack.liquid, stack.amount * 60.0f, 60.0f)));
                                recipe.outputPayload.each(stack -> row.add((Element)RecipeGenericCrafter.display(stack.item, stack.amount, recipe.craftTime)));
                            }).growX();
                        });
                    }).fillX();
                    cont.row();
                }
            });
        };
    }

    @Override
    public void setBars() {
        super.setBars();
        this.removeBar("liquid");
        this.recipes.each(recipe -> {
            recipe.inputLiquid.each(stack -> this.addLiquidBar(stack.liquid));
            recipe.outputLiquid.each(stack -> this.addLiquidBar(stack.liquid));
        });
    }

    public static Table display(UnlockableContent content, float amount, float timePeriod) {
        Table table = new Table();
        Stack stack = new Stack();
        stack.add((Element)new Table(o -> {
            o.left();
            o.add((Element)new Image(content.uiIcon)).size(32.0f).scaling(Scaling.fit);
        }));
        if (amount != 0.0f) {
            stack.add((Element)new Table(t -> {
                t.left().bottom();
                t.add((CharSequence)(amount >= 1000.0f ? UI.formatAmount((long)((int)amount)) : Strings.autoFixed((float)amount, (int)2))).style((Style)Styles.outlineLabel);
                t.pack();
            }));
        }
        StatValues.withTooltip((Element)stack, (UnlockableContent)content);
        table.add((Element)stack);
        table.add((CharSequence)(content.localizedName + "\n" + "[lightgray]" + Strings.autoFixed((float)(amount / (timePeriod / 60.0f)), (int)2) + StatUnit.perSecond.localized())).padLeft(2.0f).padRight(5.0f).style((Style)Styles.outlineLabel);
        return table;
    }

    public class RecipeGenericCrafterBuild
    extends AdaptCrafter.AdaptCrafterBuild {
        public int recipeIndex = -1;

        public Recipe getRecipe() {
            if (this.recipeIndex < 0 || this.recipeIndex >= RecipeGenericCrafter.this.recipes.size) {
                return null;
            }
            return (Recipe)RecipeGenericCrafter.this.recipes.get(this.recipeIndex);
        }

        public Recipe getDisplayRecipe() {
            if (this.recipeIndex < 0 && RecipeGenericCrafter.this.recipes.size > 0) {
                return (Recipe)RecipeGenericCrafter.this.recipes.first();
            }
            return this.getRecipe();
        }

        public void updateRecipe() {
            for (int i = RecipeGenericCrafter.this.recipes.size - 1; i >= 0; --i) {
                boolean valid = true;
                for (ItemStack input : ((Recipe)RecipeGenericCrafter.this.recipes.get((int)i)).inputItem) {
                    if (this.items.get(input.item) >= input.amount) continue;
                    valid = false;
                    break;
                }
                for (ItemStack input : ((Recipe)RecipeGenericCrafter.this.recipes.get((int)i)).inputLiquid) {
                    if (!(this.liquids.get(input.liquid) < input.amount * Time.delta)) continue;
                    valid = false;
                    break;
                }
                for (ItemStack input : ((Recipe)RecipeGenericCrafter.this.recipes.get((int)i)).inputPayload) {
                    if (this.getPayloads().get(input.item) >= input.amount) continue;
                    valid = false;
                    break;
                }
                if (!valid) continue;
                this.recipeIndex = i;
                return;
            }
            this.recipeIndex = -1;
        }

        public boolean validRecipe() {
            if (this.recipeIndex < 0) {
                return false;
            }
            for (ItemStack input : ((Recipe)RecipeGenericCrafter.this.recipes.get((int)this.recipeIndex)).inputItem) {
                if (this.items.get(input.item) >= input.amount) continue;
                return false;
            }
            for (ItemStack input : ((Recipe)RecipeGenericCrafter.this.recipes.get((int)this.recipeIndex)).inputLiquid) {
                if (!(this.liquids.get(input.liquid) < input.amount * Time.delta)) continue;
                return false;
            }
            for (ItemStack input : ((Recipe)RecipeGenericCrafter.this.recipes.get((int)this.recipeIndex)).inputPayload) {
                if (this.getPayloads().get(input.item) >= input.amount) continue;
                return false;
            }
            return true;
        }

        @Override
        public void updateTile() {
            if (!this.validRecipe()) {
                this.updateRecipe();
            }
            super.updateTile();
            Recipe current = this.getRecipe();
            if (current == null) {
                return;
            }
            if (this.efficiency > 0.0f && !current.outputLiquid.isEmpty()) {
                float inc = this.getProgressIncrease(RecipeGenericCrafter.this.craftTime / current.craftTime);
                current.outputLiquid.each(stack -> this.handleLiquid((Building)this, stack.liquid, Math.min(stack.amount * inc, RecipeGenericCrafter.this.liquidCapacity - this.liquids.get(stack.liquid))));
            }
            current.outputItem.each(stack -> {
                if (this.items.get(stack.item) >= RecipeGenericCrafter.this.itemCapacity) {
                    this.items.set(stack.item, RecipeGenericCrafter.this.itemCapacity);
                }
            });
            current.outputPayload.each(stack -> {
                if (this.getPayloads().get(stack.item) >= RecipeGenericCrafter.this.payloadCapacity) {
                    this.getPayloads().remove(stack.item, this.getPayloads().get(stack.item) - RecipeGenericCrafter.this.payloadCapacity);
                }
            });
        }

        @Override
        public void dumpOutputs() {
            boolean timer = this.timer(RecipeGenericCrafter.this.timerDump, (float)RecipeGenericCrafter.this.dumpTime / this.timeScale);
            if (timer) {
                RecipeGenericCrafter.this.itemOutput.each(this::dump);
                RecipeGenericCrafter.this.payloadOutput.each(output -> {
                    BuildPayload payload = new BuildPayload((Block)output, this.team);
                    payload.set(this.x, this.y, this.rotdeg());
                    this.dumpPayload((Payload)payload);
                });
            }
            RecipeGenericCrafter.this.liquidOutput.each(output -> this.dumpLiquid((Liquid)output, 2.0f, -1));
        }

        @Override
        public boolean shouldConsume() {
            if (this.getRecipe() == null) {
                return false;
            }
            for (ItemStack output : this.getRecipe().outputItem) {
                if (this.items.get(output.item) + output.amount <= RecipeGenericCrafter.this.itemCapacity) continue;
                return RecipeGenericCrafter.this.powerProduction > 0.0f;
            }
            for (ItemStack output : this.getRecipe().outputPayload) {
                if (this.getPayloads().get(output.item) + output.amount <= RecipeGenericCrafter.this.payloadCapacity) continue;
                return RecipeGenericCrafter.this.powerProduction > 0.0f;
            }
            if (!RecipeGenericCrafter.this.ignoreLiquidFullness) {
                if (this.getRecipe().outputLiquid.isEmpty()) {
                    return true;
                }
                boolean allFull = true;
                for (LiquidStack output : this.getRecipe().outputLiquid) {
                    if (this.liquids.get(output.liquid) >= RecipeGenericCrafter.this.liquidCapacity - 0.001f) {
                        if (RecipeGenericCrafter.this.dumpExtraLiquid) continue;
                        return false;
                    }
                    allFull = false;
                }
                if (allFull) {
                    return false;
                }
            }
            return this.enabled;
        }

        public float getProgressIncrease(float baseTime) {
            float scl = 1.0f;
            if (this.getRecipe() != null) {
                scl = this.getRecipe().craftTime / RecipeGenericCrafter.this.craftTime;
            }
            return super.getProgressIncrease(baseTime) / scl;
        }

        @Override
        public void craft() {
            if (this.getRecipe() == null) {
                return;
            }
            this.consume();
            this.getRecipe().outputItem.each(stack -> {
                for (int i = 0; i < stack.amount; ++i) {
                    this.offload(stack.item);
                }
            });
            this.getRecipe().outputPayload.each(stack -> this.payloads.add(stack.item, stack.amount));
            this.progress %= 1.0f;
            if (this.wasVisible) {
                RecipeGenericCrafter.this.craftEffect.at(this.x, this.y);
            }
            this.updateRecipe();
        }

        public BlockStatus status() {
            if (this.enabled && this.getRecipe() == null) {
                return BlockStatus.noInput;
            }
            return super.status();
        }
    }
}

