/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.special;

import arc.Core;
import arc.func.Cons2;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.geom.Point2;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Eachable;
import arc.util.Scaling;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.ctype.Content;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.units.BuildPlan;
import mindustry.gen.Building;
import mindustry.gen.Unit;
import mindustry.io.TypeIO;
import mindustry.logic.LAccess;
import mindustry.world.Block;
import mindustry.world.blocks.ItemSelection;
import newhorizon.util.graphic.DrawFunc;

public class IconDisplay
extends Block {
    public static boolean drawIconDisplayText = true;
    public TextureRegion maskRegion;

    public IconDisplay(String name) {
        super(name);
        this.size = 2;
        this.sync = true;
        this.update = true;
        this.rotate = false;
        this.saveConfig = true;
        this.configurable = true;
        this.logicConfigurable = true;
        this.selectionColumns = 8;
        this.selectionRows = 8;
        this.clipSize = 200.0f;
        this.config(UnlockableContent.class, (build, content) -> {
            build.displayContent = content;
        });
        this.configClear(build -> {
            build.displayContent = null;
        });
    }

    public void load() {
        super.load();
        this.maskRegion = Core.atlas.find(this.name + "-mask");
    }

    public void drawPlanConfig(BuildPlan plan, Eachable<BuildPlan> list) {
        Object object = plan.config;
        if (object instanceof UnlockableContent) {
            UnlockableContent content = (UnlockableContent)object;
            Tmp.v1.set(Scaling.bounded.apply((float)content.uiIcon.width, (float)content.uiIcon.height, 6.0f * (float)this.size, 6.0f * (float)this.size));
            Draw.rect((TextureRegion)content.uiIcon, (float)plan.drawx(), (float)plan.drawy(), (float)Tmp.v1.x, (float)Tmp.v1.y);
        }
    }

    public class IconDisplayBuild
    extends Building {
        public UnlockableContent displayContent;
        public Seq<UnlockableContent> tmpSeq = new Seq();

        public Seq<UnlockableContent> displayContents() {
            this.tmpSeq.clear();
            this.tmpSeq.add(Vars.content.items().select(i -> !i.isHidden()));
            this.tmpSeq.add(Vars.content.liquids().select(l -> !l.isHidden()));
            this.tmpSeq.add(Vars.content.units().select(u -> !u.isHidden()));
            this.tmpSeq.add(Vars.content.blocks().select(b -> !b.isHidden()));
            this.tmpSeq.add(Vars.content.planets().select(p -> !p.accessible));
            this.tmpSeq.add(Vars.content.statusEffects().select(e -> !e.isHidden()));
            this.tmpSeq.add(Vars.content.sectors().select(s -> !s.isHidden()));
            return this.tmpSeq.as();
        }

        public void buildConfiguration(Table table) {
            ItemSelection.buildTable((Block)IconDisplay.this, (Table)table, this.displayContents(), this::config, this::configure, (int)IconDisplay.this.selectionRows, (int)IconDisplay.this.selectionColumns);
        }

        public UnlockableContent config() {
            return this.displayContent;
        }

        public void configure(Object value) {
            super.configure(value);
        }

        public void configured(Unit builder, Object value) {
            Class<Void> type = value == null ? Void.TYPE : (value.getClass().isAnonymousClass() ? value.getClass().getSuperclass() : value.getClass());
            UnlockableContent cont = null;
            if (value instanceof UnlockableContent) {
                type = UnlockableContent.class;
                cont = (UnlockableContent)value;
            }
            if (value instanceof Long) {
                Long num = (Long)value;
                int typeID = Point2.unpack((int)Math.toIntExact((long)num.longValue())).x;
                int contID = Point2.unpack((int)Math.toIntExact((long)num.longValue())).y;
                if (typeID < Vars.content.getContentMap().length && Vars.content.getContentMap()[typeID].get(contID) != null) {
                    type = UnlockableContent.class;
                    cont = (UnlockableContent)Vars.content.getContentMap()[typeID].get(contID);
                }
            }
            if (builder != null && builder.isPlayer()) {
                this.lastAccessed = builder.getPlayer().coloredName();
            }
            if (this.block.configurations.containsKey(type) && Vars.content != null) {
                ((Cons2)this.block.configurations.get(type)).get((Object)this, (Object)cont);
            }
        }

        public double sense(LAccess sensor) {
            if (sensor == LAccess.config && this.displayContent != null) {
                return Point2.pack((int)this.displayContent.getContentType().ordinal(), (int)this.displayContent.id);
            }
            return super.sense(sensor);
        }

        public void draw() {
            Draw.rect((TextureRegion)IconDisplay.this.region, (float)this.x, (float)this.y);
            if (this.displayContent != null) {
                Draw.z((float)35.0f);
                Draw.rect((TextureRegion)IconDisplay.this.maskRegion, (float)this.x, (float)this.y);
                Tmp.v1.set(Scaling.bounded.apply((float)this.displayContent.uiIcon.width, (float)this.displayContent.uiIcon.height, 6.0f * (float)IconDisplay.this.size, 6.0f * (float)IconDisplay.this.size));
                Draw.rect((TextureRegion)this.displayContent.uiIcon, (float)this.x, (float)this.y, (float)Tmp.v1.x, (float)Tmp.v1.y);
                if (IconDisplay.this.size == 2) {
                    DrawFunc.drawText(this.displayContent.localizedName, this.x, this.y + 8.0f);
                }
            }
        }

        public void write(Writes write) {
            super.write(write);
            write.bool(this.displayContent != null);
            if (this.displayContent != null) {
                TypeIO.writeContent((Writes)write, (Content)this.displayContent);
            }
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (read.bool()) {
                this.displayContent = (UnlockableContent)TypeIO.readContent((Reads)read);
            }
        }
    }
}

