/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.special;

import arc.Core;
import arc.func.Boolp;
import arc.func.Cons2;
import arc.func.Prov;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.style.Drawable;
import arc.scene.style.Style;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Stack;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Nullable;
import arc.util.Scaling;
import arc.util.Strings;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.content.UnitTypes;
import mindustry.core.UI;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Units;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.io.TypeIO;
import mindustry.type.ItemStack;
import mindustry.type.PayloadSeq;
import mindustry.type.PayloadStack;
import mindustry.type.UnitType;
import mindustry.ui.Bar;
import mindustry.ui.Fonts;
import mindustry.ui.Styles;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.units.UnitAssembler;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatValues;
import mindustry.world.modules.ItemModule;
import newhorizon.NHVars;
import newhorizon.content.NHContent;
import newhorizon.expand.block.consumer.ConsumeRecipe;
import newhorizon.expand.block.inner.ModulePayload;
import newhorizon.expand.entities.Spawner;
import newhorizon.expand.type.Recipe;
import newhorizon.util.func.NHFunc;
import newhorizon.util.ui.DelaySlideBar;

public class JumpGate
extends Block {
    public Seq<UnitRecipe> recipeList = Seq.with((Object[])new UnitRecipe[0]);
    public float warmupPerSpawn = 0.2f;
    public float maxWarmupSpeed = 3.0f;
    public float maxRadius = 180.0f;
    public int maxSpawnCount = 16;
    public Cons2<JumpGateBuild, Boolean> blockDrawer = (building, valid) -> {
        TextureRegion arrowRegion = NHContent.arrowRegion;
        TextureRegion pointerRegion = NHContent.pointerRegion;
        Draw.z((float)100.0f);
        float scl = building.warmup() * 0.125f;
        float rot = building.totalProgress();
        Draw.color((Color)building.team.color);
        Lines.stroke((float)(8.0f * scl));
        Lines.square((float)building.x, (float)building.y, (float)((float)(building.block.size * 8) / 2.5f), (float)(-rot));
        Lines.square((float)building.x, (float)building.y, (float)((float)(building.block.size * 8) / 2.0f), (float)rot);
        for (int i = 0; i < 4; ++i) {
            float length = (float)(8 * building.block.size) / 2.0f + 8.0f;
            float rotation = i * 90;
            float sin = Mathf.absin((float)building.totalProgress(), (float)16.0f, (float)8.0f);
            float signSize = 0.75f + Mathf.absin((float)(building.totalProgress() + 8.0f), (float)8.0f, (float)0.15f);
            Tmp.v1.trns(rotation + rot, -length);
            Draw.rect((TextureRegion)arrowRegion, (float)(building.x + Tmp.v1.x), (float)(building.y + Tmp.v1.y), (float)((float)arrowRegion.width * scl), (float)((float)arrowRegion.height * scl), (float)(rotation + 90.0f + rot));
            length = (float)(8 * building.block.size) / 2.0f + 3.0f + sin;
            Tmp.v1.trns(rotation, -length);
            Draw.rect((TextureRegion)pointerRegion, (float)(building.x + Tmp.v1.x), (float)(building.y + Tmp.v1.y), (float)((float)pointerRegion.width * signSize * scl), (float)((float)pointerRegion.height * signSize * scl), (float)(rotation + 90.0f));
        }
        Draw.color();
    };

    public JumpGate(String name) {
        super(name);
        this.solid = true;
        this.sync = true;
        this.breakable = true;
        this.update = true;
        this.commandable = true;
        this.configurable = true;
        this.saveConfig = true;
        this.canOverdrive = false;
        this.logicConfigurable = true;
        this.clearOnDoubleTap = true;
        this.allowConfigInventory = false;
        this.unloadable = false;
        this.config(Integer.class, JumpGateBuild::changePlan);
        this.config(Float.class, JumpGateBuild::changeSpawnCount);
        this.configClear(e -> {
            e.recipeIndex = -1;
        });
        this.consume(new ConsumeRecipe(JumpGateBuild::recipe));
        this.consumeBuilder.each(c -> {
            c.multiplier = b -> {
                if (b instanceof JumpGateBuild) {
                    JumpGateBuild gate = (JumpGateBuild)((Object)((Object)b));
                    return gate.costMultiplier();
                }
                return 1.0f;
            };
        });
    }

    public void addUnitRecipe(UnitType unitType, float craftTime, Recipe recipe) {
        UnitRecipe unitRecipe = new UnitRecipe();
        unitRecipe.unitType = unitType;
        unitRecipe.craftTime = craftTime;
        unitRecipe.recipe = recipe;
        this.recipeList.add((Object)unitRecipe);
    }

    public void init() {
        super.init();
        this.clipSize = this.maxRadius;
    }

    public void setBars() {
        super.setBars();
        this.addBar("progress", e -> new Bar("bar.progress", Pal.ammo, e::progress));
        this.addBar("efficiency", e -> new Bar(() -> Core.bundle.format("bar.efficiency", new Object[]{Strings.autoFixed((float)(e.speedMultiplier * 100.0f), (int)0)}), () -> Pal.techBlue, () -> e.speedMultiplier / this.maxWarmupSpeed));
        this.addBar("units", e -> new Bar(() -> e.unitType() == null ? "[lightgray]\ue815" : Core.bundle.format("bar.unitcap", new Object[]{Fonts.getUnicodeStr((String)e.unitType().name), e.team.data().countType(e.unitType()), e.unitType() == null ? Units.getStringCap((Team)e.team) : (e.unitType().useUnitCap ? Units.getStringCap((Team)e.team) : "\u221e")}), () -> Pal.power, () -> e.unitType() == null ? 0.0f : (e.unitType().useUnitCap ? (float)e.team.data().countType(e.unitType()) / (float)Units.getCap((Team)e.team) : 1.0f)));
    }

    public void setStats() {
        super.setStats();
        this.stats.add(Stat.output, table -> {
            table.row();
            for (UnitRecipe unitPlan : this.recipeList) {
                Recipe recipe = unitPlan.recipe;
                UnitType plan = unitPlan.unitType;
                table.table(Styles.grayPanel, t -> {
                    if (plan.isBanned()) {
                        t.image((Drawable)Icon.cancel).color(Pal.remove).size(40.0f);
                        return;
                    }
                    if (plan.unlockedNow()) {
                        t.image(plan.uiIcon).size(40.0f).pad(10.0f).left().scaling(Scaling.fit).with(i -> StatValues.withTooltip((Element)i, (UnlockableContent)plan));
                        t.table(info -> {
                            info.add((CharSequence)plan.localizedName).left();
                            info.row();
                            info.add((CharSequence)(Strings.autoFixed((float)(unitPlan.craftTime / 60.0f), (int)1) + " " + Core.bundle.get("unit.seconds"))).color(Color.lightGray);
                        }).left();
                        t.table(req -> {
                            req.right();
                            int i = 0;
                            for (ItemStack stack : recipe.inputItem) {
                                if (++i % 6 == 0) {
                                    req.row();
                                }
                                req.add((Element)StatValues.stack((UnlockableContent)stack.item, (int)stack.amount, (boolean)true)).pad(5.0f);
                            }
                            for (ItemStack stack : recipe.inputPayload) {
                                if (++i % 6 == 0) {
                                    req.row();
                                }
                                req.add((Element)StatValues.stack((UnlockableContent)stack.item, (int)stack.amount, (boolean)true)).pad(5.0f);
                            }
                        }).right().grow().pad(10.0f);
                    } else {
                        t.image((Drawable)Icon.lock).color(Pal.darkerGray).size(40.0f);
                    }
                }).growX().pad(5.0f);
                table.row();
            }
        });
    }

    public Stack getReqStack(UnlockableContent content, Prov<CharSequence> display, Boolp valid) {
        return new Stack(new Element[]{new Table(o -> o.left().add((Element)new Image(content.fullIcon)).size(32.0f).scaling(Scaling.fit)), new Table(t -> {
            t.left().bottom();
            t.label(() -> (valid.get() ? "[accent]" : "[negstat]") + display.get()).style((Style)Styles.outlineLabel);
            t.pack();
        })});
    }

    public static class UnitRecipe {
        public UnitType unitType = UnitTypes.alpha;
        public float craftTime = 600.0f;
        public Recipe recipe = Recipe.empty;
    }

    public class JumpGateBuild
    extends Building {
        public float speedMultiplier = 1.0f;
        public float progress;
        public float warmup;
        public float spawnWarmup;
        public int recipeIndex;
        public int spawnCount = 1;
        @Nullable
        public Vec2 command = new Vec2(Float.NaN, Float.NaN);
        public ItemModule tmpItem = new ItemModule();
        public Seq<Tile> tiles = new Seq();

        public Vec2 getCommandPosition() {
            return this.command;
        }

        public void onCommand(Vec2 target) {
            this.command.set(target);
        }

        public PayloadSeq getPayloads() {
            return NHVars.worldData.teamPayloadData.getPayload(this.team);
        }

        public boolean acceptPayload(Building source, Payload payload) {
            return payload.content() instanceof ModulePayload && this.getPayloads().get(payload.content()) < 1000;
        }

        public void handlePayload(Building source, Payload payload) {
            this.getPayloads().add(payload.content(), 1);
            Fx.payloadDeposit.at(payload.x(), payload.y(), payload.angleTo((Position)this), (Object)new UnitAssembler.YeetData(new Vec2(this.x, this.y), payload.content()));
        }

        public UnitRecipe unitRecipe() {
            if (this.recipeIndex < 0 || this.recipeIndex > JumpGate.this.recipeList.size - 1) {
                return null;
            }
            return (UnitRecipe)JumpGate.this.recipeList.get(this.recipeIndex);
        }

        public UnitType unitType() {
            if (this.recipeIndex < 0 || this.recipeIndex > JumpGate.this.recipeList.size - 1) {
                return null;
            }
            return ((UnitRecipe)JumpGate.this.recipeList.get((int)this.recipeIndex)).unitType;
        }

        public Recipe recipe() {
            if (this.unitRecipe() == null) {
                return Recipe.empty;
            }
            return this.unitRecipe().recipe;
        }

        public float craftTime() {
            if (this.recipeIndex < 0 || this.recipeIndex > JumpGate.this.recipeList.size - 1) {
                return 0.0f;
            }
            return ((UnitRecipe)JumpGate.this.recipeList.get((int)this.recipeIndex)).craftTime;
        }

        public float costMultiplier() {
            return Vars.state.rules.teams.get((Team)this.team).unitCostMultiplier * (float)this.spawnCount;
        }

        public boolean canSpawn() {
            return this.unitRecipe() != null;
        }

        public void drawSelect() {
            super.drawSelect();
            Drawf.dashCircle((float)this.x, (float)this.y, (float)JumpGate.this.maxRadius, (Color)this.team.color);
            if (this.unitType() != null) {
                this.drawItemSelection((UnlockableContent)this.unitType());
            }
            if (Float.isNaN(this.command.x) || Float.isNaN(this.command.y)) {
                return;
            }
            Lines.stroke((float)3.0f, (Color)Pal.gray);
            Lines.square((float)this.command.x, (float)this.command.y, (float)8.0f, (float)45.0f);
            Lines.stroke((float)1.0f, (Color)this.team.color);
            Lines.square((float)this.command.x, (float)this.command.y, (float)8.0f, (float)45.0f);
            Draw.reset();
        }

        public void drawConfigure() {
            JumpGate.this.drawPlaceText(this.unitType() == null ? "@empty" : this.unitType().localizedName + " x" + this.spawnCount, this.tileX(), this.tileY(), true);
        }

        public void changePlan(int idx) {
            if (idx == -1) {
                return;
            }
            if ((idx = Mathf.clamp((int)idx, (int)0, (int)(JumpGate.this.recipeList.size - 1))) == this.recipeIndex) {
                return;
            }
            this.progress = 0.0f;
            this.recipeIndex = idx;
            this.speedMultiplier = 1.0f;
        }

        public void changeSpawnCount(float count) {
            this.spawnCount = Mathf.round((float)Mathf.clamp((float)count, (float)1.0f, (float)JumpGate.this.maxSpawnCount));
            this.progress = 0.0f;
            this.speedMultiplier = 1.0f;
        }

        public void findTiles() {
            this.tiles = NHFunc.ableToSpawn(this.unitType(), this.x, this.y, JumpGate.this.maxRadius);
        }

        public void spawnUnit() {
            if (this.unitRecipe() == null) {
                return;
            }
            if (this.unitType() == null) {
                return;
            }
            if (!Vars.net.client()) {
                float rot = this.core() == null ? Angles.angle((float)this.x, (float)this.y, (float)this.command.x, (float)this.command.y) : Angles.angle((float)this.core().x, (float)this.core().y, (float)this.x, (float)this.y);
                Spawner spawner = new Spawner();
                Tile t = (Tile)this.tiles.random();
                Tmp.v1.set(t.worldx(), t.worldy());
                spawner.init(this.unitType(), this.team, (Position)Tmp.v1, rot, Mathf.clamp((float)(this.unitRecipe().craftTime / JumpGate.this.maxWarmupSpeed), (float)300.0f, (float)900.0f));
                if (this.command != null) {
                    spawner.commandPos.set(this.command.cpy());
                }
                spawner.add();
            }
            this.speedMultiplier = Mathf.clamp((float)(this.speedMultiplier + JumpGate.this.warmupPerSpawn), (float)1.0f, (float)JumpGate.this.maxWarmupSpeed);
        }

        public void updateTile() {
            super.updateTile();
            this.warmup = Mathf.lerp((float)this.warmup, (float)this.efficiency, (float)0.01f);
            this.spawnWarmup = Mathf.lerp((float)this.spawnWarmup, (float)this.efficiency, (float)0.01f);
            ItemModule itemModule = this.items = this.closestCore() == null ? this.tmpItem : this.closestCore().items;
            if (this.unitRecipe() == null || this.unitType() == null) {
                this.progress = 0.0f;
                return;
            }
            if (this.canSpawn() && Units.canCreate((Team)this.team, (UnitType)this.unitType())) {
                this.progress += this.getProgressIncrease(this.craftTime() * Mathf.sqrt((float)this.spawnCount));
            }
            if (this.progress >= 1.0f) {
                this.findTiles();
                for (int i = 0; i < this.spawnCount; ++i) {
                    this.spawnUnit();
                }
                this.consume();
                this.progress = 0.0f;
            }
        }

        public float getProgressIncrease(float baseTime) {
            return super.getProgressIncrease(baseTime) * this.speedMultiplier;
        }

        public boolean canConsume() {
            return this.unitRecipe() != null && this.unitType() != null && this.canSpawn() && Units.canCreate((Team)this.team, (UnitType)this.unitType());
        }

        public void buildConfiguration(Table table) {
            table.table(inner -> {
                inner.background(Tex.paneSolid);
                inner.slider(1.0f, (float)JumpGate.this.maxSpawnCount, 1.0f, 1.0f, arg_0 -> ((JumpGateBuild)this).configure(arg_0)).growX().row();
                inner.image().size(380.0f, 4.0f).color(Pal.accent).padTop(12.0f).padBottom(8.0f).growX().row();
                inner.pane(selectionTable -> {
                    for (int i = 0; i < JumpGate.this.recipeList.size; ++i) {
                        int finalI = i;
                        UnitRecipe unitRecipe = (UnitRecipe)JumpGate.this.recipeList.get(i);
                        UnitType type = unitRecipe.unitType;
                        selectionTable.button(button -> {
                            button.table(selection -> selection.stack(new Element[]{new DelaySlideBar((Prov<Color>)((Prov)() -> Pal.techBlue), (Prov<CharSequence>)((Prov)() -> "          " + Core.bundle.format("bar.unitcap", new Object[]{type.localizedName, this.team.data().countType(type), type.useUnitCap ? Units.getStringCap((Team)this.team) : "\u221e"})), () -> type.useUnitCap ? (float)this.team.data().countType(type) / (float)Units.getCap((Team)this.team) : 1.0f), new Table(image -> image.image(type.uiIcon).scaling(Scaling.fit).size(48.0f, 48.0f).padTop(6.0f).padBottom(6.0f).padLeft(8.0f)).left(), new Table(req -> {
                                req.right();
                                int j = 0;
                                for (ItemStack stack : unitRecipe.recipe.inputItem) {
                                    req.left().add((Element)JumpGate.this.getReqStack((UnlockableContent)stack.item, (Prov<CharSequence>)((Prov)() -> Strings.format((String)"@/@", (Object[])new Object[]{UI.formatAmount((long)((long)stack.amount * (long)this.spawnCount)), UI.formatAmount((long)this.items.get(stack.item))})), () -> this.items.has(stack.item, stack.amount * this.spawnCount))).pad(5.0f);
                                    if (++j % 2 != 0) continue;
                                    req.row();
                                }
                                for (ItemStack stack : unitRecipe.recipe.inputPayload) {
                                    req.left().add((Element)JumpGate.this.getReqStack(stack.item, (Prov<CharSequence>)((Prov)() -> this.lambda$buildConfiguration$6((PayloadStack)stack)), () -> this.lambda$buildConfiguration$7((PayloadStack)stack))).pad(5.0f);
                                    if (++j % 2 != 0) continue;
                                    req.row();
                                }
                            }).marginLeft(60.0f).marginTop(36.0f).marginBottom(4.0f).left()}).expandX().fillX()).growX();
                            button.update(() -> {
                                if (this.unitRecipe() == null) {
                                    button.setChecked(false);
                                } else {
                                    button.setChecked(unitRecipe == this.unitRecipe());
                                }
                            });
                        }, Styles.underlineb, () -> this.configure(finalI)).expandX().fillX().margin(0.0f).pad(4.0f);
                        selectionTable.row();
                    }
                }).scrollX(false).width(362.0f).maxHeight(400.0f).padRight(2.0f).row();
            }).width(380.0f);
        }

        public UnitType config() {
            return this.unitType();
        }

        public float progress() {
            return this.progress;
        }

        public float warmup() {
            return this.warmup;
        }

        public void draw() {
            super.draw();
            JumpGate.this.blockDrawer.get((Object)this, (Object)(this.unitType() != null && this.getCommandPosition() != null ? 1 : 0));
        }

        public byte version() {
            return 2;
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.speedMultiplier);
            write.f(this.progress);
            write.i(this.recipeIndex);
            TypeIO.writeVec2((Writes)write, (Vec2)this.command);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            if (revision == 2) {
                this.speedMultiplier = read.f();
                this.progress = read.f();
                this.recipeIndex = read.i();
                this.command = TypeIO.readVec2((Reads)read);
            }
        }

        private /* synthetic */ boolean lambda$buildConfiguration$7(PayloadStack stack) {
            return this.getPayloads().get(stack.item) >= stack.amount * this.spawnCount;
        }

        private /* synthetic */ CharSequence lambda$buildConfiguration$6(PayloadStack stack) {
            return Strings.format((String)"@/@", (Object[])new Object[]{UI.formatAmount((long)((long)stack.amount * (long)this.spawnCount)), UI.formatAmount((long)this.getPayloads().get(stack.item))});
        }
    }
}

