/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.turrets;

import arc.Core;
import arc.func.Boolf;
import arc.math.Mathf;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.gen.Building;
import mindustry.graphics.Pal;
import mindustry.type.Liquid;
import mindustry.ui.Bar;
import mindustry.world.blocks.defense.turrets.ContinuousTurret;
import mindustry.world.blocks.defense.turrets.Turret;
import mindustry.world.meta.Stat;
import mindustry.world.meta.StatUnit;
import newhorizon.content.NHColor;
import newhorizon.content.NHStatValues;
import newhorizon.content.NHStats;

public class ContinuousOverheatTurret
extends ContinuousTurret {
    public float overheatTime = 900.0f;
    public float overheatCoolAmount = 3.0f;
    public float slowDownReloadTime = 150.0f;
    public float chargeTime = 300.0f;
    public float maxHeatEffectChance = 0.3f;
    public Effect heatEffect = Fx.reactorsmoke;

    public ContinuousOverheatTurret(String name) {
        super(name);
        this.shootCone = 360.0f;
    }

    public void setStats() {
        super.setStats();
        this.stats.add(NHStats.overheatCooldown, this.overheatTime / this.overheatCoolAmount / 60.0f, StatUnit.seconds);
        if (this.coolant != null) {
            this.stats.remove(Stat.booster);
            this.stats.add(Stat.booster, NHStatValues.boosters(this.reload, this.coolant.amount, this.coolantMultiplier, true, (Boolf<Liquid>)((Boolf)l -> l.coolant && this.consumesLiquid((Liquid)l)), true));
        }
    }

    public void setBars() {
        super.setBars();
        this.addBar("charge", entity -> new Bar(() -> Core.bundle.format("nh.bar.charge", new Object[]{Strings.autoFixed((float)(Mathf.clamp((float)Mathf.clamp((float)(entity.chargeProgress / this.chargeTime)), (float)0.0f, (float)this.chargeTime) * 100.0f), (int)0)}), () -> Tmp.c1.set(NHColor.lightSky).lerp(NHColor.darkEnrFront, Mathf.clamp((float)(entity.chargeProgress / this.chargeTime))), () -> entity.chargeProgress / this.chargeTime));
        this.addBar("overheat", entity -> new Bar(() -> Core.bundle.format("nh.bar.overheat", new Object[]{Strings.autoFixed((float)(Mathf.clamp((float)(entity.overheat / this.overheatTime), (float)0.0f, (float)this.overheatTime) * 100.0f), (int)0)}), () -> entity.requireCompleteCooling ? Pal.redderDust : Pal.powerLight, () -> entity.overheat / this.overheatTime));
    }

    public class ContinuousOverheatTurretBuild
    extends ContinuousTurret.ContinuousTurretBuild {
        public float overheat;
        public float slowDownReload;
        public float chargeProgress;
        public boolean requireCompleteCooling;

        public ContinuousOverheatTurretBuild() {
            super((ContinuousTurret)ContinuousOverheatTurret.this);
            this.overheat = 0.0f;
            this.slowDownReload = 0.0f;
            this.chargeProgress = 0.0f;
            this.requireCompleteCooling = false;
        }

        public void updateTile() {
            this.updateCooldown();
            if (this.overheat < ContinuousOverheatTurret.this.overheatTime && !this.requireCompleteCooling) {
                super.updateTile();
                this.chargeProgress += this.edelta();
            } else {
                this.forceCoolDown();
            }
        }

        public void updateCooldown() {
            if (this.slowDownReload >= 1.0f) {
                this.slowDownReload -= Time.delta;
            } else {
                this.chargeProgress = Mathf.lerpDelta((float)this.chargeProgress, (float)0.0f, (float)0.2f);
                if (!this.requireCompleteCooling) {
                    this.coolDown();
                }
            }
            if (this.overheat > ContinuousOverheatTurret.this.overheatTime * 0.3f && Mathf.chanceDelta((double)(ContinuousOverheatTurret.this.maxHeatEffectChance * (this.requireCompleteCooling ? 1.0f : this.overheat / ContinuousOverheatTurret.this.overheatTime)))) {
                ContinuousOverheatTurret.this.heatEffect.at(this.x + (float)Mathf.range((int)(8 * ContinuousOverheatTurret.this.size / 2)), this.y + (float)Mathf.range((int)(8 * ContinuousOverheatTurret.this.size / 2)), this.rotation, ContinuousOverheatTurret.this.heatColor);
            }
        }

        public void forceCoolDown() {
            this.coolDown();
            if (this.soundLoop != null) {
                this.soundLoop.update(this.x, this.y, this.shouldActiveSound(), this.activeSoundVolume());
            }
            this.slowDownReload = 0.0f;
            this.chargeProgress = 0.0f;
            this.shootWarmup = ContinuousOverheatTurret.this.linearWarmup ? Mathf.approachDelta((float)this.shootWarmup, (float)0.0f, (float)ContinuousOverheatTurret.this.shootWarmupSpeed) : Mathf.lerpDelta((float)this.shootWarmup, (float)0.0f, (float)ContinuousOverheatTurret.this.shootWarmupSpeed);
            this.unit.tile((Building)this);
            this.unit.rotation(this.rotation);
            this.unit.team(this.team);
            this.curRecoil = Mathf.approachDelta((float)this.curRecoil, (float)0.0f, (float)(1.0f / ContinuousOverheatTurret.this.recoilTime));
            this.recoilOffset.trns(this.rotation, -Mathf.pow((float)this.curRecoil, (float)ContinuousOverheatTurret.this.recoilPow) * ContinuousOverheatTurret.this.recoil);
            if (this.logicControlTime > 0.0f) {
                this.logicControlTime -= Time.delta;
            }
            if (this.overheat <= 0.0f) {
                this.overheat = 0.0f;
                this.requireCompleteCooling = false;
            }
        }

        public float activeSoundVolume() {
            return this.shootWarmup;
        }

        public void coolDown() {
            if (this.overheat > 0.0f) {
                this.overheat -= ContinuousOverheatTurret.this.overheatCoolAmount * (1.0f + this.coolantEfficiency()) * Time.delta;
            }
        }

        protected void updateBullet(Turret.BulletEntry entry) {
            super.updateBullet(entry);
            entry.bullet.fdata = this.chargeProgress;
            this.slowDownReload = ContinuousOverheatTurret.this.slowDownReloadTime;
            this.overheat = Mathf.approachDelta((float)this.overheat, (float)(ContinuousOverheatTurret.this.overheatTime + 0.05f), (float)(this.efficiency * this.timeScale / (1.0f + (this.liquids.current() == null ? 0.0f : this.liquids.current().heatCapacity))));
            if (this.overheat > ContinuousOverheatTurret.this.overheatTime) {
                this.requireCompleteCooling = true;
            }
        }

        public float coolantEfficiency() {
            return this.liquids.current() == null ? 0.0f : this.liquids.current().heatCapacity;
        }

        public void write(Writes write) {
            super.write(write);
            write.f(this.overheat);
            write.f(this.slowDownReload);
            write.f(this.chargeProgress);
            write.bool(this.requireCompleteCooling);
        }

        public void read(Reads read, byte revision) {
            super.read(read, revision);
            this.overheat = read.f();
            this.slowDownReload = read.f();
            this.chargeProgress = read.f();
            this.requireCompleteCooling = read.bool();
        }
    }
}

