/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.block.turrets;

import arc.func.FloatFloatf;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.StatusEffects;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.game.Team;
import mindustry.graphics.Drawf;
import mindustry.type.Liquid;
import mindustry.world.blocks.defense.turrets.TractorBeamTurret;
import newhorizon.content.NHFx;
import newhorizon.util.graphic.DrawFunc;

public class Webber
extends TractorBeamTurret {
    public float circleRad = 12.0f;
    public float num = 3.0f;
    public float scale = 6.0f;
    public float mag = 8.0f;
    public float wavelength = 6.0f;
    public float stroke = 1.45f;
    public float scaleSpeedPerMove = 0.75f;
    public float rotateSpeedScl = 0.85f;
    public float weaveSpeedScl = 0.3f;
    public float zScl = 0.25f;
    public int circleNum = 2;
    public float strokeScl = 0.65f;
    public Interp moveInterp = Interp.pow3In;
    public float moveTime = 60.0f;
    public float effectChance = 0.13f;
    public Effect affectedEffect = NHFx.hitSpark;
    public FloatFloatf cal = d -> 1.0f;

    public Webber(String name) {
        super(name);
        this.status = StatusEffects.unmoving;
        this.statusDuration = 30.0f;
    }

    public class WebberBuild
    extends TractorBeamTurret.TractorBeamBuild {
        public WebberBuild() {
            super((TractorBeamTurret)Webber.this);
        }

        public void updateTile() {
            float eff = this.efficiency * this.coolantMultiplier;
            float edelta = eff * this.delta();
            if (this.timer(Webber.this.timerTarget, Webber.this.retargetTime)) {
                this.target = Units.bestEnemy((Team)this.team, (float)this.x, (float)this.y, (float)Webber.this.range, u -> u.checkTarget(Webber.this.targetAir, Webber.this.targetGround), (u, x, y) -> -u.type.speed * (u.speedMultiplier() + 1.0f) * u.type.accel + u.health * 5.0E-5f);
            }
            if (this.target != null && Webber.this.coolant != null) {
                float maxUsed = Webber.this.coolant.amount;
                Liquid liquid = this.liquids.current();
                float used = Math.min(Math.min(this.liquids.get(liquid), maxUsed * Time.delta), Math.max(0.0f, 1.0f / this.coolantMultiplier / liquid.heatCapacity));
                this.liquids.remove(liquid, used);
                if (Mathf.chance((double)(0.06 * (double)used))) {
                    Webber.this.coolEffect.at(this.x + Mathf.range((float)((float)(Webber.this.size * 8) / 2.0f)), this.y + Mathf.range((float)((float)(Webber.this.size * 8) / 2.0f)));
                }
                this.coolantMultiplier = 1.0f + used * liquid.heatCapacity * this.coolantMultiplier;
            }
            this.any = false;
            if (this.target != null && this.target.within((Position)this, Webber.this.range + this.target.hitSize / 2.0f) && this.target.team() != this.team && this.target.checkTarget(Webber.this.targetAir, Webber.this.targetGround) && this.efficiency > 0.02f) {
                if (!Vars.headless) {
                    if (Mathf.chanceDelta((double)Webber.this.effectChance)) {
                        Webber.this.affectedEffect.at(this.target.x + Mathf.range((float)this.target.hitSize), this.target.y + Mathf.range((float)this.target.hitSize), Webber.this.laserColor);
                    }
                    Vars.control.sound.loop(Webber.this.shootSound, (Position)this, Webber.this.shootSoundVolume);
                }
                float dst = this.dst((Position)this.target);
                float dest = this.angleTo((Position)this.target);
                this.rotation = Angles.moveToward((float)this.rotation, (float)dest, (float)(Webber.this.rotateSpeed * edelta));
                this.lastX = this.target.x;
                this.lastY = this.target.y;
                this.strength = Mathf.lerpDelta((float)this.strength, (float)1.0f, (float)0.1f);
                if (Angles.within((float)this.rotation, (float)dest, (float)Webber.this.shootCone)) {
                    if (Webber.this.damage > 0.0f) {
                        this.target.damageContinuous(Webber.this.damage * eff);
                    }
                    if (Webber.this.status != StatusEffects.none) {
                        this.target.apply(Webber.this.status, Webber.this.statusDuration);
                    }
                    this.any = true;
                    this.target.impulseNet(Tmp.v1.set((Position)this).sub((Position)this.target).limit((Webber.this.force + (1.0f - dst / Webber.this.range) * Webber.this.scaledForce) * edelta).scl(Webber.this.cal.get(dst / Webber.this.range)));
                }
            } else {
                this.strength = Mathf.lerpDelta((float)this.strength, (float)0.0f, (float)0.1f);
            }
        }

        public void draw() {
            Draw.rect((TextureRegion)Webber.this.baseRegion, (float)this.x, (float)this.y);
            Drawf.shadow((TextureRegion)Webber.this.region, (float)(this.x - (float)Webber.this.size / 2.0f), (float)(this.y - (float)Webber.this.size / 2.0f), (float)(this.rotation - 90.0f));
            Draw.rect((TextureRegion)Webber.this.region, (float)this.x, (float)this.y, (float)(this.rotation - 90.0f));
            if (this.any) {
                Draw.color((Color)Webber.this.laserColor, (Color)Color.white, (float)Mathf.absin((float)4.0f, (float)0.15f));
                Draw.z((float)105.0f);
                float ang = this.angleTo(this.lastX, this.lastY);
                float phaseOffset = 360.0f / Webber.this.num;
                Lines.stroke((float)(Webber.this.stroke * this.strength));
                Tmp.v2.trns(ang, Webber.this.shootLength);
                Lines.circle((float)(this.x + Angles.trnsx((float)ang, (float)Webber.this.shootLength)), (float)(this.y + Angles.trnsy((float)ang, (float)Webber.this.shootLength)), (float)Webber.this.circleRad);
                int i = 0;
                while ((float)i < Webber.this.num) {
                    float a = phaseOffset * (float)i + Time.time * Webber.this.rotateSpeedScl;
                    Lines.stroke((float)(Webber.this.stroke * this.strength * (1.0f + (Angles.angleDist((float)a, (float)(this.rotation - 180.0f)) / 90.0f - 1.0f) * Webber.this.zScl)));
                    Tmp.v1.trns(a, Webber.this.circleRad);
                    DrawFunc.drawSine2Modifier(this.x + Tmp.v2.x + Tmp.v1.x, this.y + Tmp.v2.y + Tmp.v1.y, this.lastX, this.lastY, Time.time * Webber.this.weaveSpeedScl, Webber.this.scale, Webber.this.scaleSpeedPerMove, phaseOffset * ((float)Math.PI / 180), Webber.this.mag, Webber.this.wavelength, (x1, y1) -> Fill.circle((float)x1, (float)y1, (float)(Lines.getStroke() * 2.0f)));
                    Fill.circle((float)this.lastX, (float)this.lastY, (float)(Lines.getStroke() * 1.35f));
                    ++i;
                }
                float timeDelta = Webber.this.moveTime / (float)Webber.this.circleNum;
                float targetCircleRad = (Webber.this.circleRad + this.target.hitSize) * 0.75f;
                for (int i2 = 0; i2 < Webber.this.circleNum; ++i2) {
                    float f = Webber.this.moveInterp.apply(DrawFunc.cycle((float)i2 * timeDelta, Webber.this.moveTime));
                    Lines.stroke((float)(Webber.this.stroke * this.strength * (1.0f - Webber.this.strokeScl * (1.0f - f))));
                    Lines.circle((float)Mathf.lerp((float)this.lastX, (float)(this.x + Tmp.v2.x), (float)f), (float)Mathf.lerp((float)this.lastY, (float)(this.y + Tmp.v2.y), (float)f), (float)Mathf.lerp((float)targetCircleRad, (float)Webber.this.circleRad, (float)f));
                }
                Lines.stroke((float)(Webber.this.stroke * this.strength));
                Lines.circle((float)this.lastX, (float)this.lastY, (float)targetCircleRad);
            }
        }
    }
}

