/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.bullets;

import arc.graphics.Color;
import arc.math.Mathf;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.entities.Lightning;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Bullet;

public class AdaptedLightningBulletType
extends BulletType {
    public AdaptedLightningBulletType() {
        this.damage = 1.0f;
        this.speed = 0.0f;
        this.lifetime = 1.0f;
        this.hitEffect = this.despawnEffect = Fx.none;
        this.shootEffect = this.despawnEffect;
        this.despawnHit = false;
        this.keepVelocity = false;
        this.hittable = false;
        this.status = StatusEffects.shocked;
    }

    protected float calculateRange() {
        return ((float)this.lightningLength + (float)this.lightningLengthRand / 2.0f) * 6.0f;
    }

    public float estimateDPS() {
        return super.estimateDPS() * Math.max((float)this.lightningLength / 10.0f, 1.0f);
    }

    public void draw(Bullet b) {
    }

    public void init(Bullet b) {
        Lightning.create((Bullet)b, (Color)this.lightningColor, (float)this.damage, (float)b.x, (float)b.y, (float)b.rotation(), (int)(this.lightningLength + Mathf.random((int)this.lightningLengthRand)));
    }
}

