/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.bullets;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.entities.Effect;
import mindustry.entities.Mover;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Hitboxc;
import mindustry.graphics.Drawf;

public class DelayedPointBulletType
extends BulletType {
    protected static float cdist = 0.0f;
    protected static Position result;
    protected static Color[] colors;
    protected static float lengthFalloff;
    public static Effect laser;
    public float errorCorrectionRadius = 16.0f;
    public float width = 8.0f;
    public float trailSpacing = 10.0f;
    public float delayEffectLifeTime = 30.0f;

    public DelayedPointBulletType() {
        this.scaleLife = true;
        this.speed = 0.001f;
        this.collides = false;
        this.reflectable = false;
        this.keepVelocity = false;
        this.absorbable = false;
        this.hittable = false;
        this.despawnHit = false;
        this.setDefaults = false;
    }

    public void init() {
        super.init();
        this.lifetime = this.range / this.speed;
        this.drawSize = this.range * 2.0f;
    }

    public void init(Bullet b) {
        float px = b.x + b.lifetime * b.vel.x;
        float py = b.y + b.lifetime * b.vel.y;
        float rot = b.rotation();
        cdist = 0.0f;
        result = null;
        Units.nearbyEnemies((Team)b.team, (float)(px - this.errorCorrectionRadius), (float)(py - this.errorCorrectionRadius), (float)(this.errorCorrectionRadius * 2.0f), (float)(this.errorCorrectionRadius * 2.0f), e -> {
            if (e.dead() || !e.checkTarget(this.collidesAir, this.collidesGround) || !e.hittable()) {
                return;
            }
            e.hitbox(Tmp.r1);
            if (!Tmp.r1.contains(px, py)) {
                return;
            }
            float dst = e.dst(px, py) - e.hitSize;
            if (result == null || dst < cdist) {
                result = e;
                cdist = dst;
            }
        });
        if (result == null) {
            result = new Vec2(px, py);
        }
        b.data = result;
        b.lifetime = this.delayEffectLifeTime;
        b.rotation(rot);
        super.init(b);
    }

    public void draw(Bullet b) {
        if (!(b.data instanceof Position)) {
            return;
        }
        Position target = (Position)b.data();
        float tX = target.getX();
        float tY = target.getY();
        float cwidth = this.width / 1.4f * b.fout();
        float compound = 1.0f;
        for (int i = 0; i < colors.length; ++i) {
            Draw.color((Color)Tmp.c1.set(this.hitColor).lerp(colors[i], (float)i * 0.3f + 0.1f));
            float s = (cwidth *= lengthFalloff) * (b.fout() * 2.0f + 1.0f) / 3.0f;
            Lines.stroke((float)s);
            Lines.line((float)b.x, (float)b.y, (float)tX, (float)tY, (boolean)false);
            Fill.circle((float)b.x, (float)b.y, (float)(1.5f * s));
            Fill.circle((float)tX, (float)tY, (float)(1.5f * s));
            Fill.circle((float)Mathf.lerp((float)b.x, (float)tX, (float)b.fin()), (float)Mathf.lerp((float)b.y, (float)tY, (float)b.fin()), (float)(2.25f * (s + this.width / 5.0f) * (1.0f + b.fout()) * 0.5f * b.fin()));
            compound *= lengthFalloff;
        }
        Draw.reset();
        Drawf.light((float)b.x, (float)b.y, (float)tX, (float)tY, (float)(cwidth * 1.4f * b.fout()), (Color)colors[0], (float)0.6f);
    }

    public void despawned(Bullet b) {
        if (!(b.data instanceof Position) || !b.isAdded()) {
            return;
        }
        Position target = (Position)b.data();
        float tX = target.getX();
        float tY = target.getY();
        float rot = b.rotation();
        Geometry.iterateLine((float)0.0f, (float)b.x, (float)b.y, (float)tX, (float)tY, (float)this.trailSpacing, (x1, y1) -> this.trailEffect.at(x1, y1, rot, this.trailColor));
        laser.at(b.x, b.y, this.width, this.hitColor, (Object)target);
        b.set(tX, tY);
        if (target instanceof Hitboxc) {
            this.hitEntity(b, (Hitboxc)target, 0.0f);
            if (!this.despawnHit) {
                this.hit(b, tX, tY);
            }
        } else if (this.collidesTiles) {
            Building build = Vars.world.buildWorld(tX, tY);
            if (build != null && build.team != b.team) {
                build.collision(b);
                if (!this.despawnHit) {
                    this.hit(b, build.x, build.y);
                }
            }
        } else if (this.despawnHit) {
            this.hit(b, tX, tY);
        }
        b.hit = true;
        super.despawned(b);
    }

    public Bullet create(Entityc owner, Team team, float x, float y, float angle, float damage, float velocityScl, float lifetimeScl, Object data, Mover mover, float aimX, float aimY) {
        Bullet bullet = Bullet.create();
        bullet.type = this;
        bullet.owner = owner;
        bullet.team = team;
        bullet.time = 0.0f;
        bullet.originX = x;
        bullet.originY = y;
        bullet.aimTile = Vars.world.tileWorld(aimX, aimY);
        bullet.aimX = aimX;
        bullet.aimY = aimY;
        bullet.initVel(angle, this.speed * velocityScl);
        bullet.set(x - bullet.vel.x * Time.delta, y - bullet.vel.y * Time.delta);
        bullet.lifetime = this.lifetime * lifetimeScl;
        bullet.data = data;
        bullet.hitSize = this.hitSize;
        bullet.mover = mover;
        bullet.damage = (damage < 0.0f ? this.damage : damage) * bullet.damageMultiplier();
        if (bullet.trail != null) {
            bullet.trail.clear();
        }
        bullet.add();
        return bullet;
    }

    public void handlePierce(Bullet b, float initialHealth, float x, float y) {
    }

    static {
        colors = new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.0f).a(-5.0f), new Color(1.0f, 1.0f, 1.0f, 1.0f), new Color(1.0f, 1.0f, 1.0f, 1.0f)};
        lengthFalloff = 0.5f;
        laser = new Effect(60.0f, 2000.0f, b -> {
            if (!(b.data instanceof Position)) {
                return;
            }
            Position target = (Position)b.data();
            float tX = target.getX();
            float tY = target.getY();
            float cwidth = b.rotation;
            float compound = 1.0f;
            for (int i = 0; i < colors.length; ++i) {
                Draw.color((Color)Tmp.c1.set(b.color).lerp(colors[i], (float)i * 0.3f + 0.1f));
                Lines.stroke((float)((cwidth *= lengthFalloff) * b.fout()));
                Lines.line((float)b.x, (float)b.y, (float)tX, (float)tY, (boolean)false);
                Fill.circle((float)b.x, (float)b.y, (float)(1.25f * cwidth * b.fout()));
                Fill.circle((float)tX, (float)tY, (float)(1.25f * cwidth * b.fout()));
                compound *= lengthFalloff;
            }
            Draw.reset();
            Drawf.light((float)b.x, (float)b.y, (float)tX, (float)tY, (float)(cwidth * 1.4f * b.fout()), (Color)colors[0], (float)0.6f);
        }).followParent(false);
    }
}

