/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.bullets;

import arc.Core;
import arc.Events;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.scene.ui.layout.Table;
import arc.util.Strings;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.StatusEffects;
import mindustry.core.World;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Damage;
import mindustry.entities.Fires;
import mindustry.entities.bullet.BulletType;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Healthc;
import mindustry.gen.Hitboxc;
import mindustry.gen.Shieldc;
import mindustry.gen.Unit;
import mindustry.world.Tile;
import mindustry.world.meta.StatUnit;
import newhorizon.content.NHStatValues;
import newhorizon.expand.block.turrets.AdaptTurret;

public interface TypeDamageBulletType {
    public static final EventType.UnitDamageEvent bulletDamageEvent = new EventType.UnitDamageEvent();

    public String bundleName();

    default public void setDamage(BulletType type, float kinetic, float energy) {
        type.damage = kinetic;
        type.shieldDamageMultiplier = energy / kinetic;
    }

    default public void setDamage(BulletType type, float range, float splash, float kinetic, float energy) {
        type.damage = kinetic;
        type.splashDamage = splash;
        type.splashDamageRadius = range;
        type.shieldDamageMultiplier = energy / kinetic;
    }

    default public void setDamage(BulletType type, float range, float kinetic, float energy) {
        type.damage = kinetic;
        type.splashDamage = kinetic;
        type.splashDamageRadius = range;
        type.shieldDamageMultiplier = energy / kinetic;
    }

    default public float getKineticMultiplier(BulletType type) {
        return 1.0f;
    }

    default public float getEnergyMultiplier(BulletType type) {
        return type.shieldDamageMultiplier;
    }

    default public float getKineticDamage(BulletType type) {
        return type.damage * this.getKineticMultiplier(type);
    }

    default public float getEnergyDamage(BulletType type) {
        return type.damage * this.getEnergyMultiplier(type);
    }

    default public float getSplashKineticDamage(BulletType type) {
        return type.splashDamage * this.getKineticMultiplier(type);
    }

    default public float getSplashEnergyDamage(BulletType type) {
        return type.splashDamage * this.getEnergyMultiplier(type);
    }

    default public float getContinuousKineticDamage(BulletType type) {
        return type.continuousDamage() * this.getKineticMultiplier(type);
    }

    default public float getContinuousEnergyDamage(BulletType type) {
        return type.continuousDamage() * this.getEnergyMultiplier(type);
    }

    default public float kineticDamage(BulletType type, Bullet b, float damage) {
        float extraMultiplier = 1.0f;
        Entityc entityc = b.owner;
        if (entityc instanceof AdaptTurret) {
            AdaptTurret adaptTurret = (AdaptTurret)entityc;
            extraMultiplier = adaptTurret.kineticModifier();
        }
        return damage * this.getKineticMultiplier(type) * extraMultiplier;
    }

    default public float energyDamage(BulletType type, Bullet b, float damage) {
        float extraMultiplier = 1.0f;
        Entityc entityc = b.owner;
        if (entityc instanceof AdaptTurret) {
            AdaptTurret adaptTurret = (AdaptTurret)entityc;
            extraMultiplier = adaptTurret.energyModifier();
        }
        return damage * this.getEnergyMultiplier(type) * extraMultiplier;
    }

    default public float getTotalDamageToUnit(BulletType type, Bullet b, float damage, Healthc entity) {
        if (entity instanceof Unit) {
            Unit unit = (Unit)entity;
            if (unit.type != null) {
                float shield = Math.max(unit.shield(), 0.0f);
                return Mathf.clamp((float)(shield / this.energyDamage(type, b, damage))) * this.energyDamage(type, b, damage) + Math.max((this.energyDamage(type, b, damage) - Math.max(shield, 0.0f)) / this.energyDamage(type, b, damage), 0.0f) * this.kineticDamage(type, b, damage);
            }
        }
        return damage;
    }

    default public void applyExtraMultiplier(Bullet b) {
        Entityc entityc = b.owner;
        if (entityc instanceof AdaptTurret) {
            AdaptTurret adaptTurret = (AdaptTurret)entityc;
            b.lifetime(b.lifetime() * adaptTurret.rangeModifier());
        }
    }

    default public void buildStat(BulletType type, UnlockableContent t, Table bt, boolean compact) {
        bt.row();
        if (Core.bundle.getOrNull(this.bundleName()) != null) {
            bt.add((CharSequence)("[accent]" + Core.bundle.get("nh.bullet." + this.bundleName() + ".desc") + "[]")).wrap().fillX().padTop(4.0f).padBottom(8.0f).width(500.0f);
            bt.row();
        }
        if (this.getKineticMultiplier(type) > 0.0f || this.getEnergyMultiplier(type) > 0.0f) {
            if (type.continuousDamage() > 0.0f) {
                bt.add((CharSequence)(Core.bundle.format("nh.damage-detail", new Object[]{Float.valueOf(this.getContinuousKineticDamage(type)), Float.valueOf(this.getContinuousEnergyDamage(type))}) + StatUnit.perSecond.localized()));
            } else if (type.damage > 0.0f) {
                bt.add((CharSequence)Core.bundle.format("nh.damage-detail", new Object[]{Float.valueOf(this.getKineticDamage(type)), Float.valueOf(this.getEnergyDamage(type))}));
            }
            bt.row();
        }
        if (type.splashDamage > 0.0f && type.splashDamageRadius > 0.0f) {
            bt.add((CharSequence)Core.bundle.format("nh.splash-detail", new Object[]{Float.valueOf(this.getSplashKineticDamage(type)), Float.valueOf(this.getSplashEnergyDamage(type)), Strings.autoFixed((float)(type.splashDamageRadius / 8.0f), (int)1)}));
        }
        NHStatValues.buildSharedBulletTypeStat(type, t, bt, compact);
    }

    /*
     * Unable to fully structure code
     */
    default public void typedHitEntity(BulletType type, Bullet b, Hitboxc entity, float health) {
        if (!(entity instanceof Unit)) ** GOTO lbl-1000
        u = (Unit)entity;
        if (u.dead) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = wasDead = false;
        }
        if (entity instanceof Healthc) {
            h = (Healthc)entity;
            damage = this.getTotalDamageToUnit(type, b, b.damage, h);
            if (entity instanceof Shieldc) {
                s = (Shieldc)entity;
                v1 = Math.max(s.shield(), 0.0f);
            } else {
                v1 = shield = 0.0f;
            }
            if (type.maxDamageFraction > 0.0f) {
                cap = h.maxHealth() * type.maxDamageFraction + shield;
                damage = Math.min(damage, cap);
                health = Math.min(health, cap);
            } else {
                health += shield;
            }
            if (type.lifesteal > 0.0f && (var10_12 = b.owner) instanceof Healthc) {
                o = (Healthc)var10_12;
                result = Math.max(Math.min(h.health(), damage), 0.0f);
                o.heal(result * type.lifesteal);
            }
            if (type.pierceArmor) {
                h.damagePierce(damage);
            } else {
                h.damage(damage);
            }
        }
        if (entity instanceof Unit) {
            unit = (Unit)entity;
            Tmp.v3.set((Position)unit).sub((Position)b).nor().scl(type.knockback * 80.0f);
            if (type.impact) {
                Tmp.v3.setAngle(b.rotation() + (type.knockback < 0.0f ? 180.0f : 0.0f));
            }
            unit.impulse(Tmp.v3);
            unit.apply(type.status, type.statusDuration);
            Events.fire((Object)TypeDamageBulletType.bulletDamageEvent.set(unit, b));
        }
        if (!wasDead && entity instanceof Unit) {
            unit = (Unit)entity;
            if (unit.dead) {
                Events.fire((Object)new EventType.UnitBulletDestroyEvent(unit, b));
            }
        }
        type.handlePierce(b, health, entity.x(), entity.y());
    }

    default public void typedCreateSplash(BulletType type, Bullet b, float x, float y) {
        if (type.splashDamageRadius > 0.0f && !b.absorbed) {
            Damage.tileDamage((Team)b.team, (int)World.toTile((float)x), (int)World.toTile((float)y), (float)(type.splashDamageRadius / 8.0f), (float)(type.splashDamage * b.type.buildingDamageMultiplier), (Bullet)b);
            Damage.damageUnits((Team)b.team, (float)x, (float)y, (float)type.splashDamageRadius, (float)0.0f, unit -> unit.within((Position)b, type.splashDamageRadius + unit.hitSize / 2.0f) && (unit.isGrounded() && type.collidesGround || unit.isFlying() && type.collidesAir), unit -> {
                unit.damage(this.getTotalDamageToUnit(type, b, type.splashDamage * b.damageMultiplier(), (Healthc)unit));
                if (type.status != StatusEffects.none) {
                    unit.apply(type.status, type.statusDuration);
                }
            });
            if (type.heals()) {
                Vars.indexer.eachBlock(b.team, x, y, type.splashDamageRadius, Building::damaged, other -> {
                    type.healEffect.at(other.x, other.y, 0.0f, type.healColor, (Object)other.block);
                    other.heal(type.healPercent / 100.0f * other.maxHealth() + type.healAmount);
                });
            }
            if (type.makeFire) {
                Vars.indexer.eachBlock(null, x, y, type.splashDamageRadius, other -> other.team != b.team, other -> Fires.create((Tile)other.tile));
            }
        }
    }
}

