/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.bullets;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Position;
import arc.scene.ui.layout.Table;
import arc.util.Strings;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.ctype.UnlockableContent;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.bullet.PointLaserBulletType;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import mindustry.gen.Hitboxc;
import mindustry.graphics.Drawf;
import mindustry.world.meta.StatUnit;
import newhorizon.NHSetting;
import newhorizon.content.NHColor;
import newhorizon.content.NHFx;
import newhorizon.content.NHStatValues;
import newhorizon.expand.bullets.TypeDamageBulletType;
import newhorizon.util.feature.PosLightning;
import newhorizon.util.func.NHFunc;
import newhorizon.util.graphic.DrawFunc;

public class UpgradePointLaserBulletType
extends PointLaserBulletType
implements TypeDamageBulletType {
    private final Color tmpColor = new Color();
    public Color from = NHColor.lightSky;
    public Color to = NHColor.darkEnrColor;
    public float oscScl = 2.0f;
    public float oscMag = 0.3f;
    public float chargeReload = 300.0f;
    public float lerpReload = 10.0f;
    public float maxDamageMultiplier = 5.0f;
    public float damageInterval = 5.0f;
    public String bundleName = "nh.bullet.desc";

    public UpgradePointLaserBulletType() {
        this.damage = 0.0f;
    }

    public boolean charged(Bullet b) {
        return b.fdata > this.chargeReload;
    }

    public Color getColor(Bullet b) {
        return this.tmpColor.set(this.from).lerp(this.to, this.warmup(b));
    }

    public float warmup(Bullet b) {
        return Mathf.curve((float)b.fdata, (float)(this.chargeReload - this.lerpReload / 2.0f), (float)(this.chargeReload + this.lerpReload / 2.0f));
    }

    public float continuousDamage() {
        return this.damage / this.damageInterval * 60.0f;
    }

    public float damageMultiplier(Bullet b) {
        return 1.0f + this.warmup(b) * this.maxDamageMultiplier;
    }

    public void update(Bullet b) {
        this.updateTrail(b);
        this.updateTrailEffects(b);
        this.updateBulletInterval(b);
        if (b.timer.get(0, this.damageInterval)) {
            Damage.collidePoint((Bullet)b, (Team)b.team, (Effect)this.hitEffect, (float)b.aimX, (float)b.aimY);
        }
        b.fdata = Math.min(b.fdata, this.chargeReload + this.lerpReload / 2.0f);
        if (this.charged(b) && !Vars.headless && b.timer(3, 3.0f)) {
            PosLightning.createEffect((Position)b, (Position)Tmp.v1.set(b.aimX, b.aimY), this.getColor(b), 1, 2.0f);
            if (Mathf.chance((double)0.25)) {
                NHFx.hitSparkLarge.at(b.x, b.y, this.tmpColor);
            }
        }
    }

    public void hitEntity(Bullet b, Hitboxc entity, float health) {
        this.typedHitEntity((BulletType)this, b, entity, health);
    }

    public void createSplashDamage(Bullet b, float x, float y) {
        this.typedCreateSplash((BulletType)this, b, x, y);
    }

    public void draw(Bullet b) {
        float darkenPartWarmup = this.warmup(b);
        float stroke = b.fslope() * (1.0f - this.oscMag + Mathf.absin((float)Time.time, (float)this.oscScl, (float)this.oscMag)) * (darkenPartWarmup + 1.0f) * 5.0f;
        if (this.trailLength > 0 && b.trail != null) {
            float z = Draw.z();
            Draw.z((float)(z - 1.0E-4f));
            b.trail.draw(this.getColor(b), stroke);
            Draw.z((float)z);
        }
        Draw.color((Color)this.getColor(b));
        DrawFunc.basicLaser(b.x, b.y, b.aimX, b.aimY, stroke);
        Draw.color((Color)Color.white);
        DrawFunc.basicLaser(b.x, b.y, b.aimX, b.aimY, stroke * 0.64f * (2.0f + darkenPartWarmup) / 3.0f);
        Drawf.light((float)b.aimX, (float)b.aimY, (float)b.x, (float)b.y, (float)stroke, (Color)this.tmpColor, (float)0.76f);
        Drawf.light((float)b.x, (float)b.y, (float)(stroke * 4.0f), (Color)this.tmpColor, (float)0.76f);
        Drawf.light((float)b.aimX, (float)b.aimY, (float)(stroke * 3.0f), (Color)this.tmpColor, (float)0.76f);
        Draw.color((Color)this.tmpColor);
        if (this.charged(b)) {
            float qW = Mathf.curve((float)this.warmup(b), (float)0.5f, (float)0.7f);
            for (int s : Mathf.signs) {
                Drawf.tri((float)b.x, (float)b.y, (float)6.0f, (float)(21.0f * qW), (float)((float)(90 * s) + Time.time * 1.8f));
            }
            for (int s : Mathf.signs) {
                Drawf.tri((float)b.x, (float)b.y, (float)7.2f, (float)(25.0f * qW), (float)((float)(90 * s) + Time.time * -1.1f));
            }
        }
        if (NHSetting.enableDetails()) {
            int particles = 44;
            float particleLife = 74.0f;
            float particleLen = 7.5f;
            Rand rand = NHFunc.rand(b.id);
            float base = Time.time / particleLife;
            for (int i = 0; i < particles; ++i) {
                float fin = (rand.random(1.0f) + base) % 1.0f;
                float fout = 1.0f - fin;
                float fslope = NHFx.fslope(fin);
                float len = rand.random(particleLen * 0.7f, particleLen * 1.3f) * Mathf.curve((float)fin, (float)0.2f, (float)0.9f) * (darkenPartWarmup / 2.5f + 1.0f);
                float centerDeg = rand.random((float)Math.PI);
                Tmp.v1.trns(b.rotation(), Interp.pow3In.apply(fin) * (float)rand.random(44, 77) - (float)rand.range(11) - 8.0f, (((float)rand.random(22, 35) * (fout + 1.0f) / 2.0f + 2.0f) / (3.0f * fin / 7.0f + 1.3f) - 1.0f + (float)rand.range(4)) * Mathf.cos((float)centerDeg));
                float angle = Mathf.slerp((float)(Tmp.v1.angle() - 180.0f), (float)b.rotation(), (float)Interp.pow2Out.apply(fin));
                Tmp.v1.scl(darkenPartWarmup / 3.7f + 1.0f);
                Tmp.v1.add((Position)b);
                Draw.color((Color)Tmp.c2.set(this.tmpColor), (Color)Color.white, (float)(fin * 0.7f));
                Lines.stroke((float)(Mathf.curve((float)fslope, (float)0.0f, (float)0.42f) * 1.4f * b.fslope() * Mathf.curve((float)fin, (float)0.0f, (float)0.6f)));
                Lines.lineAngleCenter((float)Tmp.v1.x, (float)Tmp.v1.y, (float)angle, (float)len);
            }
        }
        if (darkenPartWarmup > 0.005f) {
            this.tmpColor.lerp(Color.black, 0.86f);
            Draw.color((Color)this.tmpColor);
            DrawFunc.basicLaser(b.x, b.y, b.aimX, b.aimY, stroke * 0.55f * darkenPartWarmup);
            Draw.z((float)99.89f);
            DrawFunc.basicLaser(b.x, b.y, b.aimX, b.aimY, stroke * 0.6f * darkenPartWarmup);
            Draw.z((float)100.0f);
        }
        Draw.reset();
    }

    @Override
    public String bundleName() {
        return "bundleName";
    }

    @Override
    public void buildStat(BulletType type, UnlockableContent t, Table bt, boolean compact) {
        if (Core.bundle.getOrNull(this.bundleName) != null) {
            bt.add((CharSequence)Core.bundle.get(this.bundleName)).wrap().fillX().padTop(8.0f).padBottom(8.0f).width(500.0f);
            bt.row();
        }
        bt.add((CharSequence)(Core.bundle.format("nh.damage-detail", new Object[]{Float.valueOf(this.getContinuousKineticDamage((BulletType)this)), Float.valueOf(this.getContinuousEnergyDamage((BulletType)this))}) + StatUnit.perSecond.localized()));
        bt.row();
        bt.add((CharSequence)Core.bundle.format("nh.bullet-charge", new Object[]{"1", Strings.autoFixed((float)this.maxDamageMultiplier, (int)1)}));
        bt.row();
        NHStatValues.buildSharedBulletTypeStat((BulletType)this, t, bt, compact);
    }
}

