/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.bullets.adapt;

import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.struct.FloatSeq;
import arc.util.Time;
import mindustry.Vars;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Bullet;
import mindustry.gen.Hitboxc;
import mindustry.graphics.Trail;
import newhorizon.expand.bullets.TypeDamageBulletType;

public class AdaptBulletType
extends BasicBulletType
implements TypeDamageBulletType {
    public String bundleName = "bullet-name";
    public boolean hasTracer = false;
    public float tracerRandRange = 8.0f;
    public float tracerUpdateInterval = 1.0f;
    public boolean velocityDecay = false;
    public float velocityStaticTime = 60.0f;
    public boolean hasAccel = false;
    public float velocityBegin = 0.1f;
    public float velocityIncrease = 0.0f;
    public float accelerateBegin = 0.1f;
    public float accelerateEnd = 0.6f;
    public Interp accelInterp = Interp.linear;
    public boolean artilleryTrail = false;
    public float trailMult = 1.0f;
    public float trailSize = 4.0f;

    @Override
    public String bundleName() {
        return this.bundleName;
    }

    public void init(Bullet b) {
        super.init(b);
        this.applyExtraMultiplier(b);
        if (this.velocityDecay) {
            b.lifetime *= 2.0f;
            b.fdata = b.lifetime;
            b.lifetime += this.velocityStaticTime;
            b.data = Float.valueOf(b.vel.len() / this.speed);
        }
    }

    protected float calculateRange() {
        if (!this.hasAccel) {
            return super.calculateRange();
        }
        if (this.velocityBegin < 0.0f) {
            this.velocityBegin = this.speed;
        }
        boolean computeRange = this.rangeOverride < 0.0f;
        float cal = 0.0f;
        FloatSeq speeds = new FloatSeq();
        for (float i = 0.0f; i <= 1.0f; i += 0.05f) {
            float s = this.velocityBegin + this.accelInterp.apply(Mathf.curve((float)i, (float)this.accelerateBegin, (float)this.accelerateEnd)) * this.velocityIncrease;
            speeds.add(s);
            if (!computeRange) continue;
            cal += s * this.lifetime * 0.05f;
        }
        this.speed = speeds.sum() / (float)speeds.size;
        if (computeRange) {
            cal += 1.0f;
        }
        return cal;
    }

    public void hitEntity(Bullet b, Hitboxc entity, float health) {
        this.typedHitEntity((BulletType)this, b, entity, health);
    }

    public void createSplashDamage(Bullet b, float x, float y) {
        this.typedCreateSplash((BulletType)this, b, x, y);
    }

    public void update(Bullet b) {
        if (this.velocityDecay) {
            float f;
            Vec2 vec2 = b.vel;
            float f2 = Interp.reverse.apply(b.time / b.lifetime) * b.fdata / b.lifetime * this.speed;
            Object object = b.data;
            if (object instanceof Float) {
                Float scl = (Float)object;
                f = scl.floatValue();
            } else {
                f = 1.0f;
            }
            vec2.setLength(f2 * f);
        }
        if (this.hasAccel) {
            b.vel.setLength(this.velocityBegin + this.accelInterp.apply(Mathf.curve((float)b.fin(), (float)this.accelerateBegin, (float)this.accelerateEnd)) * this.velocityIncrease);
        }
        super.update(b);
        if (this.artilleryTrail && b.timer(0, (3.0f + b.fslope() * 2.0f) * this.trailMult)) {
            this.trailEffect.at(b.x, b.y, this.trailRotation ? b.rotation() : b.fslope() * this.trailSize, this.backColor);
        }
    }

    public void updateTrail(Bullet b) {
        if (!Vars.headless && this.trailLength > 0) {
            if (b.trail == null) {
                b.trail = new Trail(this.trailLength);
            }
            b.trail.length = this.trailLength;
            if (this.hasTracer) {
                if (b.timer(1, this.tracerUpdateInterval)) {
                    b.trail.update(b.x + Mathf.random((float)(-this.tracerRandRange), (float)this.tracerRandRange), b.y + Mathf.random((float)(-this.tracerRandRange), (float)this.tracerRandRange), this.trailInterp.apply(b.fin()) * (1.0f + (this.trailSinMag > 0.0f ? Mathf.absin((float)Time.time, (float)this.trailSinScl, (float)this.trailSinMag) : 0.0f)));
                }
            } else {
                b.trail.update(b.x, b.y, this.trailInterp.apply(b.fin()) * (1.0f + (this.trailSinMag > 0.0f ? Mathf.absin((float)Time.time, (float)this.trailSinScl, (float)this.trailSinMag) : 0.0f)));
            }
        }
    }
}

