/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.bullets.adapt;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.util.Tmp;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.bullet.LaserBulletType;
import mindustry.gen.Bullet;
import mindustry.gen.Hitboxc;
import mindustry.graphics.Drawf;
import newhorizon.expand.bullets.TypeDamageBulletType;
import newhorizon.util.feature.PosLightning;

public class AdaptLaserBulletType
extends LaserBulletType
implements TypeDamageBulletType {
    public String bundleName = "bullet-name";
    public boolean drawLightning = false;
    public int boltNum = 2;
    public float liWidth = 1.5f;

    @Override
    public String bundleName() {
        return this.bundleName;
    }

    public void hitEntity(Bullet b, Hitboxc entity, float health) {
        this.typedHitEntity((BulletType)this, b, entity, health);
    }

    public void createSplashDamage(Bullet b, float x, float y) {
        this.typedCreateSplash((BulletType)this, b, x, y);
    }

    public void init(Bullet b) {
        super.init(b);
        this.applyExtraMultiplier(b);
        if (this.drawLightning) {
            PosLightning.createEffect((Position)b, b.fdata * 0.95f, b.rotation(), this.hitColor, this.boltNum, this.liWidth);
        }
    }

    public void draw(Bullet b) {
        float realLength = b.fdata;
        float f = Mathf.curve((float)b.fin(), (float)0.0f, (float)0.2f);
        float baseLen = realLength * f;
        float cwidth = this.width;
        float compound = 1.0f;
        if (!this.drawLightning) {
            Lines.lineAngle((float)b.x, (float)b.y, (float)b.rotation(), (float)baseLen);
        }
        for (Color color : this.colors) {
            Draw.color((Color)color);
            Lines.stroke((float)((cwidth *= this.lengthFalloff) * b.fout()));
            Lines.lineAngle((float)b.x, (float)b.y, (float)b.rotation(), (float)baseLen, (boolean)false);
            Tmp.v1.trns(b.rotation(), baseLen);
            Drawf.tri((float)(b.x + Tmp.v1.x), (float)(b.y + Tmp.v1.y), (float)Lines.getStroke(), (float)(cwidth * 2.0f + this.width / 2.0f), (float)b.rotation());
            Fill.circle((float)b.x, (float)b.y, (float)(1.0f * cwidth * b.fout()));
            for (int i : Mathf.signs) {
                Drawf.tri((float)b.x, (float)b.y, (float)(this.sideWidth * b.fout() * cwidth), (float)(this.sideLength * compound), (float)(b.rotation() + this.sideAngle * (float)i));
            }
            compound *= this.lengthFalloff;
        }
        Draw.reset();
        Tmp.v1.trns(b.rotation(), baseLen * 1.1f);
        Drawf.light((float)b.x, (float)b.y, (float)(b.x + Tmp.v1.x), (float)(b.y + Tmp.v1.y), (float)(this.width * 1.4f * b.fout()), (Color)this.colors[0], (float)0.6f);
    }
}

