/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.bullets.adapt;

import arc.func.Cons;
import arc.math.geom.Position;
import mindustry.content.Fx;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Healthc;
import mindustry.gen.Hitboxc;
import mindustry.gen.Sounds;
import newhorizon.content.NHFx;
import newhorizon.expand.bullets.adapt.AdaptBulletType;
import newhorizon.util.feature.PosLightning;

public class PosLightningType
extends AdaptBulletType {
    public int boltNum = 2;
    public float hitEffectRotation = 12.0f;

    public PosLightningType() {
        this.speed = 0.0f;
        this.scaleLife = true;
        this.hitShake = 2.0f;
        this.hitSound = Sounds.shootArc;
        this.keepVelocity = false;
        this.absorbable = false;
        this.instantDisappear = true;
        this.collides = false;
        this.collidesGround = true;
        this.collidesAir = true;
        this.shootEffect = this.smokeEffect = NHFx.boolSelector;
        this.hitEffect = this.smokeEffect;
        this.despawnEffect = Fx.none;
    }

    public PosLightningType(float damage) {
        this.damage = damage;
        this.speed = 0.0f;
        this.scaleLife = true;
        this.hitShake = 2.0f;
        this.hitSound = Sounds.shootArc;
        this.keepVelocity = false;
        this.absorbable = false;
        this.instantDisappear = true;
        this.collides = false;
        this.collidesGround = true;
        this.collidesAir = true;
        this.shootEffect = this.smokeEffect = NHFx.boolSelector;
        this.hitEffect = this.smokeEffect;
        this.despawnEffect = Fx.none;
    }

    public void init() {
        super.init();
        this.drawSize = Math.max(this.drawSize, this.maxRange * 2.0f);
        if (this.hitEffect == NHFx.boolSelector) {
            this.hitEffect = NHFx.lightningHitLarge(this.lightningColor);
        }
        if (this.smokeEffect == NHFx.boolSelector) {
            this.smokeEffect = Fx.shootBigSmoke;
        }
        if (this.shootEffect == NHFx.boolSelector) {
            this.shootEffect = NHFx.shootLineSmall(this.lightningColor);
        }
    }

    public float range() {
        return this.maxRange;
    }

    @Override
    public void init(Bullet b) {
        Building tile;
        float length = b.lifetime * this.range() / this.lifetime;
        Healthc target = Damage.linecast((Bullet)b, (float)b.x, (float)b.y, (float)b.rotation(), (float)(length + 4.0f));
        b.data = target;
        if (target instanceof Hitboxc) {
            Hitboxc hit = (Hitboxc)target;
            b.collision(hit, hit.x(), hit.y());
        } else if (target instanceof Building && (tile = (Building)target).collide(b)) {
            tile.collision(b);
            this.hit(b, tile.x, tile.y);
        }
        PosLightning.createLength(b, b.team, (Position)b, length, b.rotation(), this.lightningColor, true, 0.0f, 0, 2.5f, this.boltNum, (Cons<Position>)((Cons)p -> {
            this.hitEffect.at(p.getX(), p.getY(), this.hitEffectRotation, this.hitColor);
            Effect.shake((float)this.hitShake, (float)this.hitShake, (Position)p);
        }));
        super.init(b);
    }

    public void despawned(Bullet b) {
        this.despawnEffect.at(b.x, b.y, b.rotation(), this.lightningColor);
    }

    public void hit(Bullet b) {
    }

    public void hit(Bullet b, float x, float y) {
    }

    public void draw(Bullet b) {
    }

    public void drawLight(Bullet b) {
    }
}

