/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.bullets.raid;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Tmp;
import mindustry.content.Fx;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.Lightning;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import mindustry.gen.Sounds;
import mindustry.graphics.Drawf;
import newhorizon.content.NHBullets;

public class BasicRaidBulletType
extends BasicBulletType {
    public BasicRaidBulletType() {
        this.speed = 8.0f;
        this.lifetime = 120.0f;
        this.splashDamageRadius = 80.0f;
        this.splashDamagePierce = true;
        this.collides = false;
        this.collidesGround = true;
        this.collideFloor = true;
        this.collidesAir = true;
        this.hittable = true;
        this.reflectable = false;
        this.absorbable = true;
        this.despawnHit = true;
        this.trailLength = 14;
        this.trailChance = 0.075f;
        this.trailParam = 6.0f;
        this.drawSize = 120.0f;
        this.despawnShake = 16.0f;
        this.hitShake = 16.0f;
        this.shrinkY = 0.0f;
        this.shrinkX = 0.0f;
        this.height = 66.0f;
        this.width = 20.0f;
        this.sprite = NHBullets.STRIKE;
        this.hitSound = Sounds.explosion;
    }

    public void updateTrailEffects(Bullet b) {
        if (this.trailChance > 0.0f && Mathf.chanceDelta((double)this.trailChance)) {
            this.trailEffect.at(b.x, b.y, this.trailRotation ? b.rotation() : this.trailParam, b.team.color);
        }
        if (this.trailInterval > 0.0f && b.timer(0, this.trailInterval)) {
            this.trailEffect.at(b.x, b.y, this.trailRotation ? b.rotation() : this.trailParam, b.team.color);
        }
    }

    public void drawTrail(Bullet b) {
        if (this.trailLength > 0 && b.trail != null) {
            float z = Draw.z();
            Draw.z((float)(z - 1.0E-4f));
            b.trail.draw(b.team.color, this.trailWidth);
            Draw.z((float)z);
        }
    }

    public void drawLight(Bullet b) {
        if (this.lightOpacity <= 0.0f || this.lightRadius <= 0.0f) {
            return;
        }
        Drawf.light((Position)b, (float)this.lightRadius, (Color)b.team.color, (float)this.lightOpacity);
    }

    public void despawned(Bullet b) {
        if (this.despawnHit) {
            this.hit(b);
        } else {
            this.createUnits(b, b.x, b.y);
        }
        if (!this.fragOnHit) {
            this.createFrags(b, b.x, b.y);
        }
        this.despawnEffect.at(b.x, b.y, b.rotation(), b.team.color);
        this.despawnSound.at((Position)b);
        Effect.shake((float)this.despawnShake, (float)this.despawnShake, (Position)b);
    }

    public void hit(Bullet b, float x, float y) {
        this.hitEffect.at(x, y, b.rotation(), b.team.color);
        this.hitSound.at(x, y, this.hitSoundPitch, this.hitSoundVolume);
        Effect.shake((float)this.hitShake, (float)this.hitShake, (Position)b);
        if (this.fragOnHit) {
            this.createFrags(b, x, y);
        }
        this.createPuddles(b, x, y);
        this.createIncend(b, x, y);
        this.createUnits(b, x, y);
        if (this.suppressionRange > 0.0f) {
            Damage.applySuppression((Team)b.team, (float)b.x, (float)b.y, (float)this.suppressionRange, (float)this.suppressionDuration, (float)0.0f, (float)this.suppressionEffectChance, (Position)new Vec2(b.x, b.y));
        }
        this.createSplashDamage(b, x, y);
        for (int i = 0; i < this.lightning; ++i) {
            Lightning.create((Bullet)b, (Color)this.lightningColor, (float)(this.lightningDamage < 0.0f ? this.damage : this.lightningDamage), (float)b.x, (float)b.y, (float)(b.rotation() + Mathf.range((float)(this.lightningCone / 2.0f)) + this.lightningAngle), (int)(this.lightningLength + Mathf.random((int)this.lightningLengthRand)));
        }
    }

    public void createSplashDamage(Bullet b, float x, float y) {
        if (this.splashDamageRadius > 0.0f && !b.absorbed) {
            Damage.damage((Team)b.team, (float)x, (float)y, (float)this.splashDamageRadius, (float)(b.damage() * b.damageMultiplier()), (boolean)this.splashDamagePierce, (boolean)this.collidesAir, (boolean)this.collidesGround, (boolean)this.scaledSplashDamage, (Bullet)b);
        }
    }

    public void removed(Bullet b) {
        if (this.trailLength > 0 && b.trail != null && b.trail.size() > 0) {
            Fx.trailFade.at(b.x, b.y, this.trailWidth, b.team.color, (Object)b.trail.copy());
        }
    }

    public void draw(Bullet b) {
        this.drawTrail(b);
        this.drawParts(b);
        float shrink = this.shrinkInterp.apply(b.fout());
        float height = this.height * (1.0f - this.shrinkY + this.shrinkY * shrink);
        float width = this.width * (1.0f - this.shrinkX + this.shrinkX * shrink);
        float offset = -90.0f + (this.spin != 0.0f ? Mathf.randomSeed((long)b.id, (float)360.0f) + b.time * this.spin : 0.0f) + this.rotationOffset;
        Color mix = Tmp.c1.set(this.mixColorFrom).lerp(this.mixColorTo, b.fin());
        Draw.mixcol((Color)mix, (float)mix.a);
        if (this.backRegion.found()) {
            Draw.color((Color)b.team.color);
            Draw.rect((TextureRegion)this.backRegion, (float)b.x, (float)b.y, (float)width, (float)height, (float)(b.rotation() + offset));
        }
        Draw.color((Color)Color.white);
        Draw.rect((TextureRegion)this.frontRegion, (float)b.x, (float)b.y, (float)width, (float)height, (float)(b.rotation() + offset));
        Draw.reset();
    }
}

