/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.bullets.raid;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Vec2;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.gen.Bullet;
import mindustry.gen.Hitboxc;
import newhorizon.NHSetting;
import newhorizon.content.NHFx;
import newhorizon.expand.bullets.raid.BasicRaidBulletType;
import newhorizon.util.struct.Vec2Seq;

public class TracerRaidBulletType
extends BasicRaidBulletType {
    protected static final Vec2 v1 = new Vec2();
    protected static final Vec2 v2 = new Vec2();
    protected static final Vec2 v3 = new Vec2();
    protected static final Rand rand = new Rand();
    public int tracers = 2;
    public int tracerFadeOffset = 10;
    public int tracerStrokeOffset = 15;
    public float tracerStroke = 3.0f;
    public float tracerSpacing = 8.0f;
    public float tracerRandX = 6.0f;
    public float tracerUpdateSpacing = 0.3f;

    private void addEndVec(Bullet b) {
        if (!Vars.headless && b.data instanceof Vec2Seq[]) {
            Vec2Seq[] pointsArr;
            for (Vec2Seq points : pointsArr = (Vec2Seq[])b.data()) {
                points.add(b.x, b.y);
                points.add(this.tracerStroke, this.tracerFadeOffset);
                NHFx.lightningFade.at(b.x, b.y, (float)this.tracerStrokeOffset, b.team.color, (Object)points);
            }
            b.data = null;
        }
    }

    @Override
    public void despawned(Bullet b) {
        super.despawned(b);
        this.addEndVec(b);
    }

    public void hitEntity(Bullet b, Hitboxc entity, float health) {
        super.hitEntity(b, entity, health);
        this.hit(b);
    }

    public void hit(Bullet b) {
        super.hit(b);
        this.addEndVec(b);
    }

    public void init(Bullet b) {
        super.init(b);
        if (Vars.headless || !NHSetting.enableDetails() && this.trailLength > 0) {
            return;
        }
        Vec2Seq[] points = new Vec2Seq[this.tracers];
        for (int i = 0; i < this.tracers; ++i) {
            Vec2Seq p;
            points[i] = p = new Vec2Seq();
        }
        b.data = points;
    }

    public void update(Bullet b) {
        super.update(b);
        if (!Vars.headless && b.timer(2, this.tracerUpdateSpacing)) {
            Vec2Seq[] points;
            if (!(b.data instanceof Vec2Seq[])) {
                return;
            }
            for (Vec2Seq seq : points = (Vec2Seq[])b.data()) {
                v2.trns(b.rotation(), 0.0f, rand.range(this.tracerRandX));
                v1.setToRandomDirection(rand).scl(this.tracerSpacing);
                seq.add(v3.set(b.x, b.y).add(v1).add(v2));
            }
        }
    }

    @Override
    public void drawTrail(Bullet b) {
        super.drawTrail(b);
        if (b.data instanceof Vec2Seq[]) {
            Vec2Seq[] pointsArr;
            for (Vec2Seq points : pointsArr = (Vec2Seq[])b.data()) {
                if (points.size() < 2) {
                    return;
                }
                Draw.color((Color)b.team.color);
                for (int i = 1; i < points.size(); ++i) {
                    Lines.stroke((float)(Mathf.clamp((float)(((float)i + (float)this.tracerFadeOffset / 2.0f) / (float)points.size() * (float)(this.tracerStrokeOffset - (points.size() - i)) / (float)this.tracerStrokeOffset)) * this.tracerStroke));
                    points.setVec2(i - 1, Tmp.v1);
                    points.setVec2(i, Tmp.v2);
                    Lines.line((float)Tmp.v1.x, (float)Tmp.v1.y, (float)Tmp.v2.x, (float)Tmp.v2.y, (boolean)false);
                    Fill.circle((float)Tmp.v1.x, (float)Tmp.v1.y, (float)(Lines.getStroke() / 2.0f));
                }
                Fill.circle((float)points.peekTmp().x, (float)points.peekTmp().y, (float)this.tracerStroke);
            }
        }
    }
}

