/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.cutscene.action;

import mindustry.Vars;
import mindustry.game.Team;
import mindustry.gen.Building;
import newhorizon.NHVars;
import newhorizon.expand.cutscene.components.Action;
import newhorizon.expand.cutscene.components.ActionControl;
import newhorizon.expand.cutscene.components.ui.MarkStyle;

public class MarkWorldAction
extends Action {
    public int style;
    public float x;
    public float y;
    public float radius;
    public float time;
    public Team team;

    public MarkWorldAction(float x, float y, float radius, float time, int style, Team team) {
        super(0.0f);
        this.x = x;
        this.y = y;
        this.radius = radius;
        this.time = time;
        this.style = style;
        this.team = team;
    }

    public MarkWorldAction(String[] args) {
        super(0.0f);
        this.x = Float.parseFloat(args[0]);
        this.y = Float.parseFloat(args[1]);
        this.radius = Float.parseFloat(args[2]);
        this.time = Float.parseFloat(args[3]);
        this.style = Integer.parseInt(args[4]);
        this.team = ActionControl.parseTeam(args[5]);
    }

    public MarkWorldAction(String[] tokens, Building source) {
        super(0.0f);
        this.x = ActionControl.parseFloat(tokens[0], source);
        this.y = ActionControl.parseFloat(tokens[1], source);
        this.radius = ActionControl.parseFloat(tokens[2], source);
        this.time = ActionControl.parseFloat(tokens[3], source);
        this.style = Integer.parseInt(tokens[4]);
        this.team = ActionControl.parseTeam(tokens[5]);
    }

    public MarkStyle getMarkStyle() {
        MarkStyle markStyle;
        switch (this.style) {
            case 1: {
                markStyle = MarkStyle.defaultNoLines;
                break;
            }
            case 2: {
                markStyle = MarkStyle.defaultFixed;
                break;
            }
            case 3: {
                markStyle = MarkStyle.signalShake;
                break;
            }
            case 4: {
                markStyle = MarkStyle.iconRaid;
                break;
            }
            default: {
                markStyle = MarkStyle.defaultStyle;
            }
        }
        return markStyle;
    }

    @Override
    public void end() {
        if (Vars.headless) {
            return;
        }
        NHVars.cutsceneUI.mark(this.x, this.y, this.radius, this.time * 60.0f, this.team.color, this.getMarkStyle());
    }

    @Override
    public void skip() {
        this.end();
    }
}

