/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.cutscene.action;

import arc.math.Angles;
import arc.math.Mathf;
import arc.util.Tmp;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Call;
import newhorizon.content.NHBullets;
import newhorizon.content.bullets.RaidBullets;
import newhorizon.expand.cutscene.components.Action;
import newhorizon.expand.cutscene.components.ActionControl;

public class RaidAction
extends Action {
    public Team team;
    public float sourceX = 0.0f;
    public float sourceY = 0.0f;
    public float targetX = 0.0f;
    public float targetY = 0.0f;
    public float inaccuracyRadius = 80.0f;
    public int bulletType = 0;

    public RaidAction(String[] tokens, Building source) {
        super(0.0f);
        this.team = ActionControl.parseTeam(tokens[0]);
        this.bulletType = Integer.parseInt(tokens[1]);
        this.sourceX = ActionControl.parseFloat(tokens[2], source);
        this.sourceY = ActionControl.parseFloat(tokens[3], source);
        this.targetX = ActionControl.parseFloat(tokens[4], source);
        this.targetY = ActionControl.parseFloat(tokens[5], source);
        this.inaccuracyRadius = ActionControl.parseFloat(tokens[6], source);
    }

    public RaidAction(String[] tokens) {
        super(0.0f);
        this.team = ActionControl.parseTeam(tokens[0]);
        this.bulletType = Integer.parseInt(tokens[1]);
        this.sourceX = Float.parseFloat(tokens[2]);
        this.sourceY = Float.parseFloat(tokens[3]);
        this.targetX = Float.parseFloat(tokens[4]);
        this.targetY = Float.parseFloat(tokens[5]);
        this.inaccuracyRadius = Float.parseFloat(tokens[6]);
    }

    public RaidAction() {
        super(0.0f);
    }

    public BulletType bulletType() {
        BulletType bulletType;
        switch (this.bulletType) {
            case 1: {
                bulletType = RaidBullets.raidBullet_1;
                break;
            }
            case 2: {
                bulletType = RaidBullets.raidBullet_2;
                break;
            }
            case 3: {
                bulletType = RaidBullets.raidBullet_3;
                break;
            }
            case 4: {
                bulletType = RaidBullets.raidBullet_4;
                break;
            }
            case 5: {
                bulletType = RaidBullets.raidBullet_5;
                break;
            }
            case 6: {
                bulletType = RaidBullets.raidBullet_6;
                break;
            }
            case 7: {
                bulletType = RaidBullets.raidBullet_7;
                break;
            }
            case 8: {
                bulletType = RaidBullets.raidBullet_8;
                break;
            }
            default: {
                bulletType = NHBullets.railGun1;
            }
        }
        return bulletType;
    }

    @Override
    public void end() {
        this.createBullet();
    }

    @Override
    public void skip() {
        this.end();
    }

    public void createBullet() {
        Tmp.v1.trns(Mathf.random((float)360.0f), Mathf.random((float)this.inaccuracyRadius));
        float dst = Mathf.dst((float)this.sourceX, (float)this.sourceY, (float)this.targetX, (float)this.targetY);
        float ang = Angles.angle((float)this.sourceX, (float)this.sourceY, (float)this.targetX, (float)this.targetY);
        float lifetimeScl = dst / (this.bulletType().speed * this.bulletType().lifetime);
        Call.createBullet((BulletType)this.bulletType(), (Team)this.team, (float)(this.sourceX + Tmp.v1.x), (float)(this.sourceY + Tmp.v1.y), (float)ang, (float)-1.0f, (float)1.0f, (float)lifetimeScl);
    }
}

