/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.cutscene.action;

import arc.flabel.FLabel;
import arc.func.Cons;
import arc.graphics.g2d.TextureRegion;
import arc.scene.Element;
import arc.scene.ui.layout.Table;
import mindustry.Vars;
import mindustry.game.Team;
import mindustry.ui.Styles;
import newhorizon.content.NHContent;
import newhorizon.expand.cutscene.components.Action;
import newhorizon.expand.cutscene.components.ActionControl;
import newhorizon.util.ui.NHUIFunc;

public class WarningIconAction
extends Action {
    public int icon;
    public Team team;
    public String message;

    public WarningIconAction(int icon, Team team, String message) {
        super(0.0f);
        this.icon = icon;
        this.team = team;
        this.message = message;
    }

    public WarningIconAction(String[] args) {
        super(0.0f);
        this.icon = Integer.parseInt(args[0]);
        this.team = ActionControl.parseTeam(args[1]);
        this.message = ActionControl.parseString(args[2]);
    }

    public TextureRegion warningIcon() {
        TextureRegion textureRegion;
        switch (this.icon) {
            case 0: {
                textureRegion = NHContent.raid;
                break;
            }
            case 1: {
                textureRegion = NHContent.fleet;
                break;
            }
            case 2: {
                textureRegion = NHContent.capture;
                break;
            }
            default: {
                textureRegion = NHContent.objective;
            }
        }
        return textureRegion;
    }

    @Override
    public void begin() {
        if (Vars.headless) {
            return;
        }
        NHUIFunc.showLabel(2.5f, (Cons<Table>)((Cons)t -> {
            t.background(Styles.black5);
            t.table(t2 -> {
                t2.image().growX().height(6.0f).pad(4.0f).padRight(-9.0f).color(this.team.color);
                t2.image(this.warningIcon()).fill().color(this.team.color);
                t2.image().growX().height(6.0f).pad(4.0f).padLeft(-9.0f).color(this.team.color);
            }).growX().pad(6.0f).fillY().row();
            t.table(l -> l.add((Element)new FLabel((CharSequence)("<< " + this.message + " >>"))).color(this.team.color).padBottom(4.0f).row()).growX().fillY();
        }));
    }
}

