/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.cutscene.components;

import arc.Events;
import arc.struct.Queue;
import arc.struct.Seq;
import arc.util.Time;
import mindustry.game.EventType;
import newhorizon.NHVars;
import newhorizon.expand.cutscene.components.ActionBus;

public class CutsceneControl {
    public boolean waiting = false;
    public float waitSpacing = 60.0f;
    public float waitTimer = 0.0f;
    public ActionBus mainBus;
    public Queue<ActionBus> waitingBuses = new Queue();
    public Seq<ActionBus> subBuses = new Seq();

    public CutsceneControl() {
        Events.on(EventType.WorldLoadEvent.class, event -> this.clear());
    }

    public void update() {
        if (this.mainBus != null) {
            this.mainBus.update();
            if (this.mainBus.complete()) {
                this.mainBus = null;
                this.waiting = true;
                NHVars.cutsceneUI.reset();
            }
        }
        if (this.waiting) {
            this.waitTimer += Time.delta;
            if (this.waitTimer >= this.waitSpacing) {
                this.waitTimer = 0.0f;
                this.waiting = false;
            }
        }
        if (this.mainBus == null && !this.waiting && !this.waitingBuses.isEmpty()) {
            this.mainBus = (ActionBus)this.waitingBuses.removeLast();
        }
        for (int i = 0; i < this.subBuses.size; ++i) {
            ActionBus bus = (ActionBus)this.subBuses.get(i);
            if (bus.complete()) {
                this.subBuses.remove(i);
            }
            bus.update();
        }
        NHVars.cutsceneUI.update();
    }

    public void skipAll() {
        if (this.mainBus != null) {
            this.mainBus.skip();
        }
        if (this.waitingBuses != null && !this.waitingBuses.isEmpty()) {
            this.waitingBuses.each(ActionBus::skip);
        }
        if (this.subBuses != null && !this.subBuses.isEmpty()) {
            this.subBuses.each(ActionBus::skip);
        }
    }

    public void clear() {
        this.waiting = false;
        this.waitTimer = 0.0f;
        this.mainBus = null;
        this.waitingBuses.clear();
        this.subBuses.clear();
    }

    public void addMainActionBus(ActionBus bus) {
        if (this.mainBus == null) {
            this.mainBus = bus;
        } else {
            this.waitingBuses.add((Object)bus);
        }
    }

    public void addSubActionBus(ActionBus bus) {
        this.subBuses.add((Object)bus);
    }
}

