/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.cutscene.components;

import arc.Core;
import arc.Events;
import arc.flabel.FLabel;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.scene.Action;
import arc.scene.Element;
import arc.scene.actions.Actions;
import arc.scene.event.Touchable;
import arc.scene.style.Drawable;
import arc.scene.ui.Image;
import arc.scene.ui.layout.Scl;
import arc.scene.ui.layout.Table;
import arc.scene.ui.layout.WidgetGroup;
import arc.struct.ObjectMap;
import mindustry.Vars;
import mindustry.game.EventType;
import mindustry.gen.Icon;
import mindustry.gen.Tex;
import mindustry.ui.Styles;
import newhorizon.NHRenderer;
import newhorizon.NHVars;
import newhorizon.expand.cutscene.components.ui.MarkBox;
import newhorizon.expand.cutscene.components.ui.MarkStyle;
import newhorizon.util.annotation.ClientOnly;
import newhorizon.util.annotation.HeadlessDisabled;

@HeadlessDisabled
public class CutsceneUI {
    public final float OVERLAY_SPEED = 0.0065f;
    public final ObjectMap<String, MarkBox> markers = new ObjectMap();
    public WidgetGroup root;
    public WidgetGroup overlay;
    public WidgetGroup curtain;
    public Table textTable;
    public Table textArea;
    public Table infoTable;
    public Table skip;
    public FLabel textLabel;
    public FLabel infoLabel;
    public boolean controlOverride = false;
    public Interp curtainInterp = Interp.pow2Out;
    public float curtainProgress = 0.0f;
    public float targetOverlayAlpha;
    public float overlayAlphaShiftSpeed = 0.0065f;
    public Image killStreak;
    public Vec2 killStreakShake = new Vec2();
    public float killStreakShakeTimer = 0.0f;
    public float killStreakCountTimer = 0.0f;
    public int killStreakCount = 0;

    public CutsceneUI() {
        if (Vars.headless) {
            return;
        }
        this.init();
        Events.on(EventType.WorldLoadEvent.class, e -> this.resetSave());
    }

    public float curtainScl() {
        return Core.graphics.isPortrait() ? 0.22f : 0.1185f;
    }

    public float textTableScl() {
        return Core.graphics.isPortrait() ? 0.22f : 0.1185f;
    }

    public float infoTableScl() {
        return Core.graphics.isPortrait() ? 0.4f : 0.2f;
    }

    public void init() {
        this.buildRoot();
        this.buildOverlay();
        this.buildCurtain();
        this.buildTextTable();
        this.buildInfoTable();
        this.buildSkip();
        this.updatePosition();
        this.buildCutsceneUI();
    }

    private void buildRoot() {
        this.root = new WidgetGroup(){
            {
                this.setFillParent(true);
                this.touchable = Touchable.childrenOnly;
            }
        };
    }

    private void buildOverlay() {
        this.overlay = new WidgetGroup(){
            {
                this.fillParent = true;
                this.touchable = Touchable.disabled;
            }
        };
    }

    private void buildCurtain() {
        this.curtain = new WidgetGroup(){
            {
                this.color.a = 1.0f;
                this.fillParent = true;
                this.touchable = Touchable.disabled;
            }

            public void draw() {
                super.draw();
                float heightC = this.height * CutsceneUI.this.curtainScl() * CutsceneUI.this.curtainInterp.apply(CutsceneUI.this.curtainProgress);
                Draw.color((Color)Color.black);
                Draw.alpha((float)Interp.pow3Out.apply(Mathf.curve((float)CutsceneUI.this.curtainProgress, (float)0.0f, (float)0.75f)));
                Fill.quad((float)0.0f, (float)0.0f, (float)0.0f, (float)heightC, (float)this.width, (float)heightC, (float)this.width, (float)0.0f);
                Fill.quad((float)0.0f, (float)this.height, (float)0.0f, (float)(this.height - heightC), (float)this.width, (float)(this.height - heightC), (float)this.width, (float)this.height);
                Draw.reset();
                Draw.color((float)0.0f, (float)0.0f, (float)0.0f, (float)this.color.a);
                Fill.quad((float)0.0f, (float)0.0f, (float)0.0f, (float)this.height, (float)this.width, (float)this.height, (float)this.width, (float)0.0f);
            }
        };
    }

    private void buildTextTable() {
        this.textTable = new Table(Tex.buttonEdge3){
            {
                this.touchable(() -> Touchable.disabled);
                this.visible(() -> Vars.state.isGame());
                this.color.a = 0.0f;
                if (Vars.headless) {
                    CutsceneUI.this.textArea = new Table();
                } else {
                    this.pane(Styles.smallPane, t -> {
                        CutsceneUI.this.textArea = t;
                        CutsceneUI.this.textArea.defaults().grow().pad(2.0f);
                        CutsceneUI.this.textArea.exited(() -> Core.scene.unfocus((Element)CutsceneUI.this.textArea));
                        t.fillParent = true;
                    }).grow();
                }
            }
        };
    }

    public void buildInfoTable() {
        this.infoTable = new Table(Tex.clear){
            {
                this.touchable(() -> Touchable.disabled);
                this.visible(() -> Vars.state.isGame());
                this.color.a = 0.0f;
            }
        };
    }

    private void buildSkip() {
        this.skip = new Table(){
            {
                this.margin(12.0f);
                this.visible(() -> !Vars.net.client() && CutsceneUI.this.isPlayingMainCutscene());
                this.setFillParent(true);
                this.touchable = Touchable.enabled;
                this.align(10);
                this.button("Skip Cutscene", (Drawable)Icon.play, () -> NHVars.cutscene.mainBus.skip()).marginLeft(8.0f).size(320.0f, 50.0f).padTop(Vars.mobile ? 60.0f : 0.0f);
            }
        };
    }

    private void updatePosition() {
        if (Vars.mobile) {
            this.textTable.update(() -> {
                this.textTable.setHeight(NHRenderer.height * this.textTableScl());
                this.textTable.setWidth(NHRenderer.width);
                this.textTable.setPosition(0.0f, 0.0f);
            });
            this.infoTable.update(() -> {
                this.infoTable.setHeight(NHRenderer.height * this.infoTableScl());
                this.infoTable.setWidth(NHRenderer.width);
                this.infoTable.setPosition(0.0f, 0.0f);
            });
        } else {
            this.textTable.update(() -> {
                this.textTable.setSize(Scl.scl((float)(NHRenderer.width * 0.65f)), Scl.scl((float)(NHRenderer.height * 0.1f)));
                this.textTable.setPosition((NHRenderer.width - this.textTable.getWidth()) / 2.0f, NHRenderer.height * 0.14f);
            });
            this.infoTable.update(() -> {
                this.infoTable.setSize(Scl.scl((float)(NHRenderer.width * 0.25f)), Scl.scl((float)(NHRenderer.height * 0.1f)));
                this.infoTable.setPosition(NHRenderer.width * 0.05f, NHRenderer.height * 0.1f);
            });
        }
    }

    private void buildCutsceneUI() {
        if (!Vars.headless) {
            Vars.control.input.addLock(() -> this.controlOverride);
            Core.scene.root.addChildAt(0, (Element)this.root);
            this.root.addChild((Element)this.overlay);
            this.root.addChild((Element)this.curtain);
            this.root.addChild((Element)this.textTable);
            this.root.addChild((Element)this.infoTable);
            this.root.addChild((Element)this.skip);
        }
    }

    public boolean isPlayingMainCutscene() {
        return NHVars.cutscene.mainBus != null && !NHVars.cutscene.mainBus.complete();
    }

    @ClientOnly
    public void reset() {
        if (Vars.headless) {
            return;
        }
        this.controlOverride = false;
        this.curtainProgress = 0.0f;
        this.targetOverlayAlpha = 0.0f;
        this.overlayAlphaShiftSpeed = 0.0065f;
        this.overlay.clear();
        this.infoLabel = new FLabel((CharSequence)"");
        this.infoTable.clear();
        this.infoTable.add((Element)NHVars.cutsceneUI.infoLabel);
        this.infoTable.actions(new Action[]{Actions.alpha((float)0.0f)});
        this.textLabel = new FLabel((CharSequence)"");
        this.textArea.clear();
        this.textArea.add((Element)NHVars.cutsceneUI.textLabel).pad(4.0f, 32.0f, 4.0f, 32.0f);
        this.textTable.actions(new Action[]{Actions.alpha((float)0.0f)});
        this.markers.clear();
    }

    public void resetSave() {
        this.reset();
        this.curtain.color.a = 1.0f;
    }

    public void update() {
        if (Vars.headless) {
            return;
        }
        this.curtain.color.a = Mathf.approachDelta((float)this.curtain.color.a, (float)this.targetOverlayAlpha, (float)this.overlayAlphaShiftSpeed);
    }

    public void clear() {
        if (Vars.headless) {
            return;
        }
        this.overlay.clear();
    }

    @HeadlessDisabled
    public void mark(float x, float y, float radius, float lifetime, Color color, MarkStyle style) {
        if (Vars.headless) {
            return;
        }
        MarkBox box = new MarkBox();
        box.init(radius, color, (Position)new Vec2(x, y), style);
        if (lifetime > 0.0f) {
            box.lifetime = lifetime;
        }
        box.addSelf();
    }
}

