/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.cutscene.components.ui;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.graphics.Pal;
import newhorizon.NHRenderer;
import newhorizon.content.NHContent;
import newhorizon.util.func.MathUtil;
import newhorizon.util.func.NHFunc;
import newhorizon.util.func.NHInterp;

public enum MarkStyle {
    defaultStyle((id, time, radius, pos, origin, color, beyond) -> {
        Tmp.c2.set(Pal.gray).a(color.a);
        float size = radius * Mathf.clamp((float)Vars.renderer.getDisplayScale(), (float)0.5f, (float)2.0f);
        float rotationS = 45.0f + 90.0f * NHInterp.pow10.apply(Time.time / 120.0f % 1.0f);
        float angle = beyond ? Angles.angle((float)(NHRenderer.width / 2.0f), (float)(NHRenderer.height / 2.0f), (float)pos.x, (float)pos.y) - 90.0f : 0.0f;
        Lines.stroke((float)9.0f, (Color)Tmp.c2);
        Lines.square((float)pos.x, (float)pos.y, (float)(size + 3.0f), (float)rotationS);
        Lines.stroke((float)3.0f, (Color)color);
        if (beyond) {
            Draw.rect((TextureRegion)NHContent.pointerRegion, (Position)pos, (float)size, (float)size, (float)angle);
        }
        Lines.square((float)pos.x, (float)pos.y, (float)(size + 3.0f), (float)rotationS);
        Lines.stroke((float)9.0f, (Color)Tmp.c2);
        for (int i : Mathf.signs) {
            Lines.line((float)((float)Math.max(0, i) * NHRenderer.width), (float)pos.y, (float)(pos.x + size * (float)i * 2.0f), (float)pos.y);
            Lines.line((float)pos.x, (float)((float)Math.max(0, i) * NHRenderer.height), (float)pos.x, (float)(pos.y + size * (float)i * 2.0f));
        }
        Lines.stroke((float)3.0f, (Color)color);
        for (int i : Mathf.signs) {
            Lines.line((float)((float)Math.max(0, i) * NHRenderer.width), (float)pos.y, (float)(pos.x + size * (float)i * 2.0f), (float)pos.y);
            Lines.line((float)pos.x, (float)((float)Math.max(0, i) * NHRenderer.height), (float)pos.x, (float)(pos.y + size * (float)i * 2.0f));
        }
    }),
    defaultNoLines((id, time, radius, pos, origin, color, beyond) -> {
        Tmp.c2.set(Pal.gray).a(color.a);
        float size = radius * Mathf.clamp((float)Vars.renderer.getDisplayScale(), (float)0.5f, (float)2.0f);
        float rotationS = 45.0f + 90.0f * NHInterp.pow10.apply(Time.time / 120.0f % 1.0f);
        float angle = beyond ? Angles.angle((float)(NHRenderer.width / 2.0f), (float)(NHRenderer.height / 2.0f), (float)pos.x, (float)pos.y) - 90.0f : 0.0f;
        Lines.stroke((float)9.0f, (Color)Tmp.c2);
        Lines.square((float)pos.x, (float)pos.y, (float)(size + 3.0f), (float)rotationS);
        Lines.stroke((float)3.0f, (Color)color);
        if (beyond) {
            Draw.rect((TextureRegion)NHContent.pointerRegion, (Position)pos, (float)size, (float)size, (float)angle);
        }
        Lines.square((float)pos.x, (float)pos.y, (float)(size + 3.0f), (float)rotationS);
    }),
    defaultFixed((id, time, radius, pos, origin, color, beyond) -> {
        Tmp.c2.set(Pal.gray).a(color.a);
        float size = radius * Mathf.clamp((float)Vars.renderer.getDisplayScale(), (float)0.5f, (float)2.0f);
        float rotationS = 45.0f;
        float angle = beyond ? Angles.angle((float)(NHRenderer.width / 2.0f), (float)(NHRenderer.height / 2.0f), (float)pos.x, (float)pos.y) - 90.0f : 0.0f;
        Lines.stroke((float)9.0f, (Color)Tmp.c2);
        Lines.square((float)pos.x, (float)pos.y, (float)(size + 3.0f), (float)rotationS);
        Lines.stroke((float)3.0f, (Color)color);
        if (beyond) {
            Draw.rect((TextureRegion)NHContent.pointerRegion, (Position)pos, (float)size, (float)size, (float)angle);
        }
        Lines.square((float)pos.x, (float)pos.y, (float)(size + 3.0f), (float)rotationS);
        Lines.stroke((float)9.0f, (Color)Tmp.c2);
        for (int i : Mathf.signs) {
            Lines.line((float)((float)Math.max(0, i) * NHRenderer.width), (float)pos.y, (float)(pos.x + size * (float)i * 2.0f), (float)pos.y);
            Lines.line((float)pos.x, (float)((float)Math.max(0, i) * NHRenderer.height), (float)pos.x, (float)(pos.y + size * (float)i * 2.0f));
        }
        Lines.stroke((float)3.0f, (Color)color);
        for (int i : Mathf.signs) {
            Lines.line((float)((float)Math.max(0, i) * NHRenderer.width), (float)pos.y, (float)(pos.x + size * (float)i * 2.0f), (float)pos.y);
            Lines.line((float)pos.x, (float)((float)Math.max(0, i) * NHRenderer.height), (float)pos.x, (float)(pos.y + size * (float)i * 2.0f));
        }
    }),
    iconRaid((id, time, radius, pos, origin, color, beyond) -> {
        float scaleTileSize = Vars.renderer.getDisplayScale() / 8.0f * 4.0f;
        float scaledRadius = radius * Vars.renderer.getDisplayScale();
        float scaledClamp = Mathf.clamp((float)Vars.renderer.getDisplayScale(), (float)0.5f, (float)2.0f) / 8.0f * 4.0f;
        float size = radius * scaledClamp;
        float angle = beyond ? Angles.angle((float)(NHRenderer.width / 2.0f), (float)(NHRenderer.height / 2.0f), (float)pos.x, (float)pos.y) - 90.0f : 0.0f;
        float progress = Mathf.clamp((float)time);
        Draw.color((Color)color);
        Lines.stroke((float)(3.0f * Vars.renderer.getDisplayScale()));
        for (int i = 0; i < (int)(progress * 18.0f); ++i) {
            Lines.arc((float)origin.x, (float)origin.y, (float)(scaledRadius * 1.1f), (float)0.05f, (float)((float)i * 20.0f));
        }
        Lines.circle((float)origin.x, (float)origin.y, (float)(scaledRadius * 1.4f * MathUtil.timeValue(0.95f, 1.05f, 2.0f)));
        Draw.rect((TextureRegion)NHContent.raid, (float)origin.x, (float)origin.y, (float)((float)NHContent.raid.width * scaleTileSize), (float)((float)NHContent.raid.height * scaleTileSize));
        if (beyond) {
            Draw.rect((TextureRegion)NHContent.pointerRegion, (Position)pos, (float)size, (float)size, (float)angle);
        }
        Draw.reset();
    }),
    signalShake((id, time, radius, pos, origin, color, beyond) -> {
        Tmp.c2.set(Pal.gray).a(color.a);
        Rand rand = NHFunc.rand;
        rand.setSeed((long)Mathf.round((float)time, (float)9.0f) + (long)id);
        Vec2 v = pos.cpy().add((float)rand.range(12), (float)rand.range(12));
        float size = radius * Vars.renderer.getDisplayScale();
        float rotationS = 45.0f;
        float angle = beyond ? Angles.angle((float)(NHRenderer.width / 2.0f), (float)(NHRenderer.height / 2.0f), (float)v.x, (float)v.y) - 90.0f : 0.0f;
        Lines.stroke((float)9.0f, (Color)Tmp.c2);
        Lines.square((float)v.x, (float)v.y, (float)(size + 3.0f), (float)rotationS);
        Lines.stroke((float)3.0f, (Color)color);
        Lines.square((float)v.x, (float)v.y, (float)(size + 3.0f), (float)rotationS);
        Lines.stroke((float)9.0f, (Color)Tmp.c2);
        Lines.spikes((float)pos.x, (float)pos.y, (float)(size * 1.5f + 6.0f), (float)(size / 2.0f), (int)4, (float)45.0f);
        Lines.stroke((float)3.0f, (Color)color);
        Lines.spikes((float)pos.x, (float)pos.y, (float)(size * 1.5f + 6.0f), (float)(size / 2.0f), (int)4, (float)45.0f);
    });

    public final DrawCaution drawer;

    private MarkStyle(DrawCaution drawer) {
        this.drawer = drawer;
    }

    public static interface DrawCaution {
        public void draw(int var1, float var2, float var3, Vec2 var4, Vec2 var5, Color var6, boolean var7);
    }
}

