/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.cutscene.event;

import arc.Core;
import arc.flabel.FLabel;
import arc.func.Cons;
import arc.math.Angles;
import arc.math.Mathf;
import arc.scene.Element;
import arc.scene.ui.layout.Table;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Call;
import mindustry.ui.Styles;
import newhorizon.content.NHBullets;
import newhorizon.content.NHContent;
import newhorizon.expand.cutscene.components.WorldActionEvent;
import newhorizon.util.ui.NHUIFunc;

public class RaidEvent
extends WorldActionEvent {
    public float targetX = 0.0f;
    public float targetY = 0.0f;
    public float bulletDamage = 100.0f;
    public float bulletInterval = 20.0f;
    public float inaccuracyRadius = 80.0f;
    public int bulletCount = 3;
    public int bulletType = 0;
    public int targetFlag = 0;

    public RaidEvent(Team team, float sourceX, float sourceY, float targetX, float targetY, float bulletDamage, float bulletInterval, float inaccuracyRadius, int bulletCount, int bulletType, int targetFlag, float duration) {
        super(team, sourceX, sourceY, duration);
        this.targetX = targetX;
        this.targetY = targetY;
        this.bulletDamage = bulletDamage;
        this.bulletInterval = bulletInterval;
        this.inaccuracyRadius = inaccuracyRadius;
        this.bulletCount = bulletCount;
        this.bulletType = bulletType;
        this.targetFlag = targetFlag;
    }

    @Override
    public void activate() {
        NHUIFunc.showLabel(2.5f, (Cons<Table>)((Cons)t -> {
            t.background(Styles.black5);
            t.table(t2 -> {
                t2.image().growX().height(6.0f).pad(4.0f).padRight(-9.0f).color(this.team.color);
                t2.image(NHContent.raid).fill().color(this.team.color);
                t2.image().growX().height(6.0f).pad(4.0f).padLeft(-9.0f).color(this.team.color);
            }).growX().pad(6.0f).fillY().row();
            t.table(l -> l.add((Element)new FLabel((CharSequence)("<< " + Core.bundle.get("nh.cutscene.event.raid-alert") + " >>"))).color(this.team.color).padBottom(4.0f).row()).growX().fillY();
        }));
    }

    public BulletType bulletType() {
        return NHBullets.basicRaid;
    }

    @Override
    public void trigger() {
        for (int i = 0; i < this.bulletCount; ++i) {
            Time.run((float)((float)i * this.bulletInterval), this::createBullet);
        }
    }

    public void createBullet() {
        Tmp.v1.trns(Mathf.random((float)360.0f), Mathf.random((float)this.inaccuracyRadius));
        float dst = Mathf.dst((float)this.worldX, (float)this.worldY, (float)this.targetX, (float)this.targetY);
        float ang = Angles.angle((float)this.worldX, (float)this.worldY, (float)this.targetX, (float)this.targetY);
        float lifetimeScl = dst / (this.bulletType().speed * this.bulletType().lifetime);
        Call.createBullet((BulletType)this.bulletType(), (Team)this.team, (float)(this.worldX + Tmp.v1.x), (float)(this.worldY + Tmp.v1.y), (float)ang, (float)this.bulletDamage, (float)1.0f, (float)lifetimeScl);
    }
}

