/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.draw;

import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.gen.Building;
import mindustry.type.Liquid;
import mindustry.type.LiquidStack;
import mindustry.world.Block;
import mindustry.world.draw.DrawArcSmelt;
import newhorizon.expand.block.production.factory.RecipeGenericCrafter;
import newhorizon.expand.type.Recipe;

public class DrawLiquidSmelt
extends DrawArcSmelt {
    public float colorLerp = 0.1f;
    private final Color currentFlame = new Color();
    private final Color currentMid = new Color();
    public float fixedAlpha = 0.68f;

    public void draw(Building build) {
        RecipeGenericCrafter.RecipeGenericCrafterBuild crafterBuild;
        Recipe current;
        if (build == null) {
            return;
        }
        Liquid liquidToDraw = null;
        if (build instanceof RecipeGenericCrafter.RecipeGenericCrafterBuild && (current = (crafterBuild = (RecipeGenericCrafter.RecipeGenericCrafterBuild)build).getRecipe()) != null) {
            if (current.inputLiquid != null && current.inputLiquid.size > 0) {
                liquidToDraw = ((LiquidStack)current.inputLiquid.first()).liquid;
            } else if (current.outputLiquid != null && current.outputLiquid.size > 0) {
                liquidToDraw = ((LiquidStack)current.outputLiquid.first()).liquid;
            }
        }
        if (liquidToDraw == null && build.liquids != null) {
            liquidToDraw = build.liquids.current();
        }
        Color target = liquidToDraw != null ? liquidToDraw.color : this.flameColor;
        this.currentFlame.lerp(target, this.colorLerp * Time.delta);
        this.currentMid.lerp(Tmp.c1.set(target).shiftHue(0.08f), this.colorLerp * Time.delta);
        this.flameColor.set(this.currentFlame);
        this.midColor.set(this.currentMid);
        this.alpha = this.fixedAlpha;
        if (build.warmup() > 0.0f && this.flameColor.a > 0.001f) {
            Draw.z((float)30.05f);
            Lines.stroke((float)(this.circleStroke * build.warmup()));
            float si = Mathf.absin((float)this.flameRadiusScl, (float)this.flameRadiusMag);
            float a = this.alpha * build.warmup();
            Draw.blend((Blending)this.blending);
            float angleDeg = build.rotdeg();
            float cos = Mathf.cosDeg((float)angleDeg);
            float sin = Mathf.sinDeg((float)angleDeg);
            float rx = this.x * cos - this.y * sin;
            float ry = this.x * sin + this.y * cos;
            Draw.color((Color)this.midColor, (float)a);
            if (this.drawCenter) {
                Fill.circle((float)(build.x + rx), (float)(build.y + ry), (float)(this.flameRad + si));
            }
            Draw.color((Color)this.flameColor, (float)a);
            if (this.drawCenter) {
                Lines.circle((float)(build.x + rx), (float)(build.y + ry), (float)((this.flameRad + this.circleSpace + si) * build.warmup()));
            }
            Lines.stroke((float)(this.particleStroke * build.warmup()));
            float base = Time.time / this.particleLife;
            rand.setSeed((long)build.id);
            for (int i = 0; i < this.particles; ++i) {
                float fin = (rand.random(1.0f) + base) % 1.0f;
                float fout = 1.0f - fin;
                float angle = rand.random(360.0f);
                float particleAngle = angle + angleDeg;
                float len = this.particleRad * Interp.pow2Out.apply(fin);
                float px = Angles.trnsx((float)particleAngle, (float)len) + build.x + rx;
                float py = Angles.trnsy((float)particleAngle, (float)len) + build.y + ry;
                Lines.lineAngle((float)px, (float)py, (float)particleAngle, (float)(this.particleLen * fout * build.warmup()));
            }
            Draw.blend();
            Draw.reset();
        }
    }

    public void load(Block block) {
        super.load(block);
        this.currentFlame.set(this.flameColor);
        this.currentMid.set(this.midColor);
    }
}

