/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.draw;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.draw.DrawBlock;

public class DrawRegionOffset
extends DrawBlock {
    public String suffix = "";
    public TextureRegion region;
    public float offsetX = 0.0f;
    public float offsetY = 0.0f;
    public boolean followRotation = true;
    public boolean blink = false;
    public float blinkSpeed = 1.0f;
    public float layer = 30.05f;

    public DrawRegionOffset() {
    }

    public DrawRegionOffset(String suffix, float offsetX, float offsetY, boolean blink, float blinkSpeed) {
        this.suffix = suffix;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.blink = blink;
        this.blinkSpeed = blinkSpeed;
    }

    public void load(Block block) {
        super.load(block);
        this.region = Core.atlas.find(block.name + this.suffix);
    }

    public void draw(Building build) {
        if (this.region == null || !this.region.found()) {
            return;
        }
        float x = build.x;
        float y = build.y;
        if (this.followRotation) {
            Tmp.v1.trns(build.rotdeg(), this.offsetX, this.offsetY);
            x += Tmp.v1.x;
            y += Tmp.v1.y;
        } else {
            x += this.offsetX;
            y += this.offsetY;
        }
        Draw.z((float)this.layer);
        if (this.blink) {
            float alpha = (Mathf.absin((float)(Time.time * this.blinkSpeed), (float)1.0f, (float)1.0f) + 1.0f) / 2.0f;
            Draw.color((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        } else {
            Draw.color();
        }
        Draw.rect((TextureRegion)this.region, (float)x, (float)y, (float)(this.followRotation ? build.rotdeg() : 0.0f));
        Draw.color();
    }
}

