/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.entities;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.Scaled;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Units;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Icon;
import mindustry.gen.Rotc;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.graphics.Trail;
import mindustry.io.TypeIO;
import mindustry.type.UnitType;
import mindustry.world.blocks.payloads.Payload;
import mindustry.world.blocks.payloads.UnitPayload;
import mindustry.world.blocks.storage.CoreBlock;
import newhorizon.NHGroups;
import newhorizon.content.NHContent;
import newhorizon.content.NHFx;
import newhorizon.content.NHSounds;
import newhorizon.content.NHStatusEffects;
import newhorizon.expand.entities.EntityRegister;
import newhorizon.expand.entities.NHBaseEntity;
import newhorizon.util.feature.PosLightning;

public class Carrier
extends NHBaseEntity
implements Teamc,
Rotc,
Scaled {
    protected static final float dstPerMove = 12.0f;
    public float rotation = 0.0f;
    public float finalRot = 0.0f;
    public Unit unit;
    public UnitPayload toCarry;
    public Team team;
    public Vec2 to;
    public transient long lastUpdated;
    public transient long updateSpacing;
    public transient float x_LAST_;
    public transient float x_TARGET_;
    public transient float y_LAST_;
    public transient float y_TARGET_;
    public transient Vec2 vel = new Vec2();
    public Trail trail = new Trail(1);
    public boolean dumped = false;
    public boolean onMove = false;
    public boolean contained;
    public boolean adjusted;
    public boolean intercepted = false;
    public boolean complete = false;
    public transient boolean onGoing = true;
    protected float time = 0.0f;
    protected float lifetime = 540.0f;
    protected float surviveTime = 0.0f;
    protected float surviveLifetime = 6000.0f;

    public static Carrier create(Unit unit, Vec2 to, float rot) {
        Carrier c = (Carrier)Pools.obtain(Carrier.class, Carrier::new);
        c.init(unit, to, rot);
        c.set((Position)unit);
        c.add();
        return c;
    }

    public static Carrier create(Unit unit, Vec2 to) {
        Carrier c = (Carrier)Pools.obtain(Carrier.class, Carrier::new);
        c.init(unit, to, unit.angleTo((Position)to));
        c.set((Position)unit);
        c.add();
        return c;
    }

    public void init(Unit unit, Vec2 to, float rotation) {
        this.finalRot = rotation;
        this.drawSize = unit.hitSize * 2.0f;
        this.unit = unit;
        this.to = to;
        this.team(unit.team());
        this.contained = this.toCarry != null;
        this.trail = new Trail(60);
    }

    @Override
    public void add() {
        super.add();
        NHSounds.hyperspace.at((Position)this);
    }

    public void draw() {
        Draw.z((float)110.0f);
        if (!this.complete && this.time > this.lifetime / 2.0f || this.onMove || this.contained && this.time < this.lifetime / 2.0f && this.onGoing) {
            this.trail.draw(this.team.color, 4.0f);
        }
        if (!this.onMove && this.team != null) {
            Drawf.light((Position)this, (float)(this.drawSize * this.fslope()), (Color)this.team.color, (float)0.8f);
        }
        if (!this.onMove && this.unit != null) {
            float height = Mathf.curve((float)(this.fslope() * this.fslope()), (float)0.0f, (float)0.3f) * 1.1f;
            float width = Mathf.curve((float)(this.fslope() * this.fslope()), (float)0.35f, (float)0.75f) * 1.1f;
            if (this.contained && !Units.canCreate((Team)this.team, (UnitType)this.unit.type) || this.surviveTime > 0.0f) {
                Draw.z((float)99.8f);
                Draw.color((Color)this.team.color.cpy().mul(1.15f), (Color)Pal.gray, (float)(new Rand((long)this.id).random(-0.25f, 0.25f) / 4.0f));
                Draw.alpha((float)0.2f);
                Fill.rect((float)this.x, (float)this.y, (float)(Draw.scl * (float)this.unit.type.shadowRegion.height * width + 1.0f), (float)(Draw.scl * (float)this.unit.type.shadowRegion.width * height), (float)this.rotation);
                Draw.color((Color)Pal.ammo);
                Draw.z((float)99.9f);
                float size = this.drawSize / 3.0f;
                float sin = Mathf.absin((float)(Time.time * 1.0f), (float)8.0f, (float)2.0f);
                float length = size / 1.5f + sin;
                Draw.rect((TextureRegion)Icon.warning.getRegion(), (float)this.x, (float)this.y, (float)(size / 1.5f), (float)(size / 1.5f));
                Draw.alpha((float)(this.surviveTime / this.surviveLifetime));
                for (int i = 0; i < 4; ++i) {
                    Tmp.v1.trns((float)(i * 90), -length);
                    Draw.rect((TextureRegion)NHContent.pointerRegion, (float)(this.x + Tmp.v1.x), (float)(this.y + Tmp.v1.y), (float)size, (float)size, (float)((float)(i * 90) - 90.0f));
                }
                Draw.reset();
            } else {
                Draw.z((float)110.0f);
                Draw.color((Color)this.team.color.cpy().mul(1.15f), (Color)Pal.gray, (float)(new Rand((long)this.id).random(-0.25f, 0.25f) / 4.0f));
                Fill.rect((float)this.x, (float)this.y, (float)(Draw.scl * (float)this.unit.type.shadowRegion.height * width + 1.0f), (float)(Draw.scl * (float)this.unit.type.shadowRegion.width * height), (float)this.rotation);
            }
        }
    }

    protected void pickup() {
        this.unit.remove();
        this.toCarry = new UnitPayload(this.unit);
        Fx.unitPickup.at((Position)this.unit);
        if (Vars.net.client()) {
            Vars.netClient.clearRemovedEntity(this.unit.id);
        }
    }

    protected boolean drop() {
        this.toCarry.set(this.x, this.y, this.rotation);
        if (this.intercepted) {
            this.toCarry.unit.apply(NHStatusEffects.intercepted, 480.0f);
        }
        return this.toCarry.dump();
    }

    public void update() {
        this.onGoing = true;
        if (!this.contained && this.unit != null && this.unit.isValid() && !this.complete) {
            this.set((Position)this.unit);
            this.rotation(this.unit.rotation);
        }
        if (this.time > this.lifetime / 2.0f && !this.adjusted) {
            if (!this.contained && this.unit != null && this.unit.isValid()) {
                this.contained = true;
                this.adjusted = true;
                this.pickup();
            } else if (this.toCarry != null && !this.dumped) {
                this.onGoing = this.dumped = this.drop();
                boolean bl = this.contained = !this.dumped;
                if (this.surviveTime > this.surviveLifetime) {
                    if (!Vars.net.client()) {
                        this.toCarry.set(this.x, this.y, this.rotation);
                        this.toCarry.unit.add();
                    }
                    this.dumped = true;
                    this.contained = false;
                }
            }
        }
        if (this.dumped) {
            this.complete = true;
            this.adjusted = true;
        }
        if (this.time > this.lifetime) {
            if (!this.contained) {
                this.remove();
            } else if (!this.onMove) {
                this.onMove = true;
            }
        }
        if (!this.onMove && this.onGoing) {
            this.time += Time.delta;
        } else if (!this.onMove) {
            this.surviveTime += Time.delta;
        }
        if (this.onMove && this.contained && (this.intercepted || Mathf.equal((float)this.x, (float)this.to.getX(), (float)12.0f) && Mathf.equal((float)this.y, (float)this.to.getY(), (float)12.0f))) {
            if (!this.intercepted) {
                this.set((Position)this.to);
            }
            this.time = 0.0f;
            this.onMove = false;
            this.adjusted = false;
            this.rotation = this.finalRot;
            NHSounds.hyperspace.at((Position)this);
        }
        if (this.onMove && this.contained) {
            if (!Vars.headless) {
                this.trail.update(this.x, this.y);
            }
            this.vel.set(this.to).sub(this.x, this.y).nor().scl(12.0f * Time.delta);
            this.x += this.vel.x;
            this.y += this.vel.y;
            NHGroups.gravityTraps.intersect(this.x - this.drawSize / 2.0f, this.y - this.drawSize / 2.0f, this.drawSize, this.drawSize, b -> {
                if (b.owner != this.team) {
                    this.intercepted = true;
                    this.toCarry.unit.damage(this.toCarry.unit.health * 0.3f);
                    PosLightning.createEffect(b, (Position)this, b.owner.color, 2, 2.5f);
                    NHFx.square45_4_45.at(this.x, this.y, this.team.color);
                }
            });
        }
        if (!Vars.headless) {
            this.trail.update(this.x, this.y, 1.0f);
        }
    }

    @Override
    public int classId() {
        return EntityRegister.getID(this.getClass());
    }

    @Override
    public void write(Writes write) {
        super.write(write);
        write.bool(this.contained);
        write.bool(this.complete);
        TypeIO.writeVec2((Writes)write, (Vec2)this.to);
        write.f(this.time);
        write.f(this.surviveTime);
        write.f(this.rotation);
        write.f(this.finalRot);
        write.bool(this.onMove);
        write.bool(this.adjusted);
        write.bool(this.dumped);
        if (this.contained) {
            TypeIO.writePayload((Writes)write, (Payload)this.toCarry);
        }
    }

    @Override
    public void read(Reads read) {
        super.read(read);
        this.contained = read.bool();
        this.complete = read.bool();
        this.to = TypeIO.readVec2((Reads)read);
        this.time = read.f();
        this.surviveTime = read.f();
        this.rotation = read.f();
        this.finalRot = read.f();
        this.onMove = read.bool();
        this.adjusted = read.bool();
        this.dumped = read.bool();
        if (this.contained) {
            this.toCarry = (UnitPayload)TypeIO.readPayload((Reads)read);
        } else {
            this.remove();
        }
        this.afterRead();
    }

    @Override
    public void afterRead() {
        if (this.contained && this.toCarry != null && this.toCarry.unit != null) {
            this.init(this.toCarry.unit, this.to, this.finalRot);
            this.add();
        } else {
            this.remove();
        }
    }

    public void afterReadAll() {
    }

    public void beforeWrite() {
    }

    public boolean inFogTo(Team viewer) {
        return false;
    }

    public boolean cheating() {
        return this.toCarry != null && this.toCarry.unit.cheating();
    }

    public CoreBlock.CoreBuild core() {
        return this.team.core();
    }

    public CoreBlock.CoreBuild closestCore() {
        return Vars.state.teams.closestCore(this.x, this.y, this.team);
    }

    public CoreBlock.CoreBuild closestEnemyCore() {
        return Vars.state.teams.closestEnemyCore(this.x, this.y, this.team);
    }

    public Team team() {
        return this.team;
    }

    public void team(Team team) {
        this.team = team;
    }

    public float rotation() {
        return this.rotation;
    }

    public void rotation(float rotation) {
        this.rotation = rotation;
    }

    public float fin() {
        return Math.min(this.time, this.lifetime) / this.lifetime;
    }

    @Override
    public String toString() {
        return "Carrier{rotation=" + this.rotation + ", unit=" + this.unit + ", toCarry=" + this.toCarry + ", team=" + this.team + ", to=" + this.to + ", intercepted=" + this.intercepted + ", complete=" + this.complete + ", onMove=" + this.onMove + ", contained=" + this.contained + ", adjusted=" + this.adjusted + ", time=" + this.time + ", lifetime=" + this.lifetime + '}';
    }

    public Building buildOn() {
        return null;
    }
}

