/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.entities;

import arc.math.geom.Position;
import arc.util.io.Reads;
import arc.util.io.Writes;
import mindustry.Vars;
import mindustry.entities.EntityGroup;
import mindustry.gen.Drawc;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.Posc;
import mindustry.gen.Unitc;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.blocks.environment.Floor;

public abstract class NHBaseEntity
implements Posc,
Drawc {
    public float x = 0.0f;
    public float y = 0.0f;
    public float drawSize = 40.0f;
    public boolean added;
    public transient int id = EntityGroup.nextId();

    public float clipSize() {
        return this.drawSize * 2.0f;
    }

    public void remove() {
        if (!this.added) {
            return;
        }
        Groups.draw.remove((Entityc)this);
        Groups.all.remove((Entityc)this);
        this.added = false;
    }

    public void add() {
        if (this.added) {
            return;
        }
        Groups.all.add((Entityc)this);
        Groups.draw.add((Entityc)this);
        this.added = true;
    }

    public boolean isLocal() {
        return this instanceof Unitc && ((Unitc)this).controller() == Vars.player;
    }

    public boolean isRemote() {
        return this instanceof Unitc && ((Unitc)this).isPlayer() && !this.isLocal();
    }

    public <T extends Entityc> T self() {
        return (T)this;
    }

    public <T> T as() {
        return (T)this;
    }

    public void set(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void set(Position pos) {
        this.set(pos.getX(), pos.getY());
    }

    public void trns(float x, float y) {
        this.set(this.x + x, this.y + y);
    }

    public void trns(Position pos) {
        this.trns(pos.getX(), pos.getY());
    }

    public int tileX() {
        return 0;
    }

    public int tileY() {
        return 0;
    }

    public Floor floorOn() {
        return null;
    }

    public Block blockOn() {
        return null;
    }

    public boolean onSolid() {
        return false;
    }

    public Tile tileOn() {
        return null;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float x() {
        return this.x;
    }

    public void x(float x) {
        this.x = x;
    }

    public float y() {
        return this.y;
    }

    public void y(float y) {
        this.y = y;
    }

    public boolean isAdded() {
        return this.added;
    }

    public boolean serialize() {
        return true;
    }

    public void read(Reads read) {
        this.x = read.f();
        this.y = read.f();
    }

    public void write(Writes write) {
        write.f(this.x);
        write.f(this.y);
    }

    public int classId() {
        return 0;
    }

    public void afterRead() {
    }

    public int id() {
        return this.id;
    }

    public void id(int id) {
        this.id = id;
    }

    public String toString() {
        return "CommandEntity{added=" + this.added + ", id=" + this.id + ", x=" + this.x + ", y=" + this.y + '}';
    }
}

