/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.entities;

import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import arc.util.Interval;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import java.nio.FloatBuffer;
import mindustry.Vars;
import mindustry.ai.types.CommandAI;
import mindustry.audio.SoundLoop;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.content.UnitTypes;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.entities.units.StatusEntry;
import mindustry.entities.units.UnitController;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.Icon;
import mindustry.gen.Player;
import mindustry.gen.Rotc;
import mindustry.gen.Syncc;
import mindustry.gen.Timedc;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import mindustry.graphics.Trail;
import mindustry.io.TypeIO;
import mindustry.type.StatusEffect;
import mindustry.type.UnitType;
import mindustry.ui.Fonts;
import newhorizon.NHSetting;
import newhorizon.content.NHContent;
import newhorizon.content.NHFx;
import newhorizon.content.NHSounds;
import newhorizon.expand.entities.EntityRegister;
import newhorizon.expand.entities.NHBaseEntity;
import newhorizon.util.func.NHFunc;
import newhorizon.util.graphic.DrawFunc;

public class Spawner
extends NHBaseEntity
implements Syncc,
Timedc,
Rotc {
    public final Seq<Trail> trails = Seq.with((Object[])new Trail[]{new Trail(30), new Trail(50), new Trail(70)});
    public Team team = Team.derelict;
    public UnitType type = UnitTypes.alpha;
    public float time = 0.0f;
    public float lifetime;
    public float surviveTime;
    public float surviveLifetime = 3000.0f;
    public float rotation;
    public double flagToApply = Double.NaN;
    public StatusEntry statusEntry = new StatusEntry().set(StatusEffects.none, 0.0f);
    public Interval timer = new Interval();
    public float trailProgress = Mathf.random((int)360);
    public long lastUpdated;
    public long updateSpacing;
    public SoundLoop soundLoop;
    public Unit toSpawn;
    public Vec2 commandPos = new Vec2(Float.NaN, Float.NaN);
    public float trailWidth = 3.0f;

    @Override
    public float clipSize() {
        return this.drawSize + 500.0f;
    }

    public Spawner init(UnitType type, Team team, Position pos, float rotation, float lifetime) {
        this.type = type;
        this.lifetime = lifetime;
        this.rotation = rotation;
        this.team = team;
        this.drawSize = type.hitSize;
        this.trailWidth = Mathf.clamp((float)(this.drawSize / 15.0f), (float)1.25f, (float)4.0f);
        this.set(pos);
        return this;
    }

    public void setStatus(StatusEffect status, float statusDuration) {
        this.statusEntry.effect = status;
        this.statusEntry.time = statusDuration;
    }

    @Override
    public void add() {
        super.add();
        Groups.sync.add((Entityc)this);
        NHFx.spawnWave.at(this.x, this.y, this.drawSize * 1.1f, this.team.color);
    }

    public void afterReadAll() {
    }

    public void beforeWrite() {
    }

    @Override
    public void remove() {
        super.remove();
        Groups.sync.remove((Entityc)this);
        if (Vars.net.client()) {
            Vars.netClient.addRemovedEntity(this.id());
        }
        if (this.soundLoop != null) {
            this.soundLoop.update(this.x, this.y, false);
        }
    }

    public void update() {
        if (this.canCreate()) {
            this.time += Time.delta;
            this.surviveTime = 0.0f;
            if (!Vars.headless && NHSetting.enableDetails()) {
                this.trailProgress += Time.delta * (0.45f + this.fin((Interp)Interp.pow3In) * 2.0f);
                for (int i = 0; i < this.trails.size; ++i) {
                    Trail trail = (Trail)this.trails.get(i);
                    Tmp.v1.trns(this.trailProgress * (float)(i + 1) * 1.5f + (float)i * 360.0f / (float)this.trails.size + Mathf.randomSeed((long)this.id, (float)360.0f), ((this.fin() + 1.0f) / 2.0f * this.drawSize * (1.0f + 0.5f * (float)i) + Mathf.sinDeg((float)(this.trailProgress * (1.0f + 0.5f * (float)i))) * this.drawSize / 2.0f) * (this.fout((Interp)Interp.pow3) * 7.0f + 1.0f) / 8.0f, this.fin((Interp)Interp.swing) * this.fout((Interp)Interp.swingOut) * this.drawSize / 3.0f * this.fout()).add((Position)this);
                    trail.update(Tmp.v1.x, Tmp.v1.y, (this.fout(0.25f) * 2.0f + 1.0f) / 3.0f);
                }
            }
        } else {
            this.surviveTime += Time.delta;
        }
        if (this.surviveTime > this.surviveLifetime) {
            this.remove();
        }
        if (this.time > this.lifetime) {
            this.dump();
            this.effect();
            this.remove();
        }
    }

    public void effect() {
        Effect.shake((float)(this.type.hitSize / 3.0f), (float)(this.type.hitSize / 4.0f), (Position)this.toSpawn);
        NHSounds.jumpIn.at(this.toSpawn.x, this.toSpawn.y);
        if (this.type.flying) {
            NHFx.jumpTrail.at(this.toSpawn.x, this.toSpawn.y, this.rotation(), this.team.color, (Object)this.type);
            this.toSpawn.apply(StatusEffects.slow, NHFx.jumpTrail.lifetime);
        } else {
            NHFx.spawn.at(this.x, this.y, this.type.hitSize, this.team.color);
            Fx.unitSpawn.at(this.toSpawn.x, this.toSpawn.y, this.rotation(), (Object)this.type);
            Time.run((float)Fx.unitSpawn.lifetime, () -> {
                for (int j = 0; j < 3; ++j) {
                    Time.run((float)(j * 8), () -> Fx.spawn.at((Position)this.toSpawn));
                }
                NHFx.spawnGround.at(this.toSpawn.x, this.toSpawn.y, this.type.hitSize / 8.0f * 3.0f, this.team.color);
                NHFx.circle.at(this.toSpawn.x, this.toSpawn.y, this.type.hitSize * 4.0f, this.team.color);
            });
        }
        if (!Vars.headless && NHSetting.enableDetails()) {
            for (int i = 0; i < this.trails.size; ++i) {
                Trail trail = (Trail)this.trails.get(i);
                Fx.trailFade.at(this.x, this.y, this.trailWidth, this.team.color, (Object)trail.copy());
            }
        }
    }

    public void dump() {
        this.toSpawn = this.type.create(this.team);
        this.toSpawn.set(this.x, this.y);
        this.toSpawn.rotation = this.rotation();
        if (!Double.isNaN(this.flagToApply)) {
            this.toSpawn.flag(this.flagToApply);
        }
        if (!Vars.net.client()) {
            this.toSpawn.add();
        }
        this.toSpawn.apply(StatusEffects.unmoving, Fx.unitSpawn.lifetime);
        this.toSpawn.apply(this.statusEntry.effect, this.statusEntry.time);
        if (this.commandPos != null && !this.commandPos.isNaN() && this.toSpawn.isCommandable()) {
            CommandAI ai = new CommandAI();
            ai.commandPosition(this.commandPos);
            this.toSpawn.controller((UnitController)ai);
        }
        Events.fire((Object)new EventType.UnitCreateEvent(this.toSpawn, null));
    }

    public boolean canCreate() {
        return Units.canCreate((Team)this.team, (UnitType)this.type) || this.team == Vars.state.rules.waveTeam;
    }

    public void draw() {
        TextureRegion arrowRegion = NHContent.arrowRegion;
        Drawf.light((float)this.x, (float)this.y, (float)(this.clipSize() * this.fout()), (Color)this.team.color, (float)0.7f);
        Draw.z((float)109.0f);
        float regSize = NHFunc.regSize(this.type);
        Draw.color((Color)(this.canCreate() ? this.team.color : Tmp.c1.set(this.team.color).lerp(Pal.ammo, Mathf.absin((float)(Time.time * 1.0f), (float)8.0f, (float)0.3f) + 0.1f)));
        for (int i = -4; i <= 4; ++i) {
            if (i == 0) continue;
            Tmp.v1.trns(this.rotation, (float)(i * 8 * 2));
            float f = (100.0f - (Time.time - 12.5f * (float)i) % 100.0f) / 100.0f;
            Draw.rect((TextureRegion)arrowRegion, (float)(this.x + Tmp.v1.x), (float)(this.y + Tmp.v1.y), (float)((float)arrowRegion.width * (regSize / 2.0f + Draw.scl) * f), (float)((float)arrowRegion.height * (regSize / 2.0f + Draw.scl) * f), (float)(this.rotation() - 90.0f));
        }
        if (this.canCreate()) {
            this.trails.each(t -> {
                t.drawCap(this.team.color, this.trailWidth);
                t.draw(this.team.color, this.trailWidth);
            });
            DrawFunc.overlayText(Fonts.tech, String.valueOf(Mathf.ceil((float)((this.lifetime - this.time) / 60.0f))), this.x, this.y, 0.0f, 0.0f, 0.25f, this.team.color, false, true);
        } else {
            Draw.z((float)110.0f);
            Draw.color((Color)Pal.ammo);
            float s = Mathf.clamp((float)(this.drawSize / 4.0f), (float)12.0f, (float)20.0f);
            Draw.rect((TextureRegion)Icon.warning.getRegion(), (float)this.x, (float)this.y, (float)s, (float)s);
        }
        Draw.reset();
    }

    @Override
    public void write(Writes write) {
        super.write(write);
        write.f(this.lifetime);
        write.f(this.time);
        write.f(this.rotation);
        write.f(this.surviveTime);
        write.d(this.flagToApply);
        TypeIO.writeUnitType((Writes)write, (UnitType)this.type);
        TypeIO.writeTeam((Writes)write, (Team)this.team);
        TypeIO.writeStatus((Writes)write, (StatusEntry)this.statusEntry);
        TypeIO.writeVec2((Writes)write, (Vec2)this.commandPos);
    }

    @Override
    public void read(Reads read) {
        super.read(read);
        this.lifetime = read.f();
        this.time = read.f();
        this.rotation = read.f();
        this.surviveTime = read.f();
        this.flagToApply = read.d();
        this.type = TypeIO.readUnitType((Reads)read);
        this.team = TypeIO.readTeam((Reads)read);
        this.statusEntry = TypeIO.readStatus((Reads)read);
        this.commandPos = TypeIO.readVec2((Reads)read);
        this.afterRead();
    }

    @Override
    public boolean serialize() {
        return true;
    }

    @Override
    public int classId() {
        return EntityRegister.getID(this.getClass());
    }

    public void snapSync() {
    }

    public void snapInterpolation() {
    }

    public void readSync(Reads read) {
        this.x = read.f();
        this.y = read.f();
        this.lifetime = read.f();
        this.time = read.f();
        this.rotation = read.f();
        this.surviveTime = read.f();
        this.type = TypeIO.readUnitType((Reads)read);
        this.team = TypeIO.readTeam((Reads)read);
        this.commandPos = this.commandPos != null ? TypeIO.readVec2((Reads)read) : new Vec2(Float.NaN, Float.NaN);
        this.afterSync();
    }

    public void writeSync(Writes write) {
        write.f(this.x);
        write.f(this.y);
        write.f(this.lifetime);
        write.f(this.time);
        write.f(this.rotation);
        write.f(this.surviveTime);
        TypeIO.writeUnitType((Writes)write, (UnitType)this.type);
        TypeIO.writeTeam((Writes)write, (Team)this.team);
        TypeIO.writeVec2((Writes)write, (Vec2)this.commandPos);
    }

    public void readSyncManual(FloatBuffer floatBuffer) {
    }

    public void writeSyncManual(FloatBuffer floatBuffer) {
    }

    public void afterSync() {
    }

    public void handleSyncHidden() {
    }

    public void interpolate() {
    }

    public boolean isSyncHidden(Player player) {
        return false;
    }

    public long lastUpdated() {
        return this.lastUpdated;
    }

    public void lastUpdated(long l) {
        this.lastUpdated = l;
    }

    public long updateSpacing() {
        return this.updateSpacing;
    }

    public void updateSpacing(long l) {
        this.updateSpacing = l;
    }

    public float fin() {
        return this.time / this.lifetime;
    }

    public float time() {
        return this.time;
    }

    public void time(float v) {
        this.time = v;
    }

    public float lifetime() {
        return this.lifetime;
    }

    public void lifetime(float v) {
        this.lifetime = v;
    }

    public float rotation() {
        return this.rotation;
    }

    public void rotation(float v) {
        this.rotation = v;
    }

    public Building buildOn() {
        return Vars.world.buildWorld(this.x, this.y);
    }
}

