/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.entities;

import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Vec2;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import java.nio.FloatBuffer;
import mindustry.Vars;
import mindustry.ai.types.CommandAI;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.entities.Effect;
import mindustry.entities.abilities.Ability;
import mindustry.entities.abilities.ShieldArcAbility;
import mindustry.entities.units.StatusEntry;
import mindustry.entities.units.UnitController;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.Player;
import mindustry.gen.Rotc;
import mindustry.gen.Syncc;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.io.TypeIO;
import mindustry.type.UnitType;
import mindustry.world.blocks.storage.CoreBlock;
import newhorizon.content.NHFx;
import newhorizon.content.NHUnitTypes;
import newhorizon.expand.entities.EntityRegister;
import newhorizon.expand.entities.NHBaseEntity;
import newhorizon.util.func.GridUtil;
import newhorizon.util.struct.GridData;

public class WarpRift
extends NHBaseEntity
implements Rotc,
Teamc,
Syncc {
    public static final Rand rand = new Rand();
    public Team team = Team.derelict;
    public UnitType unitType = NHUnitTypes.guardian;
    public float warpChargeTime = 120.0f;
    public float warpBeginTime = 120.0f;
    public float warpTime = 160.0f;
    public float warpEndTime = 120.0f;
    public float warpTimer = 0.0f;
    public boolean created;
    public double flagToApply = Double.NaN;
    public StatusEntry statusEntry = new StatusEntry().set(StatusEffects.none, 0.0f);
    public Unit toSpawn = null;
    public Vec2 commandPos = new Vec2(Float.NaN, Float.NaN);
    public float range = 0.0f;
    public float timer;
    public float rotation = -90.0f;

    public WarpRift create(Team team, UnitType unitType, float x, float y, float rotation) {
        this.team = team;
        this.unitType = unitType;
        this.x = x;
        this.y = y;
        this.rotation = rotation;
        this.range = unitType.clipSize;
        return this;
    }

    public void draw() {
        Draw.color((Color)this.team.color);
        Draw.reset();
        this.drawUnit();
    }

    public void update() {
        this.warpTimer += Time.delta;
        this.timer += Time.delta;
        float rad = this.range * this.portalProgress();
        int count = (int)(rad / 5.0f);
        if (this.timer >= 1.0f) {
            this.timer %= 1.0f;
        }
        if (this.warpTimer >= this.spawnTime() && !this.created) {
            this.dump();
            this.remove();
        }
    }

    public float portalProgress() {
        if (this.warpTimer < this.warpChargeTime) {
            return 0.0f;
        }
        if (this.warpTimer < this.warpBeginTime + this.warpChargeTime) {
            return (this.warpTimer - this.warpChargeTime) / this.warpBeginTime;
        }
        if (this.warpTimer < this.warpTime + this.warpBeginTime + this.warpChargeTime) {
            return 1.0f;
        }
        if (this.warpTimer < this.warpEndTime + this.warpTime + this.warpBeginTime + this.warpChargeTime) {
            return 1.0f - (this.warpTimer - (this.warpTime + this.warpBeginTime + this.warpChargeTime)) / this.warpEndTime;
        }
        return 0.0f;
    }

    public void dump() {
        this.toSpawn = this.unitType.create(this.team);
        this.toSpawn.set(this.x, this.y);
        this.toSpawn.rotation = this.rotation();
        if (!Double.isNaN(this.flagToApply)) {
            this.toSpawn.flag(this.flagToApply);
        }
        if (!Vars.net.client()) {
            this.toSpawn.add();
        }
        this.toSpawn.apply(StatusEffects.unmoving, Fx.unitSpawn.lifetime);
        this.toSpawn.apply(this.statusEntry.effect, this.statusEntry.time);
        if (this.commandPos != null && !this.commandPos.isNaN()) {
            if (this.toSpawn.isCommandable()) {
                this.toSpawn.command().commandPosition(this.commandPos);
            } else {
                CommandAI ai = new CommandAI();
                ai.commandPosition(this.commandPos);
                this.toSpawn.controller((UnitController)ai);
            }
        }
        this.created = true;
        Events.fire((Object)new EventType.UnitCreateEvent(this.toSpawn, null));
    }

    public void effect() {
        if (Vars.headless) {
            return;
        }
        GridData grid = (GridData)GridUtil.unitGridsMap.get((Object)this.unitType.name);
        for (int gy = grid.height - 1; gy > 0; --gy) {
            for (int gx = 0; gx < grid.width; ++gx) {
                if (grid.getGrid(grid.width - gx - 1, gy) <= 0) continue;
                float sx = grid.xShift / 8.0f + (float)(gx * 4) - (float)this.unitType.fullIcon.width / 8.0f;
                float sy = grid.yShift / 8.0f + (float)(gy * 4) - (float)this.unitType.fullIcon.height / 8.0f;
                float delay = (float)gy * (285.0f / (float)grid.height);
                Tmp.v1.set(sx, sy).rotate(this.rotation + 90.0f).add(this.x, this.y);
                this.gridSpark(Tmp.v1.x, Tmp.v1.y, delay);
            }
        }
        this.createdSpark();
    }

    private void gridSpark(float x, float y, float delay) {
        Effect gridSpark = new Effect(120.0f, e -> {
            rand.setSeed((long)e.id);
            Tmp.v1.trns(this.rotation + 180.0f, this.range * rand.random(1.0f, 5.0f) * e.fout((Interp)Interp.pow3In));
            Draw.color((Color)this.team.color, (Color)Color.white, (float)e.fslope());
            Draw.alpha((float)(1.2f * e.fout((Interp)Interp.pow10Out)));
            Lines.stroke((float)4.0f);
            Lines.lineAngle((float)(e.x + Tmp.v1.x), (float)(e.y + Tmp.v1.y), (float)this.rotation, (float)(2.0f * (e.fslope() * 5.0f + e.fin())));
        });
        gridSpark.startDelay = delay;
        gridSpark.at(x, y, this.rotation);
    }

    private void createdSpark() {
        Effect spawn = new Effect(65.0f, e -> {
            Draw.mixcol((Color)this.team.color, (Color)Color.white, (float)e.fout());
            Draw.alpha((float)(1.2f * e.fout((Interp)Interp.pow2Out)));
            Draw.rect((TextureRegion)this.unitType.fullIcon, (float)e.x, (float)e.y, (float)((float)this.unitType.fullIcon.width * Draw.scl * (1.0f + 0.06f * e.fin((Interp)Interp.pow2Out))), (float)((float)this.unitType.fullIcon.height * Draw.scl * (1.0f + 0.06f * e.fin((Interp)Interp.pow2Out))), (float)this.rotDeg());
            Draw.reset();
        });
        spawn.startDelay = 375.0f;
        spawn.at(this.x, this.y, this.rotation);
    }

    public void drawUnit() {
        if (this.warpTimer > 420.0f) {
            return;
        }
        this.drawExtraDrawer();
        if (this.warpTimer > 400.0f) {
            return;
        }
        float progress = Mathf.clamp((float)((this.warpTimer - 100.0f) / 285.0f));
        int height = Mathf.ceil((float)((float)this.unitType.fullIcon.height * progress));
        Tmp.tr1.set(this.unitType.fullIcon, 0, 0, this.unitType.fullIcon.width, height);
        Tmp.v1.trns(this.rotation, (float)(this.unitType.fullIcon.height - height) / 8.0f).add(this.x, this.y);
        Draw.z((float)90.0f);
        Draw.rect((TextureRegion)Tmp.tr1, (float)Tmp.v1.x, (float)Tmp.v1.y, (float)(this.rotation - 90.0f));
        if (this.unitType.flying) {
            Draw.z((float)89.5f);
            float e = this.unitType.shadowElevation * this.unitType.shadowElevationScl;
            Drawf.shadow((TextureRegion)Tmp.tr1, (float)(Tmp.v1.x - -12.0f * e), (float)(Tmp.v1.y - -13.0f * e), (float)this.rotDeg());
        }
        Draw.z((float)89.0f);
        this.unitType.drawSoftShadow(Tmp.v1.x, Tmp.v1.y, this.rotation, progress);
    }

    public void drawExtraDrawer() {
        for (Ability ability : this.unitType.abilities) {
            if (!(ability instanceof ShieldArcAbility)) continue;
            ShieldArcAbility sa = (ShieldArcAbility)ability;
            float progress = Mathf.clamp((float)((this.warpTimer - 100.0f) / 320.0f));
            Draw.z((float)125.0f);
            Draw.color((Color)this.team.color);
            if (!Vars.renderer.animateShields) {
                Draw.alpha((float)0.4f);
            }
            if (sa.drawArc) {
                Lines.stroke((float)(sa.width * progress));
                Lines.arc((float)this.x, (float)this.y, (float)sa.radius, (float)(sa.angle / 360.0f), (float)(this.rotation + sa.angleOffset - sa.angle / 2.0f));
            }
            Draw.reset();
        }
    }

    @Override
    public void add() {
        super.add();
        Groups.sync.add((Entityc)this);
        NHFx.spawnWave.at(this.x, this.y, this.drawSize * 1.1f, this.team.color);
    }

    public void afterReadAll() {
    }

    public void beforeWrite() {
    }

    @Override
    public void remove() {
        super.remove();
        Groups.sync.remove((Entityc)this);
        if (Vars.net.client()) {
            Vars.netClient.addRemovedEntity(this.id());
        }
    }

    public float spawnTime() {
        return this.warpChargeTime + this.warpBeginTime + this.warpTime;
    }

    public float rotDeg() {
        return this.rotation - 90.0f;
    }

    public Building buildOn() {
        return null;
    }

    public boolean isSyncHidden(Player player) {
        return false;
    }

    public long lastUpdated() {
        return 0L;
    }

    public long updateSpacing() {
        return 0L;
    }

    public void afterSync() {
    }

    public void handleSyncHidden() {
    }

    public void interpolate() {
    }

    public void lastUpdated(long lastUpdated) {
    }

    public void readSyncManual(FloatBuffer buffer) {
    }

    public void snapInterpolation() {
    }

    public void snapSync() {
    }

    public void updateSpacing(long updateSpacing) {
    }

    @Override
    public boolean serialize() {
        return true;
    }

    @Override
    public int classId() {
        return EntityRegister.getID(this.getClass());
    }

    @Override
    public void write(Writes write) {
        super.write(write);
        write.f(this.warpTimer);
        write.f(this.rotation);
        TypeIO.writeUnitType((Writes)write, (UnitType)this.unitType);
        TypeIO.writeTeam((Writes)write, (Team)this.team);
        TypeIO.writeStatus((Writes)write, (StatusEntry)this.statusEntry);
        TypeIO.writeVec2((Writes)write, (Vec2)this.commandPos);
    }

    @Override
    public void read(Reads read) {
        super.read(read);
        this.warpTimer = read.f();
        this.rotation = read.f();
        this.unitType = TypeIO.readUnitType((Reads)read);
        this.team = TypeIO.readTeam((Reads)read);
        this.statusEntry = TypeIO.readStatus((Reads)read);
        this.commandPos = TypeIO.readVec2((Reads)read);
        this.afterRead();
    }

    public void writeSync(Writes write) {
        write.f(this.x);
        write.f(this.y);
        write.f(this.warpTimer);
        write.f(this.rotation);
        TypeIO.writeUnitType((Writes)write, (UnitType)this.unitType);
        TypeIO.writeTeam((Writes)write, (Team)this.team);
        TypeIO.writeVec2((Writes)write, (Vec2)this.commandPos);
    }

    public void readSync(Reads read) {
        this.x = read.f();
        this.y = read.f();
        this.warpTimer = read.f();
        this.rotation = read.f();
        this.unitType = TypeIO.readUnitType((Reads)read);
        this.team = TypeIO.readTeam((Reads)read);
        this.statusEntry = TypeIO.readStatus((Reads)read);
        this.commandPos = TypeIO.readVec2((Reads)read);
        this.afterRead();
    }

    public void writeSyncManual(FloatBuffer buffer) {
    }

    public boolean inFogTo(Team viewer) {
        return false;
    }

    public boolean cheating() {
        return false;
    }

    public Team team() {
        return null;
    }

    public CoreBlock.CoreBuild closestCore() {
        return null;
    }

    public CoreBlock.CoreBuild closestEnemyCore() {
        return null;
    }

    public CoreBlock.CoreBuild core() {
        return null;
    }

    public void team(Team team) {
    }

    public float rotation() {
        return this.rotation;
    }

    public void rotation(float rotation) {
    }
}

