/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.game.MapMarker;

import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Time;
import arc.util.Tmp;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import mindustry.Vars;
import mindustry.game.MapObjectives;
import mindustry.game.Team;
import newhorizon.content.NHContent;
import newhorizon.expand.game.MapObjectives.TriggerObjective;
import newhorizon.util.graphic.DrawFunc;

public class RaidIndicator
extends MapObjectives.PosMarker {
    public Vec2 source = new Vec2();
    public Vec2 target = new Vec2();
    public int teamID;
    public int icon;
    public float radius;
    public String timerName;

    public RaidIndicator(String name) {
        this.teamID = Team.crux.id;
        this.icon = 0;
        this.radius = 50.0f;
        this.timerName = "event-timer";
        this.timerName = name;
    }

    public RaidIndicator() {
        this.teamID = Team.crux.id;
        this.icon = 0;
        this.radius = 50.0f;
        this.timerName = "event-timer";
    }

    public TextureRegion icon() {
        TextureRegion textureRegion;
        switch (this.icon) {
            case 1: {
                textureRegion = NHContent.raid;
                break;
            }
            case 2: {
                textureRegion = NHContent.fleet;
                break;
            }
            case 3: {
                textureRegion = NHContent.capture;
                break;
            }
            default: {
                textureRegion = NHContent.objective;
            }
        }
        return textureRegion;
    }

    public RaidIndicator init(int teamID, int icon, float radius, String timerName) {
        this.teamID = teamID;
        this.icon = icon;
        this.radius = radius;
        this.timerName = timerName;
        return this;
    }

    public RaidIndicator setPosition(Vec2 source, Vec2 target) {
        this.source.set(source);
        this.target.set(target);
        return this;
    }

    public void draw(float scaleFactor) {
        this.draw();
        this.drawArrow();
    }

    public void draw() {
        Team team = Team.get((int)this.teamID);
        float fin = this.progress();
        Draw.blend((Blending)Blending.additive);
        Draw.z((float)76.0f);
        Draw.color((Color)team.color, (Color)Color.white, (float)0.075f);
        Draw.alpha((float)0.65f);
        float f = Interp.pow3Out.apply(Mathf.curve((float)(1.0f - fin), (float)0.0f, (float)0.01f));
        Draw.rect((TextureRegion)this.icon(), (Position)this.target, (float)((float)NHContent.fleet.width * f * Draw.scl), (float)((float)NHContent.fleet.height * f * Draw.scl), (float)0.0f);
        Lines.stroke((float)(5.0f * f));
        Lines.circle((float)this.target.x, (float)this.target.y, (float)(this.radius * (1.0f + Mathf.absin((float)4.0f, (float)0.055f))));
        DrawFunc.circlePercent(this.target.x, this.target.y, this.radius * 0.875f, fin, 0.0f);
        Draw.reset();
        Draw.blend();
    }

    public void drawArrow() {
        float ang = this.source.angleTo((Position)this.target);
        Draw.color((Color)Team.get((int)this.teamID).color, (Color)Color.white, (float)0.075f);
        Draw.blend((Blending)Blending.additive);
        float size = NHContent.arrowRegion.height;
        int i = 0;
        while ((float)i < this.radius / size * 8.0f) {
            float s = (1.0f - (Time.time + (float)(25 * i)) % 100.0f / 100.0f) * this.scale() * Draw.scl * 1.75f;
            Tmp.v1.trns(ang + 180.0f, (float)(36 + 12 * i)).add(this.target);
            Draw.rect((TextureRegion)NHContent.arrowRegion, (Position)Tmp.v1, (float)(size * s), (float)(size * s), (float)(ang - 90.0f));
            ++i;
        }
        Draw.blend();
    }

    public float progress() {
        AtomicReference<Float> progress = new AtomicReference<Float>(Float.valueOf(0.0f));
        Vars.state.rules.objectives.each(mapObjective -> {
            if (mapObjective instanceof TriggerObjective) {
                TriggerObjective obj = (TriggerObjective)((Object)mapObjective);
                if (Objects.equals(obj.timer, this.timerName)) {
                    progress.set(Float.valueOf(Mathf.clamp((float)(obj.getCountup() / obj.duration))));
                }
            }
        });
        return progress.get().floatValue();
    }

    public float scale() {
        return Interp.pow3Out.apply(Mathf.curve((float)(1.0f - this.progress()), (float)0.0f, (float)0.05f));
    }
}

