/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.game;

import arc.Events;
import arc.struct.ObjectMap;
import arc.util.Log;
import arc.util.io.Reads;
import arc.util.io.Writes;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import mindustry.Vars;
import mindustry.ctype.UnlockableContent;
import mindustry.game.EventType;
import mindustry.game.Team;
import mindustry.io.SaveFileReader;
import mindustry.type.PayloadSeq;

public class TeamPayloadData
implements SaveFileReader.CustomChunk {
    public ObjectMap<Team, PayloadSeq> teamPayloadData = new ObjectMap();

    public TeamPayloadData() {
        Events.on(EventType.ResetEvent.class, event -> this.teamPayloadData.clear());
    }

    public void addPayload(Team team, UnlockableContent content, int count) {
        PayloadSeq payload = this.getPayload(team);
        payload.add(content, count);
        this.teamPayloadData.put((Object)team, (Object)payload);
    }

    public void removePayload(Team team, UnlockableContent content, int count) {
        PayloadSeq payload = this.getPayload(team);
        if (payload.get(content) < count) {
            return;
        }
        payload.remove(content, count);
        this.teamPayloadData.remove((Object)team);
    }

    public PayloadSeq getPayload(Team team) {
        PayloadSeq payload = (PayloadSeq)this.teamPayloadData.get((Object)team);
        if (payload == null) {
            payload = new PayloadSeq();
            this.teamPayloadData.put((Object)team, (Object)payload);
        }
        return payload;
    }

    public void display() {
        StringBuilder sb = new StringBuilder();
        sb.append("Team Payload Data\n");
        this.teamPayloadData.each((team, payload) -> {
            sb.append("-----").append(team.name).append("-----").append("\n");
            Vars.content.each(content -> {
                UnlockableContent uc;
                if (content instanceof UnlockableContent && payload.get(uc = (UnlockableContent)content) != 0) {
                    sb.append(uc.name).append(" ").append(payload.get(uc)).append(" ").append("\n");
                }
            });
        });
        Log.info((Object)sb.toString());
    }

    public void write(DataOutput stream) throws IOException {
        try (Writes write = new Writes(stream);){
            write.b(this.teamPayloadData.size);
            this.teamPayloadData.each((team, payloadSeq) -> {
                write.b(team.id);
                payloadSeq.write(write);
            });
        }
    }

    public void read(DataInput stream) throws IOException {
        this.teamPayloadData.clear();
        try (Reads read = new Reads(stream);){
            int size = read.b();
            for (int i = 0; i < size; ++i) {
                Team team = Team.get((int)read.b());
                PayloadSeq payloadSeq = new PayloadSeq();
                payloadSeq.read(read);
                this.teamPayloadData.put((Object)team, (Object)payloadSeq);
            }
        }
    }

    public void read(DataInput stream, int length) throws IOException {
        this.read(stream);
    }
}

