/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.game;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import mindustry.Vars;
import mindustry.io.SaveFileReader;
import newhorizon.expand.game.NHWorldData;

public class WorldData
implements SaveFileReader.CustomChunk {
    public short version = 0;
    public float eventReloadSpeed = -1.0f;
    public boolean jumpGateUsesCoreItems = true;
    public boolean applyEventTriggers = false;

    public void write(DataOutput stream) throws IOException {
        stream.writeShort(NHWorldData.CURRENT_VER);
        stream.writeFloat(this.eventReloadSpeed);
        stream.writeBoolean(this.jumpGateUsesCoreItems);
        stream.writeBoolean(this.applyEventTriggers);
    }

    public void read(DataInput stream) throws IOException {
        this.version = stream.readShort();
        this.eventReloadSpeed = stream.readFloat();
        if (this.version > 0) {
            this.jumpGateUsesCoreItems = stream.readBoolean();
            this.applyEventTriggers = stream.readBoolean();
        }
        this.version = NHWorldData.CURRENT_VER;
        this.afterRead();
    }

    public void read(DataInput stream, int length) throws IOException {
        this.read(stream);
    }

    public void afterRead() {
        if (Vars.headless && (Float.isNaN(this.eventReloadSpeed) || this.eventReloadSpeed > 5.55f)) {
            this.eventReloadSpeed = -1.0f;
        }
    }
}

