/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.game;

import arc.math.geom.Point2;
import arc.struct.ByteSeq;
import arc.struct.IntSeq;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import mindustry.Vars;
import mindustry.io.SaveFileReader;
import mindustry.world.Tile;

public class WorldTileData
implements SaveFileReader.CustomChunk {
    public IntSeq packPos = new IntSeq();
    public ByteSeq tileByte = new ByteSeq();

    public void addTileData(int x, int y, byte data) {
        this.packPos.add(Point2.pack((int)x, (int)y));
        this.tileByte.add(data);
    }

    public void setupWorldTile() {
        for (int i = 0; i < this.packPos.size; ++i) {
            Tile tile = Vars.world.tile(this.packPos.get(i));
            if (tile == null) continue;
            tile.data = this.tileByte.get(i);
            tile.recache();
        }
    }

    public void write(DataOutput stream) throws IOException {
        if (this.packPos.size != this.tileByte.size) {
            throw new IOException("size not match!");
        }
        stream.writeInt(this.packPos.size);
        for (int i = 0; i < this.packPos.size; ++i) {
            stream.writeInt(this.packPos.get(i));
            stream.writeByte(this.tileByte.get(i));
        }
    }

    public void read(DataInput stream) throws IOException {
        this.packPos.clear();
        this.tileByte.clear();
        int size = stream.readInt();
        for (int i = 0; i < size; ++i) {
            this.packPos.add(stream.readInt());
            this.tileByte.add(stream.readByte());
        }
        this.setupWorldTile();
    }
}

