/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.graphics;

import arc.graphics.Color;
import arc.math.Mathf;
import arc.math.geom.Vec3;
import arc.util.noise.Simplex;
import mindustry.graphics.Shaders;
import mindustry.graphics.g3d.HexMesher;
import mindustry.graphics.g3d.MeshBuilder;
import mindustry.graphics.g3d.PlanetMesh;
import mindustry.graphics.g3d.PlanetParams;
import mindustry.type.Planet;

public class HexMeshExpand
extends PlanetMesh {
    public HexMeshExpand(Planet planet, int divisions, final double octaves, final double persistence, final double scl, final double pow, final double mag, final float colorScale, float sizeScale, final Color ... colors) {
        super(planet, MeshBuilder.buildHex((HexMesher)new HexMesher(){

            public float getHeight(Vec3 position) {
                return 0.0f;
            }

            public void getColor(Vec3 position, Color out) {
                double height = Math.pow(Simplex.noise3d((int)0, (double)octaves, (double)persistence, (double)scl, (double)position.x, (double)position.y, (double)position.z), pow) * mag;
                out.set(colors[Mathf.clamp((int)((int)(height * (double)colors.length)), (int)0, (int)(colors.length - 1))]).mul(colorScale);
            }
        }, (int)divisions, (float)(planet.radius * sizeScale), (float)0.2f), Shaders.unlit);
    }

    public void preRender(PlanetParams params) {
        Shaders.planet.planet = this.planet;
        Shaders.planet.lightDir.set(this.planet.solarSystem.position).sub(this.planet.position).rotate(Vec3.Y, this.planet.getRotation()).nor();
        Shaders.planet.ambientColor.set(this.planet.solarSystem.lightColor);
    }
}

