/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.logic;

import arc.Core;
import arc.flabel.FLabel;
import arc.func.Cons;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Vec2;
import arc.scene.Element;
import arc.scene.ui.layout.Table;
import arc.struct.Seq;
import arc.util.Log;
import arc.util.Time;
import arc.util.Tmp;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import mindustry.Vars;
import mindustry.entities.bullet.BulletType;
import mindustry.game.MapObjectives;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Call;
import mindustry.logic.LAssembler;
import mindustry.logic.LCategory;
import mindustry.logic.LExecutor;
import mindustry.logic.LStatement;
import mindustry.logic.LVar;
import mindustry.ui.Styles;
import mindustry.world.Tile;
import mindustry.world.meta.BlockFlag;
import newhorizon.content.NHBullets;
import newhorizon.content.NHContent;
import newhorizon.content.NHSounds;
import newhorizon.expand.game.MapMarker.RaidIndicator;
import newhorizon.expand.game.MapObjectives.TriggerObjective;
import newhorizon.expand.logic.ThreatLevel;
import newhorizon.expand.net.NHCall;
import newhorizon.util.func.WeightedRandom;
import newhorizon.util.struct.WeightedOption;
import newhorizon.util.ui.NHUIFunc;

public class DefaultRaid
extends LStatement {
    public String flag = "event-executor";
    public String timer = "event-timer";
    public String alertTime = "30";
    public String raidTime = "5";
    public String bulletDamage = "200";
    public String bulletSpeed = "1";
    public String bulletCount = "5";
    public String inaccuracy = "10";
    public Vec2 source = new Vec2();
    public Vec2 target = new Vec2();

    public DefaultRaid(String[] tokens) {
        try {
            this.flag = tokens[1];
            this.timer = tokens[2];
            this.alertTime = tokens[3];
            this.raidTime = tokens[4];
            this.bulletDamage = tokens[5];
            this.bulletSpeed = tokens[6];
            this.bulletCount = tokens[7];
            this.inaccuracy = tokens[8];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Log.err((Throwable)e);
        }
    }

    public DefaultRaid() {
    }

    public void build(Table table) {
        table.table(t -> {
            t.add((CharSequence)" Executor Flag : ");
            this.fields((Table)t, this.flag, str -> {
                this.flag = str;
            }).width(180.0f);
        }).left();
        table.row();
        table.table(t -> {
            t.add((CharSequence)" Timer Name : ");
            this.fields((Table)t, this.timer, str -> {
                this.timer = str;
            }).width(180.0f);
        }).left();
        table.row();
        table.table(t -> {
            t.add((CharSequence)" Alert Time: ");
            this.fields((Table)t, this.alertTime, str -> {
                this.alertTime = str;
            });
            t.add((CharSequence)"(s), Raid Time: ");
            this.fields((Table)t, this.raidTime, str -> {
                this.raidTime = str;
            });
            t.add((CharSequence)"(s)");
        }).left();
        table.row();
        table.table(t -> {
            t.add((CharSequence)" Bullet Damage  : ");
            this.fields((Table)t, this.bulletDamage, str -> {
                this.bulletDamage = str;
            });
        }).left();
        table.row();
        table.table(t -> {
            t.add((CharSequence)" Bullet Speed  : ");
            this.fields((Table)t, this.bulletSpeed, str -> {
                this.bulletSpeed = str;
            });
        }).left();
        table.row();
        table.table(t -> {
            t.add((CharSequence)" Raid Count: ");
            this.fields((Table)t, this.bulletCount, str -> {
                this.bulletCount = str;
            });
        }).left();
        table.row();
        table.table(t -> {
            t.add((CharSequence)" Inaccuracy Radius: ");
            this.fields((Table)t, this.inaccuracy, str -> {
                this.inaccuracy = str;
            });
        }).left();
    }

    public boolean privileged() {
        return true;
    }

    public LCategory category() {
        return NHContent.nhwproc;
    }

    public void write(StringBuilder builder) {
        builder.append("defaultraid").append(" ");
        builder.append(this.flag).append(" ");
        builder.append(this.timer).append(" ");
        builder.append(this.alertTime).append(" ");
        builder.append(this.raidTime).append(" ");
        builder.append(this.bulletDamage).append(" ");
        builder.append(this.bulletSpeed).append(" ");
        builder.append(this.bulletCount).append(" ");
        builder.append(this.inaccuracy).append(" ");
    }

    public LExecutor.LInstruction build(LAssembler builder) {
        return new DefaultRaidInstruction(builder.var(this.flag), builder.var(this.timer), builder.var(this.alertTime), builder.var(this.raidTime), builder.var(this.bulletDamage), builder.var(this.bulletSpeed), builder.var(this.bulletCount), builder.var(this.inaccuracy));
    }

    public static void clientAlertHud(String timerName, float time, float range, float sx, float sy, float tx, float ty) {
        Team wave = Vars.state.rules.waveTeam;
        NHUIFunc.showLabel(2.5f, (Cons<Table>)((Cons)t -> {
            t.background(Styles.black5);
            t.table(t2 -> {
                t2.image().growX().height(6.0f).pad(4.0f).padRight(-9.0f).color(wave.color);
                t2.image(NHContent.raid).fill().color(wave.color);
                t2.image().growX().height(6.0f).pad(4.0f).padLeft(-9.0f).color(wave.color);
            }).growX().pad(6.0f).fillY().row();
            t.table(l -> l.add((Element)new FLabel((CharSequence)("<< " + Core.bundle.get("nh.cutscene.event.raid-alert") + " >>"))).color(wave.color).padBottom(4.0f).row()).growX().fillY();
        }));
        NHSounds.alert2.play();
        Vars.state.rules.objectives.each(mapObjective -> {
            if (mapObjective instanceof TriggerObjective) {
                TriggerObjective obj = (TriggerObjective)((Object)mapObjective);
                if (Objects.equals(obj.timer, timerName)) {
                    obj.trigger(time * 60.0f);
                    for (MapObjectives.ObjectiveMarker marker : obj.markers) {
                        if (!(marker instanceof RaidIndicator)) continue;
                        RaidIndicator idc = (RaidIndicator)marker;
                        idc.init(wave.id, 1, range * 8.0f, timerName).setPosition(Tmp.v2.set(sx, sy), Tmp.v3.set(tx, ty));
                    }
                }
            }
        });
    }

    public class DefaultRaidInstruction
    implements LExecutor.LInstruction {
        public LVar flag;
        public LVar timer;
        public LVar alertTime;
        public LVar raidTime;
        public LVar damage;
        public LVar speed;
        public LVar count;
        public LVar inaccuracy;
        public int raidCounter = 0;
        public float curTime;
        public boolean iconShown = false;
        public boolean labelShown = false;
        public int threatLevel = 0;

        public DefaultRaidInstruction(LVar flag, LVar timer, LVar alertTime, LVar raidTime, LVar damage, LVar speed, LVar count, LVar inaccuracy) {
            this.flag = flag;
            this.timer = timer;
            this.alertTime = alertTime;
            this.raidTime = raidTime;
            this.damage = damage;
            this.speed = speed;
            this.count = count;
            this.inaccuracy = inaccuracy;
        }

        public void run(LExecutor exec) {
            if (!Vars.state.rules.objectiveFlags.contains((Object)this.flag.name)) {
                exec.counter.numval -= 1.0;
                exec.yield = true;
                return;
            }
            float totalTime = this.alertTime.numf() + this.raidTime.numf();
            if (this.curTime >= totalTime) {
                this.reset();
            } else {
                exec.counter.numval -= 1.0;
                exec.yield = true;
                this.curTime += Time.delta / 60.0f;
                if (!this.iconShown) {
                    this.showAlert();
                }
                if (this.curTime > this.alertTime.numf()) {
                    if (!this.labelShown) {
                        this.showLabel();
                    }
                    float raidTimer = this.curTime - this.alertTime.numf();
                    int raidCount = Mathf.round((float)(raidTimer / this.raidTime.numf() * (float)this.count.numi() * this.threatScl()));
                    int raid = raidCount - this.raidCounter;
                    this.raidCounter = raidCount;
                    for (int i = 0; i < raid; ++i) {
                        this.createBullet();
                    }
                }
            }
        }

        public void updatePosition() {
            float wx = Mathf.random((int)0, (int)Vars.world.unitWidth());
            float wy = Mathf.random((int)0, (int)Vars.world.unitHeight());
            Seq spawns = Vars.spawner.getSpawns();
            if (!spawns.isEmpty()) {
                Tile t = (Tile)spawns.random();
                DefaultRaid.this.source.set(t.worldx(), t.worldy());
            } else {
                DefaultRaid.this.source.setZero();
            }
            AtomicReference<BlockFlag> flag = new AtomicReference<BlockFlag>(BlockFlag.core);
            WeightedRandom.random(new WeightedOption(3.0f, () -> flag.set(BlockFlag.turret)), new WeightedOption(3.0f, () -> flag.set(BlockFlag.generator)), new WeightedOption(3.0f, () -> flag.set(BlockFlag.factory)), new WeightedOption(1.0f, () -> flag.set(BlockFlag.core)));
            Building b = (Building)Geometry.findClosest((float)wx, (float)wy, (Iterable)Vars.indexer.getEnemy(Vars.state.rules.waveTeam, flag.get()));
            if (b == null) {
                b = Vars.state.rules.defaultTeam.core();
            }
            if (b != null) {
                DefaultRaid.this.target.set(b.x, b.y);
            } else {
                DefaultRaid.this.target.setZero();
            }
            this.threatLevel = Math.max(ThreatLevel.getTeamThreat(Vars.state.rules.defaultTeam), 1);
        }

        public void reset() {
            this.curTime = 0.0f;
            this.iconShown = false;
            this.labelShown = false;
            Vars.state.rules.objectiveFlags.remove((Object)this.flag.name);
        }

        public float threatScl() {
            return Mathf.sqrt((float)this.threatLevel);
        }

        public void createBullet() {
            BulletType bulletType = NHBullets.raidBulletType;
            float dmg = this.damage.numf() * (float)this.threatLevel;
            float spd = this.speed.numf();
            if (spd <= 0.0f) {
                spd = 1.0f;
            }
            Tmp.v1.trns(Mathf.random((float)360.0f), Mathf.random((float)(this.inaccuracy.numf() * 8.0f)));
            float sx = DefaultRaid.this.source.x;
            float sy = DefaultRaid.this.source.y;
            float tx = DefaultRaid.this.target.x;
            float ty = DefaultRaid.this.target.y;
            float dst = Mathf.dst((float)sx, (float)sy, (float)tx, (float)ty);
            float ang = Angles.angle((float)sx, (float)sy, (float)tx, (float)ty);
            float lifetimeScl = dst / (bulletType.speed * bulletType.lifetime * spd);
            Call.createBullet((BulletType)bulletType, (Team)Vars.state.rules.waveTeam, (float)(sx + Tmp.v1.x), (float)(sy + Tmp.v1.y), (float)ang, (float)dmg, (float)spd, (float)lifetimeScl);
        }

        public void showLabel() {
            NHCall.alertToastTable(1, 1, "[#ff7b69]Raid: []<" + (int)(DefaultRaid.this.target.x / 8.0f) + "," + (int)(DefaultRaid.this.target.y / 8.0f) + ">");
            this.labelShown = true;
        }

        public void showAlert() {
            this.updatePosition();
            this.iconShown = true;
            this.raidCounter = 0;
            NHCall.warnHudPacket(this.timer.name, this.alertTime.numf(), this.inaccuracy.numf(), DefaultRaid.this.source.x, DefaultRaid.this.source.y, DefaultRaid.this.target.x, DefaultRaid.this.target.y);
        }
    }
}

