/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.logic.instructions;

import arc.math.Angles;
import arc.math.Mathf;
import arc.math.Rand;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Call;
import mindustry.logic.LExecutor;
import mindustry.logic.LVar;
import newhorizon.content.NHBullets;
import newhorizon.content.bullets.RaidBullets;

public class SpawnBulletI
implements LExecutor.LInstruction {
    public LVar team;
    public LVar type;
    public LVar seed;
    public LVar count;
    public LVar sourceX;
    public LVar sourceY;
    public LVar targetX;
    public LVar targetY;
    public LVar inaccuracy;

    public SpawnBulletI(LVar team, LVar type, LVar seed, LVar count, LVar sourceX, LVar sourceY, LVar targetX, LVar targetY, LVar inaccuracy) {
        this.team = team;
        this.type = type;
        this.seed = seed;
        this.count = count;
        this.sourceX = sourceX;
        this.sourceY = sourceY;
        this.targetX = targetX;
        this.targetY = targetY;
        this.inaccuracy = inaccuracy;
    }

    public void run(LExecutor exec) {
        if (!exec.privileged) {
            return;
        }
        Team t = this.team.team();
        if (t == null) {
            return;
        }
        int s = this.seed.numi();
        int tp = this.type.numi();
        int ct = this.count.numi();
        int sx = this.sourceX.numi();
        int sy = this.sourceY.numi();
        int tx = this.targetX.numi();
        int ty = this.targetY.numi();
        int inacc = this.inaccuracy.numi();
        Rand r = new Rand((long)s);
        for (int i = 0; i < ct; ++i) {
            Tmp.v1.trns(r.random(360.0f), (float)r.random(inacc));
            float dst = Mathf.dst((float)sx, (float)sy, (float)tx, (float)ty);
            float ang = Angles.angle((float)sx, (float)sy, (float)tx, (float)ty);
            float scl = Mathf.clamp((float)(dst / (this.bulletType((int)tp).speed * this.bulletType((int)tp).lifetime)), (float)0.0f, (float)10.0f);
            if (this.bulletType((int)tp).speed < 0.01f) {
                scl = 1.0f;
            }
            Call.createBullet((BulletType)this.bulletType(tp), (Team)t, (float)((float)sx + Tmp.v1.x), (float)((float)sy + Tmp.v1.y), (float)ang, (float)-1.0f, (float)1.0f, (float)scl);
        }
    }

    public BulletType bulletType(int type) {
        if (type < 10000) {
            BulletType bulletType;
            switch (type) {
                case 1: {
                    bulletType = RaidBullets.raidBullet_1;
                    break;
                }
                case 2: {
                    bulletType = RaidBullets.raidBullet_2;
                    break;
                }
                case 3: {
                    bulletType = RaidBullets.raidBullet_3;
                    break;
                }
                case 4: {
                    bulletType = RaidBullets.raidBullet_4;
                    break;
                }
                case 5: {
                    bulletType = RaidBullets.raidBullet_5;
                    break;
                }
                case 6: {
                    bulletType = RaidBullets.raidBullet_6;
                    break;
                }
                case 7: {
                    bulletType = RaidBullets.raidBullet_7;
                    break;
                }
                case 8: {
                    bulletType = RaidBullets.raidBullet_8;
                    break;
                }
                default: {
                    bulletType = NHBullets.railGun1;
                }
            }
            return bulletType;
        }
        if (Vars.content.bullet(type - 10000) != null) {
            return Vars.content.bullet(type - 10000);
        }
        return Vars.content.bullet(0);
    }
}

