/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.map;

import arc.graphics.Color;
import arc.graphics.gl.Shader;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Mat3D;
import arc.math.geom.Vec3;
import arc.util.Time;
import mindustry.graphics.Shaders;
import mindustry.graphics.g3d.PlanetMesh;
import mindustry.graphics.g3d.PlanetParams;
import mindustry.type.Planet;
import newhorizon.expand.map.CylinderRingMeshBuilder;

public class DysonRingMesh
extends PlanetMesh {
    static Mat3D mat = new Mat3D();
    static Rand rand = new Rand();
    public Vec3 flipAngle = new Vec3();
    public float flipValue = 0.0f;
    public float flipSpeed = 0.0f;
    public float rotateSpeed = 0.5f;

    public DysonRingMesh(Planet planet, float radius, float height, int seed, Color color, Color color2) {
        super(planet, CylinderRingMeshBuilder.build(radius, height, 120, color, color2), (Shader)Shaders.clouds);
        rand.setSeed((long)seed);
        this.flipValue = rand.random(-180, 180);
        this.flipAngle.setToRandomDirection(rand);
        this.flipSpeed = rand.random(0.3f, 0.7f);
        this.rotateSpeed = rand.random(1.0f, 3.0f);
    }

    public DysonRingMesh() {
    }

    public float flipRot() {
        return Time.globalTime * this.flipSpeed / 40.0f + this.flipValue;
    }

    public float relRot() {
        return Time.globalTime * this.rotateSpeed / 40.0f;
    }

    public void render(PlanetParams params, Mat3D projection, Mat3D transform) {
        if (params.planet == this.planet && Mathf.zero((float)(1.0f - params.uiAlpha), (float)0.01f)) {
            return;
        }
        this.preRender(params);
        this.shader.bind();
        this.shader.setUniformMatrix4("u_proj", projection.val);
        this.shader.setUniformMatrix4("u_trans", DysonRingMesh.mat.setToTranslation((Vec3)this.planet.position).rotate((Vec3)this.flipAngle, (float)this.flipRot()).rotate((Vec3)Vec3.Y, (float)(this.planet.getRotation() + this.relRot())).val);
        this.shader.apply();
        this.mesh.render(this.shader, 4);
    }

    public void preRender(PlanetParams params) {
        Shaders.clouds.planet = this.planet;
        Shaders.clouds.lightDir.set(this.planet.solarSystem.position).sub(this.planet.position).rotate(this.flipAngle, this.flipRot()).rotate(Vec3.Y, this.planet.getRotation() + this.relRot()).nor();
        Shaders.clouds.ambientColor.set(this.planet.solarSystem.lightColor);
        Shaders.clouds.alpha = params.planet == this.planet ? 1.0f - params.uiAlpha : 1.0f;
    }
}

