/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.map;

import arc.func.Boolf;
import arc.func.Cons;
import arc.graphics.Color;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.math.geom.Vec3;
import arc.struct.IntSet;
import arc.util.Structs;
import arc.util.Tmp;
import arc.util.noise.Ridged;
import arc.util.noise.Simplex;
import mindustry.content.Blocks;
import mindustry.game.Schematics;
import mindustry.graphics.g3d.PlanetGrid;
import mindustry.maps.generators.PlanetGenerator;
import mindustry.type.Sector;
import mindustry.ui.dialogs.PlanetDialog;
import mindustry.world.Block;
import mindustry.world.Tile;
import mindustry.world.TileGen;
import mindustry.world.Tiles;
import mindustry.world.WorldParams;
import mindustry.world.blocks.environment.Floor;
import newhorizon.content.NHBlocks;
import newhorizon.content.blocks.EnvironmentBlock;

public class MidanthaPlanetGenerator
extends PlanetGenerator {
    public static Interp interp = new Interp.Exp(2.0f, 3.0f);
    public static IntSet altitudes = new IntSet();
    Block qd = NHBlocks.quantumFieldDeep;
    Block qn = NHBlocks.quantumField;
    Block cb = EnvironmentBlock.conglomerateSparse;
    Block dc = EnvironmentBlock.darkConglomerateSparse;
    Block th = EnvironmentBlock.thoriumStoneSparse;
    Block ze = EnvironmentBlock.zetaCrystalFloor;
    Block[][] terrains = new Block[][]{{this.qd, this.qd, this.qd, this.qd, this.qd}, {this.qd, this.qd, this.qn, this.qn, this.qn}, {this.qn, this.qn, this.qn, this.qn, this.qn}, {this.cb, this.cb, this.qn, this.qn, this.qn, this.qn, this.cb, this.qn, this.cb}, {this.cb, this.cb, this.qn, this.cb, this.cb, this.dc, this.dc, this.qn, this.cb}, {this.cb, this.cb, this.th, this.th, this.cb, this.cb, this.cb, this.dc, this.cb}, {this.dc, this.dc, this.th, this.th, this.dc, this.dc, this.cb, this.dc, this.cb}, {this.cb, this.cb, this.dc, this.cb, this.cb, this.dc, this.dc, this.dc, this.cb}, {this.cb, this.dc, this.dc, this.dc, this.cb, this.cb, this.cb, this.dc, this.dc}, {this.cb, this.dc, this.dc, this.dc, this.dc, this.cb, this.cb, this.dc, this.dc}, {this.dc, this.dc, this.qn, this.dc, this.dc, this.cb, this.cb, this.dc, this.dc}, {this.dc, this.qn, this.qd, this.qn, this.dc, this.dc, this.cb, this.cb, this.dc}, {this.dc, this.qn, this.qd, this.qn, this.th, this.dc, this.cb, this.cb, this.cb}, {this.dc, this.dc, this.qn, this.dc, this.th, this.dc, this.cb, this.cb, this.cb}, {this.dc, this.dc, this.dc, this.th, this.dc, this.dc, this.dc, this.dc, this.cb}, {this.cb, this.cb, this.cb, this.th, this.dc, this.dc, this.dc, this.cb, this.dc}, {this.cb, this.dc, this.cb, this.cb, this.th, this.th, this.dc, this.cb, this.dc}, {this.dc, this.dc, this.dc, this.dc, this.th, this.th, this.qn, this.cb, this.cb}, {this.cb, this.cb, this.dc, this.dc, this.th, this.cb, this.qn, this.dc, this.cb}, {this.cb, this.cb, this.cb, this.dc, this.cb, this.cb, this.cb, this.cb, this.cb}, {this.cb, this.cb, this.qn, this.qn, this.cb, this.cb, this.qn, this.qn, this.cb}, {this.qn, this.qn, this.qn, this.qn, this.qn}, {this.qd, this.qd, this.qn, this.qn, this.qd}, {this.qd, this.qd, this.qd, this.qd, this.qd}};
    public Color ammonia = Color.valueOf((String)"262762");
    public Color cryonite = Color.valueOf((String)"c5d7f0");
    public Color conglomerate = Color.valueOf((String)"303044");
    public Color zetaFloor = Color.valueOf((String)"e2bcb3");
    public Color thoriumFloor = Color.valueOf((String)"403649");
    public Color silicarColor = Color.valueOf((String)"4a4b53");
    public static float waterOffset;
    public float seaLevel = 0.42f;
    public float iceSheetLevel = 0.5f;
    public float snowLevel = 0.535f;

    public float getLatitude(Vec3 position) {
        return Math.abs(Mathf.atan2((float)position.y, (float)Mathf.sqrt((float)(Mathf.sqr((float)position.x) + Mathf.sqr((float)position.z)))) * 57.295776f - 90.0f);
    }

    public float getIceSheet(Vec3 position) {
        float scl = Interp.exp10.apply(Mathf.clamp((float)(this.getLatitude(position) / 90.0f)));
        return Math.max(this.seaLevel, Simplex.noise3d((int)(this.seed + 4923), (double)7.0, (double)0.6f, (double)0.42f, (double)position.x, (double)position.y, (double)position.z) * scl / 1.1f);
    }

    public float getLand(Vec3 position) {
        float scl = Interp.reverse.apply(Interp.exp5.apply(Mathf.clamp((float)(this.getLatitude(position) / 90.0f))));
        float base = Interp.reverse.apply(this.getLatitude(position) / 90.0f) * 0.025f;
        float land = Simplex.noise3d((int)(this.seed + 1465), (double)4.0, (double)0.32f, (double)0.45f, (double)position.x, (double)position.y, (double)position.z) * scl + base;
        if (land > this.seaLevel) {
            float mountain = Interp.exp5Out.apply(Ridged.noise3d((int)(this.seed + 4142), (double)position.x, (double)position.y, (double)position.z, (int)4, (float)2.21f)) * 0.75f;
            float height = Math.max(mountain, land) * scl + base;
            float river = Ridged.noise3d((int)(this.seed + 525), (double)(position.x + 12.0f), (double)(position.y + 42.0f), (double)(position.z + 92.0f), (int)6, (float)1.22f) * 0.3f;
            if (river > 0.0f) {
                height -= river / 2.0f;
            }
            return Math.max(this.seaLevel, height);
        }
        return this.seaLevel;
    }

    public float getSizeScl() {
        return 2200.0f;
    }

    public int getDensity(Vec3 position) {
        return Mathf.clamp((int)((int)(Simplex.noise3d((int)321, (double)12.0, (double)0.42f, (double)8.7f, (double)position.x, (double)position.y, (double)position.z) * 4.0f - 1.0f)), (int)0, (int)3);
    }

    public Block getFloor(Vec3 position) {
        int size = this.terrains.length;
        float scl = Mathf.clamp((float)(this.getRawNoise(position) * (float)size), (float)0.0f, (float)(size - 1)) / (float)size;
        int tSize = this.terrains[Mathf.round((float)(scl * (float)size))].length;
        float tScl = Mathf.clamp((float)(this.getTerrainNoise(position) * (float)tSize), (float)0.0f, (float)(tSize - 1)) / (float)tSize;
        return this.terrains[Mathf.round((float)(scl * (float)size))][Mathf.round((float)(tScl * (float)tSize))];
    }

    public void genTile(Vec3 position, TileGen tile) {
        tile.floor = this.getFloor(position);
        tile.block = tile.floor.asFloor().wall;
        int density = this.getDensity(position);
        if (tile.floor == EnvironmentBlock.conglomerateSparse) {
            if (density == 1) {
                tile.floor = EnvironmentBlock.conglomerate;
            }
            if (density == 2) {
                tile.floor = EnvironmentBlock.conglomerateDense;
            }
        }
        if (tile.floor == EnvironmentBlock.darkConglomerateSparse) {
            if (density == 1) {
                tile.floor = EnvironmentBlock.darkConglomerate;
            }
            if (density == 2) {
                tile.floor = EnvironmentBlock.darkConglomerateDense;
            }
        }
        if (tile.floor == EnvironmentBlock.thoriumStoneSparse) {
            if (density == 1) {
                tile.floor = EnvironmentBlock.thoriumStone;
            }
            if (density == 2) {
                tile.floor = EnvironmentBlock.thoriumStoneDense;
            }
        }
        if ((double)Ridged.noise3d((int)(this.seed + 124), (double)position.x, (double)position.y, (double)position.z, (int)4, (float)12.92f) > -0.45) {
            tile.block = Blocks.air;
        }
    }

    public float getRawHeight(Vec3 position) {
        return (float)Math.pow(Interp.reverse.apply(Mathf.clamp((float)(Math.abs(this.getRawNoise(position) - 0.645f) * 1.2f))) * 0.895f, 1.2f) + 0.15f;
    }

    public float getRawNoise(Vec3 position) {
        return Simplex.noise3d((int)321, (double)12.0, (double)0.42f, (double)1.7f, (double)position.x, (double)position.y, (double)position.z) * 1.4f;
    }

    public float getTerrainNoise(Vec3 position) {
        return Simplex.noise3d((int)192, (double)4.0, (double)0.85f, (double)2.8f, (double)position.x, (double)position.y, (double)position.z) * 1.1f;
    }

    public float getColorNoise(Vec3 position) {
        return 1.0f + (Simplex.noise3d((int)1, (double)6.0, (double)0.72f, (double)0.2f, (double)position.x, (double)position.y, (double)position.z) * 0.3f - 0.15f);
    }

    public void generate(Tiles tiles, Sector sec, WorldParams params) {
        this.tiles = tiles;
        this.seed = params.seedOffset + this.baseSeed;
        this.sector = sec;
        this.width = tiles.width;
        this.height = tiles.height;
        this.rand.setSeed((long)(sec.id + params.seedOffset + this.baseSeed));
        TileGen gen = new TileGen();
        Vec3 pos = new Vec3();
        for (int y = 0; y < this.height; ++y) {
            for (int x = 0; x < this.width; ++x) {
                gen.reset();
                pos.set(this.sector.rect.project((float)x / (float)tiles.width, (float)y / (float)tiles.height));
                this.genTile(pos, gen);
                Tile tile = new Tile(x, y, gen.floor, gen.overlay, gen.block);
                tiles.set(x, y, tile);
            }
        }
        this.generate(tiles, params);
    }

    public float getHeight(Vec3 position) {
        float height = this.getRawHeight(position);
        return Math.max(height, waterOffset) - 0.2f;
    }

    public void getColor(Vec3 position, Color out) {
        out.set(this.getFloor((Vec3)position).mapColor).mul(this.getColorNoise(position));
    }

    public boolean allowAcceleratorLanding(Sector sector) {
        return super.allowAcceleratorLanding(sector) && this.isLandSector(sector);
    }

    public boolean allowLanding(Sector sector) {
        return super.allowLanding(sector) && this.isLandSector(sector);
    }

    public boolean isLandSector(Sector sector) {
        if (sector == null) {
            return true;
        }
        int land = 0;
        if (this.getHeight(sector.tile.v) > this.seaLevel) {
            ++land;
        }
        for (PlanetGrid.Corner corner : sector.tile.corners) {
            if (!(this.getHeight(corner.v) > this.seaLevel)) continue;
            land += 5;
        }
        return land > 5;
    }

    protected void generate() {
        this.distort(6.0f, 12.0f);
        this.median(3);
        this.scatter(EnvironmentBlock.conglomerateDense, EnvironmentBlock.conglomerate, 0.35f);
        this.scatter(EnvironmentBlock.conglomerate, EnvironmentBlock.conglomerateSparse, 0.4f);
        this.scatter(EnvironmentBlock.darkConglomerateDense, EnvironmentBlock.darkConglomerate, 0.35f);
        this.scatter(EnvironmentBlock.darkConglomerate, EnvironmentBlock.darkConglomerateSparse, 0.4f);
        this.scatter(EnvironmentBlock.thoriumStoneDense, EnvironmentBlock.thoriumStone, 0.35f);
        this.scatter(EnvironmentBlock.thoriumStone, EnvironmentBlock.thoriumStoneSparse, 0.4f);
        this.decoration(0.025f);
        this.distort(4.0f, 4.0f);
        this.rand.setSeed((long)(this.seed + this.sector.id));
        int shift = this.rand.random(20, 80);
        this.each((x, y) -> {
            Tile t = this.tiles.get(x, y);
            if (!t.solid() && !this.tiles.get((int)x, (int)y).floor().asFloor().isLiquid) {
                boolean chanceLiquid;
                boolean baseChance = Ridged.noise2d((int)(this.baseSeed + this.sector.id), (double)x, (double)y, (int)3, (double)0.012f) > 0.158f;
                boolean chanceBlock = (this.noise(x, y, 5.0, 0.7f, 15.0, 3.0) > 1.55f || Mathf.chance((double)0.125)) && baseChance;
                boolean chanceFloor = (this.noise(x, y, 5.0, 0.7f, 15.0, 3.0) > 1.17f || Mathf.chance((double)0.175)) && baseChance;
                boolean bl = chanceLiquid = this.noise(x, y, 5.0, 0.7f, 15.0, 3.0) > 1.52f && baseChance;
                if (this.isOnLine(x, y, shift, 5) && chanceFloor) {
                    t.setFloor(Blocks.metalTiles11.asFloor());
                }
                if ((this.isOnLine(x, y, shift, 4) || this.isOnLine(x, y, shift, 3)) && chanceFloor) {
                    t.setFloor(Blocks.metalTiles9.asFloor());
                }
                if (this.isOnLine(x, y, shift, 2)) {
                    t.setBlock(Blocks.air);
                    if (chanceFloor) {
                        t.setFloor(Blocks.metalTiles11.asFloor());
                    }
                }
                if (this.isOnLine(x, y, shift, 0) || this.isOnLine(x, y, shift, 1)) {
                    t.setBlock(Blocks.air);
                    if (chanceLiquid) {
                        t.setFloor(NHBlocks.quantumFieldDisturbing.asFloor());
                    }
                }
            }
        });
        this.distort(5.0f, 2.0f);
        Vec2 trns = Tmp.v1.trns(this.rand.random(360.0f), (float)this.width / 2.6f);
        int coreX = (int)(-trns.x + (float)this.width / 2.0f);
        int coreY = (int)(-trns.y + (float)this.height / 2.0f);
        Schematics.placeLaunchLoadout((int)coreX, (int)coreY);
    }

    private void drawLine(int rad, Block block) {
        this.rand.setSeed((long)(this.seed + this.sector.id));
        int shift = this.rand.random(20, 80);
        this.each((x, y) -> {
            Floor f = this.tiles.get(x, y).floor().asFloor();
            if (Math.abs(x % 100 + 1 - shift) < 2 || Math.abs(y % 100 + 1 - shift) < 2) {
                this.drawPoint(x, y, rad, block);
            }
        });
    }

    public boolean isOnLine(int x, int y, int s, int o) {
        int spacing = 102;
        int n1 = (spacing + s + o) % spacing;
        int n2 = (spacing + s - o) % spacing;
        return x % spacing == n1 || x % spacing == n2 || y % spacing == n1 || y % spacing == n2;
    }

    public void drawPoint(int cx, int cy, int rad, Block block) {
        this.drawPoint(cx, cy, rad, (Cons<Tile>)((Cons)tile -> {
            if (block == Blocks.air) {
                tile.setBlock(Blocks.air);
            } else if (block instanceof Floor) {
                tile.setFloor((Floor)block);
            } else {
                tile.setBlock(block);
            }
        }));
    }

    public void drawPoint(int cx, int cy, int rad, Cons<Tile> cons) {
        this.drawPoint(cx, cy, rad, (Boolf<Tile>)((Boolf)tile -> true), cons);
    }

    public void drawPoint(int cx, int cy, int rad, Boolf<Tile> bool, Cons<Tile> cons) {
        for (int x = -rad; x <= rad; ++x) {
            for (int y = -rad; y <= rad; ++y) {
                Tile tile;
                int wx = cx + x;
                int wy = cy + y;
                if (!Structs.inBounds((int)wx, (int)wy, (int)this.width, (int)this.height) || !bool.get((Object)(tile = this.tiles.get(wx, wy)))) continue;
                cons.get((Object)this.tiles.getn(wx, wy));
            }
        }
    }

    static {
        PlanetDialog.debugSelect = true;
        waterOffset = 0.81f;
    }
}

