/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.map;

import arc.struct.Seq;
import mindustry.Vars;
import mindustry.content.Blocks;
import mindustry.game.Schematic;
import mindustry.gen.Building;
import mindustry.world.Block;
import mindustry.world.Tile;

public class TerrainSchematic {
    public Seq<SData> tileData;
    public Seq<Schematic.Stile> floor;
    public Seq<Schematic.Stile> overlay;
    public Seq<Schematic.Stile> block;
    public int width;
    public int height;

    public TerrainSchematic(Seq<SData> tileData, Seq<Schematic.Stile> floor, Seq<Schematic.Stile> overlay, Seq<Schematic.Stile> block, int width, int height) {
        this.tileData = tileData;
        this.floor = floor;
        this.overlay = overlay;
        this.block = block;
        this.width = width;
        this.height = height;
    }

    public TerrainSchematic(int startX, int startY, int endX, int endY) {
        this.width = endX - startX + 1;
        this.height = endY - startY + 1;
        Seq buildTmp = new Seq();
        Seq tileDataTmp = new Seq();
        Seq floorTmp = new Seq();
        Seq overlayTmp = new Seq();
        Seq blockTmp = new Seq();
        for (int x = 0; x < this.width; ++x) {
            Tile tile;
            for (int y = 0; y < this.height && (tile = Vars.world.tile(x + startX, y + startY)) != null; ++y) {
                tileDataTmp.add((Object)new SData(tile.data, x, y));
                if (tile.floor() != Blocks.air) {
                    floorTmp.add((Object)new Schematic.Stile((Block)tile.floor(), x, y, null, 0));
                }
                if (tile.overlay() != Blocks.air) {
                    overlayTmp.add((Object)new Schematic.Stile((Block)tile.overlay(), x, y, null, 0));
                }
                if (!tile.block().isStatic() && tile.block() != Blocks.air) continue;
                blockTmp.add((Object)new Schematic.Stile(tile.block(), x, y, null, 0));
            }
        }
        for (Building building : buildTmp) {
            blockTmp.add((Object)new Schematic.Stile(building.block, building.tileX(), building.tileY(), building.config(), (byte)building.rotation));
        }
        this.tileData = tileDataTmp;
        this.floor = floorTmp;
        this.overlay = overlayTmp;
        this.block = blockTmp;
    }

    public String toString() {
        return "data size:" + this.tileData.size + "first: " + ((SData)this.tileData.firstOpt()).data + ", floor size =" + this.floor.size + "first: " + ((Schematic.Stile)this.floor.firstOpt()).block.name + ", curtain size =" + this.overlay.size + "first: " + ((Schematic.Stile)this.overlay.firstOpt()).block.name + ", block size =" + this.block.size + "first: " + ((Schematic.Stile)this.block.firstOpt()).block.name + ", width=" + this.width + ", height=" + this.height;
    }

    public static class SData {
        public short x;
        public short y;
        public byte data;

        public SData(byte data, int x, int y) {
            this.data = data;
            this.x = (short)x;
            this.y = (short)y;
        }

        public SData() {
            this.data = 0;
        }
    }
}

