/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.type;

import arc.Core;
import arc.func.Cons3;
import arc.struct.Seq;
import arc.util.Scaling;
import mindustry.ctype.ContentType;
import mindustry.ctype.UnlockableContent;
import mindustry.gen.Building;
import mindustry.ui.Styles;
import mindustry.world.Block;
import newhorizon.content.NHStats;
import newhorizon.expand.type.DeviceData;

public class Device
extends UnlockableContent {
    public Seq<Block> installableBlocks = new Seq();
    public Seq<Block> compatibleBlocks = new Seq();
    public Cons3<Building, DeviceData, Float> modifier = (source, target, intensity) -> {};

    public Device(String name) {
        super(name);
        this.localizedName = Core.bundle.get("device." + name + ".name");
        this.description = Core.bundle.get("device." + name + ".description");
        this.details = Core.bundle.getOrNull("device." + name + ".details");
        this.alwaysUnlocked = true;
    }

    public ContentType getContentType() {
        return ContentType.loadout_UNUSED;
    }

    public void load() {
        super.load();
        this.fullIcon = this.uiIcon = Core.atlas.find(this.name);
    }

    public void setStats() {
        super.setStats();
        this.stats.add(NHStats.installableBlocks, table -> {
            table.row();
            table.table(c -> {
                for (Block block : this.installableBlocks) {
                    c.table(Styles.grayPanel, b -> {
                        b.image(block.uiIcon).size(40.0f).pad(10.0f).left().scaling(Scaling.fit);
                        b.table(info -> info.add((CharSequence)block.localizedName).right()).right().grow().pad(10.0f).padRight(15.0f);
                    }).growX().pad(5.0f).row();
                }
            }).growX().colspan(table.getColumns());
            table.row();
        });
        this.stats.add(NHStats.compatibleBlocks, table -> {
            table.row();
            table.table(c -> {
                for (Block block : this.compatibleBlocks) {
                    c.table(Styles.grayPanel, b -> {
                        b.image(block.uiIcon).size(40.0f).pad(10.0f).left().scaling(Scaling.fit);
                        b.table(info -> info.add((CharSequence)block.localizedName).right()).right().grow().pad(10.0f).padRight(15.0f);
                    }).growX().pad(5.0f).row();
                }
            }).growX().colspan(table.getColumns());
            table.row();
        });
    }

    public void applyBuilding(Building source, DeviceData target, float intensity) {
        if (this.installableBlocks.contains((Object)source.block) && this.compatibleBlocks.contains((Object)target.building.block)) {
            this.modifier.get((Object)source, (Object)target, (Object)Float.valueOf(intensity));
        }
    }
}

