/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.units;

import arc.graphics.Blending;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.type.UnitType;

public class AncientEngine
extends UnitType.UnitEngine {
    public Color engineColor;
    public float forceZ = -1.0f;
    public float phaseOffset = Mathf.random((int)5);
    public float alphaBase = 0.8f;
    public float scl = 0.825f;
    public float sizeSclPlus = 0.4f;
    public float sizeSclMin = 0.95f;
    public float alphaSclMin = 0.88f;

    public AncientEngine(float x, float y, float radius, float rotation) {
        super(x, y, radius, rotation);
    }

    public AncientEngine(float x, float y, float radius, float rotation, float phaseOffset) {
        this(x, y, radius, rotation);
        this.phaseOffset = phaseOffset;
    }

    public AncientEngine(float x, float y, float radius, float rotation, float alphaBase, float sizeSclPlus, float sizeSclMin) {
        this(x, y, radius, rotation);
        this.alphaBase = alphaBase;
        this.sizeSclPlus = sizeSclPlus;
        this.sizeSclMin = sizeSclMin;
    }

    public AncientEngine a(float f) {
        this.alphaBase = f;
        return this;
    }

    public void draw(Unit unit) {
        UnitType type = unit.type;
        if (unit.vel.len2() > 0.001f) {
            float z = Draw.z();
            if (this.forceZ > 0.0f) {
                Draw.z((float)this.forceZ);
            }
            float rot = unit.rotation - 90.0f;
            Color c = type.engineColor == null ? unit.team.color : type.engineColor;
            Tmp.v1.set(this.x, this.y).rotate(rot).add(unit.x, unit.y);
            float ex = Tmp.v1.x;
            float ey = Tmp.v1.y;
            float rad = Mathf.curve((float)unit.vel.len2(), (float)0.001f, (float)(type.speed * type.speed)) * this.radius * (this.sizeSclMin + Mathf.absin((float)(Time.time + this.phaseOffset), (float)this.scl, (float)this.sizeSclPlus));
            float a = this.alphaBase * (this.alphaSclMin + Mathf.absin((float)(Time.time * 1.3f - this.phaseOffset), (float)this.scl, (float)0.13f));
            Draw.blend((Blending)Blending.additive);
            Draw.alpha((float)a);
            Tmp.c2.set(c).a(a);
            Fill.light((float)ex, (float)ey, (int)Lines.circleVertices((float)rad), (float)rad, (Color)Tmp.c2, (Color)Color.clear);
            Tmp.c1.set(Tmp.c2).lerp(Color.white, Mathf.absin((float)(Time.time * 1.1f + this.phaseOffset), (float)(this.scl * 1.12512f), (float)0.14f));
            Draw.color((Color)Tmp.c1);
            Draw.alpha((float)(a * 0.5f));
            Fill.light((float)ex, (float)ey, (int)Lines.circleVertices((float)rad), (float)(rad * 1.125f), (Color)Tmp.c1, (Color)Color.clear);
            Drawf.light((float)ex, (float)ey, (float)(rad * 1.9f), (Color)Tmp.c1, (float)a);
            Draw.reset();
            Draw.blend();
            Draw.z((float)z);
        }
    }
}

