/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.units;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.struct.Queue;
import arc.struct.Seq;
import arc.util.Interval;
import java.util.Iterator;
import mindustry.Vars;
import mindustry.entities.abilities.Ability;
import mindustry.gen.Unit;
import mindustry.graphics.Trail;
import mindustry.type.UnitType;
import newhorizon.util.func.PositionOffset;

public class BoostAbility
extends Ability {
    public static final int maxSize = 8;
    public boolean drawAirFlow = true;
    public float angleMaxDst = 90.0f;
    public float velocityMultiple = 3.0f;
    public float warmupTime = 120.0f;
    public int trailLength = 8;
    public float angleCone = 5.0f;
    protected Seq<Trail> trails;
    protected Queue<Float> seq = new Queue(9);
    protected Interval timer = new Interval();

    public BoostAbility(boolean drawAirFlow, float velocityMultiple, float angleCone) {
        this.drawAirFlow = drawAirFlow;
        this.velocityMultiple = velocityMultiple;
        this.angleCone = angleCone;
    }

    public BoostAbility() {
        this(3.0f);
    }

    public BoostAbility(float velocityMultiple, float angleCone) {
        this.velocityMultiple = velocityMultiple;
        this.angleCone = angleCone;
    }

    public BoostAbility(float velocityMultiple) {
        this.velocityMultiple = velocityMultiple;
    }

    public void init(UnitType type) {
        this.trails = new Seq(type.engines.size);
        float size = type.engineSize;
        for (UnitType.UnitEngine e : type.engines) {
            int f = (int)(Mathf.clamp((float)(e.radius / size)) * (float)this.trailLength);
            this.trails.add((Object)new Trail(f));
        }
    }

    public BoostAbility copy() {
        BoostAbility out = (BoostAbility)super.copy();
        out.trails = new Seq(this.trails.size);
        for (Trail trail : this.trails) {
            out.trails.add((Object)new Trail(trail.length));
        }
        out.seq = new Queue(9);
        out.timer = new Interval();
        return out;
    }

    public float warmup(float angle) {
        float f = 0.0f;
        Iterator iterator = this.seq.iterator();
        while (iterator.hasNext()) {
            float i = ((Float)iterator.next()).floatValue();
            if (!Angles.within((float)angle, (float)i, (float)this.angleCone)) continue;
            f += 1.0f;
        }
        return f / (float)this.seq.size;
    }

    public boolean allSame(float angle, float lookAng) {
        if (this.seq.size < 7 || !Angles.within((float)angle, (float)lookAng, (float)this.angleMaxDst)) {
            return false;
        }
        Iterator iterator = this.seq.iterator();
        while (iterator.hasNext()) {
            float f = ((Float)iterator.next()).floatValue();
            if (Angles.within((float)angle, (float)f, (float)this.angleCone)) continue;
            return false;
        }
        return true;
    }

    public void update(Unit unit) {
        float angle = unit.vel.angle();
        float speed = unit.vel.len();
        boolean same = this.allSame(angle, unit.rotation());
        if (speed < 0.01f && !this.seq.isEmpty()) {
            this.seq.removeFirst();
        }
        if (same) {
            unit.speedMultiplier(unit.speedMultiplier() * this.velocityMultiple);
        }
        if (this.seq.size > 8) {
            this.seq.removeFirst();
        }
        if (this.timer.get(12.0f) && speed > 0.1f) {
            this.seq.add((Object)Float.valueOf(angle));
        }
        if (Vars.headless) {
            return;
        }
        for (int i = 0; i < this.trails.size; ++i) {
            Trail trail = (Trail)this.trails.get(i);
            if (i >= unit.type.engines.size) continue;
            UnitType.UnitEngine engine = (UnitType.UnitEngine)unit.type.engines.get(i);
            Vec2 vec2 = PositionOffset.unitEngineOffset(unit, engine);
            trail.update(unit.x + vec2.x, unit.y + vec2.y, same ? 1.0f : 0.0f);
        }
    }

    public void draw(Unit unit) {
        float z = Draw.z();
        Draw.z((float)(unit.type.engineLayer > 0.0f ? unit.type.engineLayer : (unit.type.lowAltitude ? 89.999f : 114.999f)));
        Color color = unit.type.engineColor == null ? unit.team.color : unit.type.engineColor;
        for (int i = 0; i < this.trails.size; ++i) {
            if (i >= unit.type.engines.size) continue;
            ((Trail)this.trails.get(i)).draw(color, ((UnitType.UnitEngine)unit.type.engines.get((int)i)).radius / 1.25f);
        }
        Draw.z((float)z);
    }
}

