/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.units;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import arc.util.Interval;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.Lightning;
import mindustry.entities.Units;
import mindustry.game.Team;
import mindustry.gen.Groups;
import mindustry.gen.PayloadUnit;
import mindustry.gen.Sounds;
import mindustry.gen.Unit;
import mindustry.graphics.Trail;
import mindustry.type.UnitType;
import newhorizon.NHGroups;
import newhorizon.NHSetting;
import newhorizon.content.NHFx;
import newhorizon.content.NHStatusEffects;
import newhorizon.expand.entities.EntityRegister;
import newhorizon.util.func.NHFunc;

public class EnergyUnit
extends PayloadUnit {
    public static final float effectTriggerLen = 40.0f;
    public static Effect teleport = new Effect(90.0f, 150.0f, e -> {
        Draw.color((Color)e.color, (Color)Color.white, (float)(e.fin() * 0.7f));
        Fill.circle((float)e.x, (float)e.y, (float)(e.fout() * e.rotation * 1.25f));
        Lines.stroke((float)(e.fout() * 3.2f));
        Lines.circle((float)e.x, (float)e.y, (float)(e.fin() * e.rotation * 1.75f));
        Lines.stroke((float)(e.fout() * 2.5f));
        Lines.circle((float)e.x, (float)e.y, (float)(e.fin() * e.rotation * 1.5f));
        Lines.stroke((float)(e.fout() * 3.2f));
        Angles.randLenVectors((long)e.id, (int)((int)e.rotation * 2), (float)(e.rotation / 1.5f + e.rotation * e.fin() * 2.75f), (x, y) -> Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Mathf.angle((float)x, (float)y), (float)(e.fslope() * 14.0f + 5.0f)));
        Fx.rand.setSeed((long)(e.id + 100));
        Angles.randLenVectors((long)(e.id + 100), (int)((int)e.rotation), (float)(e.rotation / 2.0f + e.rotation * e.fin() * 3.0f), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(Fx.rand.random(e.rotation, e.rotation * 2.0f) * e.foutpow())));
        Draw.color((Color)Color.black);
        Fill.circle((float)e.x, (float)e.y, (float)(e.fout() * e.rotation * 0.7f));
    });
    public static Effect teleportTrans = new Effect(45.0f, 600.0f, e -> {
        if (!(e.data instanceof Vec2)) {
            return;
        }
        Vec2 data = (Vec2)e.data();
        float angle = Angles.angle((float)e.x, (float)e.y, (float)data.x, (float)data.y);
        float dst = Mathf.dst((float)e.x, (float)e.y, (float)data.x, (float)data.y);
        Rand rand = new Rand((long)e.id);
        Tmp.v1.set(data).sub(e.x, e.y).nor().scl(24.0f);
        Lines.stroke((float)(Mathf.curve((float)e.fout(), (float)0.0f, (float)0.3f) * 1.75f));
        Draw.color((Color)e.color, (Color)Color.white, (float)(e.fout() * 0.75f));
        int i = 1;
        while ((float)i < dst / 8.0f / 3.0f) {
            for (int j = 0; j < (int)e.rotation / 3; ++j) {
                Tmp.v4.trns(angle, rand.random(e.rotation / 4.0f, e.rotation / 2.0f), rand.range(e.rotation));
                Tmp.v3.set(Tmp.v2.set(Tmp.v1)).scl((float)i).add(Tmp.v2.scl(rand.range(0.5f))).add(Tmp.v4).add(e.x, e.y);
                Lines.lineAngle((float)Tmp.v3.x, (float)Tmp.v3.y, (float)(angle - 180.0f), (float)(e.fout((Interp)Interp.pow2Out) * 18.0f + 8.0f));
            }
            ++i;
        }
    });
    public float reload = 240.0f;
    public float teleportMinRange = 180.0f;
    public float teleportRange = 400.0f;
    protected transient Vec2 lastPos = new Vec2();
    protected float reloadValue = 0.0f;
    protected float lastHealth = 0.0f;
    protected Interval timer = new Interval(5);
    protected Trail[] trails = new Trail[0];

    public int classId() {
        return EntityRegister.getID(((Object)((Object)this)).getClass());
    }

    public void destroy() {
        super.destroy();
        for (int i = 0; i < this.trails.length; ++i) {
            Tmp.c1.set(this.team.color).mul((float)i * 0.045f).lerp(Color.white, 0.075f * (float)i);
            Fx.trailFade.at(this.x, this.y, this.type.trailScl, this.team.color, (Object)this.trails[i].copy());
        }
        NHFx.energyUnitBlast.at(this.x, this.y, this.hitSize * 4.0f, this.team.color);
        Vec2 v = new Vec2().set((Position)this);
        int i = 0;
        while ((float)i < NHFx.energyUnitBlast.lifetime / 6.0f) {
            Time.run((float)(i * 6), () -> {
                for (int j = 0; j < 3; ++j) {
                    Lightning.create((Team)this.team, (Color)this.team.color, (float)120.0f, (float)v.x, (float)v.y, (float)Mathf.random((int)360), (int)Mathf.random((int)12, (int)28));
                    NHFunc.randFadeLightningEffect(v.x, v.y, Mathf.random((int)360), Mathf.random((int)12, (int)28), this.team.color, Mathf.chance((double)0.5));
                }
            });
            ++i;
        }
    }

    public void setType(UnitType type) {
        super.setType(type);
        if (this.trails.length != 3) {
            this.trails = new Trail[3];
            for (int i = 0; i < this.trails.length; ++i) {
                this.trails[i] = new Trail(type.trailLength);
            }
        }
    }

    public void add() {
        super.add();
        this.lastPos.set((Position)this);
    }

    public void draw() {
        Draw.z((float)100.0f);
        if (NHSetting.enableDetails()) {
            for (int i = 0; i < this.trails.length; ++i) {
                Tmp.c1.set(this.team.color).mul(1.0f + (float)i * 0.005f).lerp(Color.white, 0.015f * (float)i + Mathf.absin((float)4.0f, (float)0.3f) + Mathf.clamp((float)this.hitTime) / 5.0f);
                this.trails[i].drawCap(Tmp.c1, this.type.trailScl);
                this.trails[i].draw(Tmp.c1, this.type.trailScl);
            }
        }
        super.draw();
    }

    protected void updateTeleport() {
        if (!this.hasEffect(NHStatusEffects.intercepted) && !this.isPlayer()) {
            this.reloadValue += Time.delta;
            Unit target = Units.closestEnemy((Team)this.team, (float)this.x, (float)this.y, (float)(this.teleportRange * 2.0f), b -> true);
            int[] num = new int[]{0};
            float[] damage = new float[]{0.0f};
            this.reloadValue += Math.max(this.lastHealth - this.health, 0.0f) / 2.0f;
            this.lastHealth = this.health;
            if (this.timer.get(5.0f)) {
                Groups.bullet.intersect(this.x - this.teleportRange, this.y - this.teleportRange, this.teleportRange * 2.0f, this.teleportRange * 2.0f, bullet -> {
                    if (bullet.team == this.team) {
                        return;
                    }
                    num[0] = num[0] + 1;
                    damage[0] = damage[0] + bullet.damage();
                });
            }
            if (this.teleportValid() && (target != null || this.hitTime > 0.0f || num[0] > 4 || damage[0] > this.reload / 2.0f) && (!this.isLocal() || Vars.mobile)) {
                float dst = target == null ? this.teleportRange + this.teleportMinRange : this.dst((Position)target) / 2.0f;
                float angle = target == null ? this.rotation : this.angleTo((Position)target);
                Tmp.v2.trns(angle + (float)(Mathf.range((int)1) * 45), dst * (float)Mathf.random((int)1, (int)2), Mathf.range((float)0.2f) * dst).clamp(this.teleportMinRange, this.teleportRange).add((Position)this).clamp(-250.0f, -250.0f, (float)Vars.world.unitHeight() + 250.0f, (float)Vars.world.unitWidth() + 250.0f);
                this.teleport(Tmp.v2.x, Tmp.v2.y);
            }
        }
    }

    public boolean teleportValid() {
        return this.reloadValue > this.reload;
    }

    public void teleport(float x, float y) {
        NHFunc.teleportUnitNet((Unit)this, x, y, this.angleTo(x, y), this.isPlayer() ? this.getPlayer() : null);
        this.reloadValue = 0.0f;
    }

    public void update() {
        super.update();
        Seq fields = new Seq();
        NHGroups.gravityTraps.intersect(this.x - this.hitSize / 4.0f, this.y - this.hitSize / 4.0f, this.hitSize / 2.0f, this.hitSize / 2.0f, fields);
        if (this.timer.get(1, 8.0f)) {
            fields.each(f -> f.owner != this.team, f -> {
                Vec2 target = new Vec2(this.x, this.y);
                NHFx.slidePoly.at(f.x, f.y, this.hitSize, f.owner.color, (Object)target);
                NHFx.chainLightningFade.at(f.x, f.y, 12.0f, f.owner.color, (Object)target);
                this.impulseNet(Tmp.v1.set((Position)this).sub((Position)f).nor().scl(50.0f * (f.range * 0.75f - f.dst((Position)this))));
                this.damage(35.0f, true);
                this.apply(NHStatusEffects.intercepted, 60.0f);
            });
        }
        if (!Vars.headless && this.lastPos.dst((Position)this) > 40.0f) {
            Sounds.shootBeamPlasma.at((Position)this);
            Sounds.shootBeamPlasma.at((Position)this.lastPos);
            teleport.at(this.x, this.y, this.hitSize / 2.0f, this.team.color);
            teleport.at(this.lastPos.x, this.lastPos.y, this.hitSize / 2.0f, this.team.color);
            teleportTrans.at(this.lastPos.x, this.lastPos.y, this.hitSize / 2.0f, this.team.color, (Object)new Vec2().set((Position)this));
            for (Trail t : this.trails) {
                Fx.trailFade.at(this.lastPos.x, this.lastPos.y, this.type.trailScl, this.team.color, (Object)t.copy());
                t.clear();
            }
        }
        this.lastPos.set((Position)this);
        Rand rand = NHFunc.rand;
        rand.setSeed((long)this.id);
        if (NHSetting.enableDetails() && !Vars.headless) {
            for (int i = 0; i < this.trails.length; ++i) {
                Trail trail = this.trails[i];
                float scl = rand.random(0.75f, 1.5f) * (float)Mathf.sign((float)rand.range(1)) * (float)(i + 1) / 1.25f;
                float s = rand.random(0.75f, 1.25f);
                Tmp.v1.trns(Time.time * scl * rand.random(0.5f, 1.5f) + (float)i * 360.0f / (float)this.trails.length + (float)rand.random(360), this.hitSize * (1.1f + 0.5f * (float)i) * 0.75f).add((Position)this).add(Mathf.sinDeg((float)(Time.time * scl * rand.random(0.75f, 1.25f) * s)) * this.hitSize / 3.0f * ((float)i * 0.125f + 1.0f) * rand.random(-1.5f, 1.5f), Mathf.cosDeg((float)(Time.time * scl * rand.random(0.75f, 1.25f) * s)) * this.hitSize / 3.0f * ((float)i * 0.125f + 1.0f) * rand.random(-1.5f, 1.5f));
                trail.update(Tmp.v1.x, Tmp.v1.y, 1.0f + Mathf.absin((float)4.0f, (float)0.2f));
            }
        }
        if (Mathf.chanceDelta((double)0.15) && this.healthf() < 0.6f) {
            NHFunc.randFadeLightningEffect(this.x, this.y, Mathf.range((float)this.hitSize, (float)(this.hitSize * 4.0f)), Mathf.range((float)(this.hitSize / 4.0f), (float)(this.hitSize / 2.0f)), this.team.color, Mathf.chance((double)0.5));
        }
        if (!Vars.net.client() || this.isLocal()) {
            this.updateTeleport();
        }
    }

    public void damage(float amount, boolean withEffect) {
        super.damage(amount, withEffect);
    }
}

