/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.units;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.struct.Seq;
import arc.util.Tmp;
import mindustry.entities.UnitSorts;
import mindustry.entities.Units;
import mindustry.entities.units.StatusEntry;
import mindustry.game.Team;
import mindustry.gen.Physicsc;
import mindustry.gen.Unit;
import mindustry.gen.UnitEntity;
import mindustry.gen.Unitc;
import newhorizon.content.NHFx;

public class EnergyUnitII
extends UnitEntity {
    protected Seq<Clamper> clamps = new Seq(12);

    public void add() {
        super.add();
        for (int i = 0; i < 12; ++i) {
            this.clamps.add((Object)new Clamper());
        }
    }

    public void draw() {
        for (StatusEntry e : this.statuses) {
            e.effect.draw((Unit)this, e.time);
        }
        Draw.color((Color)Color.black);
        Draw.z((float)99.0f);
        Fill.circle((float)this.x, (float)this.y, (float)this.hitSize);
        Draw.z((float)105.0f);
        Fill.circle((float)this.x, (float)this.y, (float)this.hitSize);
        Lines.stroke((float)12.0f, (Color)this.team.color);
        Lines.circle((float)this.x, (float)this.y, (float)this.hitSize);
        Lines.stroke((float)3.0f, (Color)this.team.color);
        this.clamps.each(Clamper::draw);
    }

    public void update() {
        super.update();
        this.clamps.each(c -> {
            c.target = Units.bestEnemy((Team)this.team, (float)this.x, (float)this.y, (float)800.0f, Unitc::isFlying, (Units.Sortf)UnitSorts.strongest);
            c.update();
        });
    }

    public class Clamper {
        public Physicsc target;
        public float Cx;
        public float Cy;
        public float strength;

        public void draw() {
            Tmp.v1.set(this.Cx, this.Cy).sub(EnergyUnitII.this.x, EnergyUnitII.this.y).scl(0.33f);
            float ang = Tmp.v1.angle();
            float len = Mathf.dst((float)this.Cx, (float)this.Cy, (float)EnergyUnitII.this.x, (float)EnergyUnitII.this.y);
            Tmp.v2.trns(ang + 90.0f, this.strength * len / 4.0f).add(Tmp.v1);
            Tmp.v3.trns(ang + 90.0f, this.strength * len / 8.0f).add(Tmp.v1.scl(2.0f));
            Lines.curve((float)EnergyUnitII.this.x, (float)EnergyUnitII.this.y, (float)Tmp.v2.x, (float)Tmp.v2.y, (float)Tmp.v3.x, (float)Tmp.v3.y, (float)this.Cx, (float)this.Cy, (int)((int)(len / 10.0f)));
        }

        public void update() {
            if (Mathf.chance((double)0.1)) {
                NHFx.hitSpark.at(this.Cx, this.Cy, EnergyUnitII.this.team.color);
            }
            if (this.target != null) {
                this.Cx = this.target.getX();
                this.Cy = this.target.getY();
                Tmp.v1.set(this.Cx, this.Cy).sub(EnergyUnitII.this.x, EnergyUnitII.this.y).setLength(this.strength);
                this.target.impulse(Tmp.v1);
            } else {
                this.Cx = Mathf.lerpDelta((float)this.Cx, (float)EnergyUnitII.this.x, (float)0.0075f);
                this.Cy = Mathf.lerpDelta((float)this.Cy, (float)EnergyUnitII.this.x, (float)0.0075f);
            }
        }
    }
}

