/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.units.ablility;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.abilities.Ability;
import mindustry.gen.Building;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import newhorizon.util.func.NHFunc;
import newhorizon.util.graphic.DrawFunc;

public class HealFieldAbility
extends Ability {
    public static final float scanTime = 120.0f;
    public static final Interp scanInterp = Interp.pow5;
    protected static Effect scan = new Effect(120.0f, 2000.0f, e -> {
        Rand rand = NHFunc.rand;
        rand.setSeed((long)e.id);
        Draw.color((Color)e.color);
        float f = Interp.pow4Out.apply(Mathf.curve((float)e.fin(), (float)0.0f, (float)0.3f));
        float stroke = Mathf.clamp((float)(e.rotation / 80.0f), (float)3.0f, (float)8.0f);
        Lines.stroke((float)(2.0f * e.fout()));
        Lines.circle((float)e.x, (float)e.y, (float)(e.rotation * f / 8.0f));
        Lines.stroke((float)(stroke * e.fout() + 1.0f * e.fout((Interp)Interp.pow5In)));
        Lines.circle((float)e.x, (float)e.y, (float)(e.rotation * f));
        Lines.stroke((float)(stroke * Mathf.curve((float)e.fin(), (float)0.0f, (float)0.1f) * Mathf.curve((float)e.fout(), (float)0.05f, (float)0.15f)));
        float angle = 360.0f * e.fin(scanInterp);
        Lines.lineAngle((float)e.x, (float)e.y, (float)angle, (float)(e.rotation * f - Lines.getStroke() / 2.0f));
        Lines.stroke((float)(stroke * Mathf.curve((float)e.fin(), (float)0.0f, (float)0.1f) * e.fout(0.05f)));
        Draw.z((float)99.0f);
        DrawFunc.fillCirclePercentFade(e.x, e.y, e.x, e.y, e.rotation * f, e.fin(scanInterp), 0.0f, Mathf.curve((float)e.fout(), (float)0.2f, (float)0.25f) / 1.5f, 0.6f + 0.35f * Interp.pow2InInverse.apply(Mathf.curve((float)e.fin(), (float)0.0f, (float)0.8f)), 1.0f);
        Draw.z((float)110.0f);
        Angles.randLenVectors((long)e.id, (int)((int)(e.rotation / 40.0f)), (float)(e.rotation * 0.85f * f), (float)angle, (float)0.0f, (x, y) -> Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)angle, (float)(e.rotation * rand.random(0.05f, 0.15f) * e.fout(0.15f))));
        Draw.color((Color)e.color);
        Lines.stroke((float)(stroke * 1.25f * e.fout(0.2f)));
        Fill.circle((float)e.x, (float)e.y, (float)Lines.getStroke());
        Draw.color((Color)Color.white, (Color)e.color, (float)e.fin());
        Fill.circle((float)e.x, (float)e.y, (float)(Lines.getStroke() / 2.0f));
        Drawf.light((float)e.x, (float)e.y, (float)(e.rotation * f * 1.35f * e.fout(0.15f)), (Color)e.color, (float)0.6f);
    });
    protected static Effect targeted = new Effect(45.0f, e -> {
        Draw.color((Color)e.color);
        Lines.stroke((float)(4.0f * Mathf.curve((float)e.fin(), (float)0.0f, (float)0.1f) * e.fout()));
        Lines.square((float)e.x, (float)e.y, (float)(e.rotation * e.fout()), (float)(315.0f * e.fout((Interp)Interp.pow3In)));
    }).followParent(true);
    public Color scanColor = Pal.heal;
    public float reloadTime = 60.0f;
    public float spawnX;
    public float spawnY;
    public float range = 800.0f;
    public float healMount = 0.15f;
    public float layer = 99.999f;
    public float blinkScl = 20.0f;
    public float effectRadius = 6.0f;
    public float sectorRad = 0.08f;
    public float rotateSpeed = 0.5f;
    public int sectors = 5;
    protected float reload;
    protected float curStroke;

    public HealFieldAbility(Color scanColor, float reloadTime, float spawnX, float spawnY, float range, float healMount) {
        this.scanColor = scanColor;
        this.reloadTime = reloadTime;
        this.spawnX = spawnX;
        this.spawnY = spawnY;
        this.range = range;
        this.healMount = healMount;
    }

    public HealFieldAbility(Color scanColor, float spawnTime, float range) {
        this.scanColor = scanColor;
        this.reloadTime = spawnTime;
        this.range = range;
    }

    public HealFieldAbility(Color scanColor, float spawnTime, float spawnX, float spawnY, float range) {
        this.scanColor = scanColor;
        this.reloadTime = spawnTime;
        this.spawnX = spawnX;
        this.spawnY = spawnY;
        this.range = range;
    }

    public void update(Unit unit) {
        this.reload += Time.delta;
        this.curStroke = this.reload / this.reloadTime > 0.15f ? Mathf.lerp((float)this.curStroke, (float)1.0f, (float)0.0075f) : Mathf.lerp((float)this.curStroke, (float)0.0f, (float)0.01f);
        if (this.reload >= this.reloadTime) {
            this.reload = this.reloadTime;
            NHFunc.extinguish((Teamc)unit, this.range, 1.7014117E38f);
            Tmp.v1.trns(unit.rotation, this.spawnY, this.spawnX).add((Position)unit);
            Seq toHeal = new Seq();
            Vars.indexer.eachBlock(unit.team, Tmp.v1.x, Tmp.v1.y, this.range, b -> b.damaged() && b.within((Position)Tmp.v1, this.range), arg_0 -> ((Seq)toHeal).add(arg_0));
            if (toHeal.isEmpty()) {
                return;
            }
            this.reload = 0.0f;
            scan.at(Tmp.v1.x, Tmp.v1.y, this.range, this.scanColor);
            Seq bs = toHeal.sort(arg_0 -> ((Vec2)Tmp.v1).angleTo(arg_0)).copy();
            Time.run((float)130.0f, () -> {
                for (int i = 0; i < bs.size; ++i) {
                    Building b = (Building)bs.get(i);
                    Time.run((float)((float)i * 90.0f / (float)bs.size), () -> {
                        if (!b.isValid()) {
                            return;
                        }
                        Fx.healBlockFull.at(b.x, b.y, (float)b.block.size, this.scanColor, (Object)b.block);
                        b.healFract(this.healMount);
                    });
                }
            });
        }
    }

    public void draw(Unit unit) {
        Tmp.v1.trns(unit.rotation, this.spawnY, this.spawnX).add((Position)unit);
        Draw.z((float)110.0f);
        Draw.color((Color)this.scanColor);
        float rx = Tmp.v1.x;
        float ry = Tmp.v1.y;
        float orbRadius = this.effectRadius * this.reload / this.reloadTime;
        Fill.circle((float)rx, (float)ry, (float)(orbRadius * 0.9f));
        Draw.color();
        Fill.circle((float)rx, (float)ry, (float)(orbRadius / 2.0f * 0.9f));
        Lines.stroke((float)(Mathf.clamp((float)(orbRadius / 4.0f), (float)2.0f, (float)4.0f) * (Mathf.absin((float)this.blinkScl, (float)0.15f) + 1.0f)), (Color)this.scanColor);
        Lines.square((float)rx, (float)ry, (float)(orbRadius * 1.8f), (float)(Time.time * 1.5f));
        Lines.square((float)rx, (float)ry, (float)(orbRadius * 2.4f), (float)(-Time.time));
        Lines.spikes((float)rx, (float)ry, (float)(orbRadius * 2.6f), (float)orbRadius, (int)4, (float)(Time.time * 1.25f));
        Lines.stroke((float)(Mathf.clamp((float)(this.range / 80.0f), (float)3.0f, (float)8.0f) * this.curStroke * this.reload / this.reloadTime / 2.0f));
        if (this.curStroke > 0.0f) {
            for (int i = 0; i < this.sectors; ++i) {
                float rot = unit.rotation + (float)i * 360.0f / (float)this.sectors + Time.time * this.rotateSpeed;
                Lines.arc((float)rx, (float)ry, (float)(this.range * this.reload / this.reloadTime), (float)this.sectorRad, (float)rot);
            }
        }
        Drawf.light((float)rx, (float)ry, (float)(this.range * 1.5f), (Color)this.scanColor, (float)(this.curStroke * 0.8f));
        Draw.reset();
    }

    public String localized() {
        return Core.bundle.get("ability.healfield");
    }
}

