/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.units.ai;

import arc.math.geom.Position;
import arc.util.Time;
import mindustry.Vars;
import mindustry.entities.Units;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Posc;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.world.blocks.storage.CoreBlock;
import newhorizon.expand.units.ai.SniperAI;
import newhorizon.expand.units.unitEntity.ProbeEntity;

public class ProbeAI
extends SniperAI {
    public float nullReload = 0.0f;
    public ProbeEntity probe;

    public boolean checkTarget(Teamc target, float x, float y, float range) {
        return !(target instanceof Building) || this.probe.scanned.contains((Object)((Building)target)) || this.probe.targetTeam != target.team() || Units.invalidateTarget((Posc)target, (Team)this.unit.team, (float)x, (float)y, (float)range);
    }

    public void unit(Unit unit) {
        super.unit(unit);
        if (!(unit instanceof ProbeEntity)) {
            return;
        }
        this.probe = (ProbeEntity)unit;
    }

    public void updateUnit() {
        if (this.probe == null) {
            return;
        }
        if (this.probe.scanTarget != null) {
            this.target = this.probe.scanTarget;
            if (!this.probe.scanTarget.isValid()) {
                this.target = null;
            }
        }
        super.updateUnit();
        if (this.target == null) {
            this.nullReload += Time.delta;
            if (this.nullReload > 90.0f) {
                CoreBlock.CoreBuild target = null;
                if (this.unit.team.cores().any()) {
                    target = this.unit.team.core();
                } else if (this.unit.team == Vars.state.rules.waveTeam && Vars.spawner.getSpawns().any()) {
                    target = Vars.spawner.getFirstSpawn();
                } else {
                    return;
                }
                this.moveTo((Position)target, this.unit.type.maxRange / 2.0f);
            }
        }
    }

    public Teamc findTarget(float x, float y, float range, boolean air, boolean ground) {
        Teamc result = this.findMainTarget(x, y, range, air, ground);
        return this.checkTarget(result, x, y, range) ? this.target(x, y, range, air, ground) : result;
    }

    public void updateTargeting() {
        super.updateTargeting();
    }

    public boolean retarget() {
        return super.retarget() && !this.probe.scanning;
    }

    public Teamc target(float x, float y, float range, boolean air, boolean ground) {
        Building target = Vars.indexer.findTile(this.probe.targetTeam, x, y, range, u -> u.block.priority >= 0.0f && !this.probe.scanned.contains(u));
        if (target != null && this.probe.scanned.contains((Object)target)) {
            target = null;
        }
        if (target == null) {
            if (this.probe.targetTeam.cores().any()) {
                return this.probe.targetTeam.core();
            }
            return null;
        }
        return target;
    }
}

