/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.units.ai;

import arc.math.Angles;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import mindustry.Vars;
import mindustry.ai.types.FlyingAI;
import newhorizon.util.func.NHMath;

public class SurroundAI
extends FlyingAI {
    public static final Vec2 tmp = new Vec2();
    public boolean inbound = false;

    public void updateWeapons() {
        super.updateWeapons();
    }

    public void updateMovement() {
        this.unloadPayloads();
        if (this.target != null && this.unit.hasWeapons()) {
            float ang;
            float dst = this.unit.dst((Position)this.target);
            if (dst > this.unit.type.range * 0.975f) {
                ang = this.unit.angleTo((Position)this.target) + NHMath.asinDeg(this.unit.type.range * 0.95f / dst);
                this.inbound = false;
            } else if (dst > this.unit.type.range * 0.725f) {
                if (!this.inbound) {
                    ang = this.angleVertical();
                } else {
                    ang = this.unit.rotation;
                    if (dst > this.unit.type.range * 0.925f) {
                        this.inbound = false;
                    }
                }
            } else if (dst > this.unit.type.range * 0.35f || Angles.within((float)(this.unit.rotation - 180.0f), (float)this.unit.angleTo((Position)this.target), (float)15.0f)) {
                ang = this.unit.rotation;
                this.inbound = true;
            } else {
                ang = this.angleDelta(115.0f);
                this.inbound = true;
            }
            this.unit.lookAt(ang);
            this.unit.moveAt(tmp.trns(ang, this.unit.speed()));
        }
        if (this.target == null && Vars.state.rules.waves && this.unit.team == Vars.state.rules.defaultTeam) {
            this.moveTo((Position)this.getClosestSpawner(), Vars.state.rules.dropZoneRadius + 130.0f);
        }
    }

    public float angleDelta(float ang) {
        return this.unit.angleTo((Position)this.target) + ang;
    }

    public float angleVertical() {
        return this.angleDelta(90.0f);
    }
}

