/*
 * Decompiled with CFR 0.152.
 */
package newhorizon.expand.units.unitEntity;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.struct.ObjectFloatMap;
import arc.struct.ObjectIntMap;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.io.Reads;
import arc.util.io.Writes;
import java.nio.FloatBuffer;
import mindustry.Vars;
import mindustry.ai.types.MissileAI;
import mindustry.content.Fx;
import mindustry.core.World;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.Lightning;
import mindustry.entities.Sized;
import mindustry.entities.Units;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.gen.Groups;
import mindustry.gen.Healthc;
import mindustry.gen.Hitboxc;
import mindustry.gen.Player;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.gen.UnitEntity;
import mindustry.graphics.Trail;
import mindustry.type.UnitType;
import mindustry.world.meta.BlockGroup;
import newhorizon.NHSetting;
import newhorizon.content.NHBullets;
import newhorizon.content.NHColor;
import newhorizon.content.NHFx;
import newhorizon.content.NHSounds;
import newhorizon.content.NHStatusEffects;
import newhorizon.expand.bullets.EffectBulletType;
import newhorizon.expand.entities.EntityRegister;
import newhorizon.expand.game.NHUnitSorts;
import newhorizon.util.func.NHFunc;
import newhorizon.util.func.NHInterp;
import newhorizon.util.graphic.DrawFunc;
import newhorizon.util.graphic.OptionalMultiEffect;

public class PesterEntity
extends UnitEntity {
    public static final float BOSS_WEAPON_RANGE = 640.0f;
    public static final float REFLECT_RANGE = 960.0f;
    public static final float CHECK_RELOAD = 12.0f;
    public static final float CHECK_BOSS_RELOAD = 60.0f;
    public static final float CHECK_DAMAGE = 3000.0f;
    public static final float SALVO_RELOAD = 480.0f;
    public static final float BOSS_RELOAD = 600.0f;
    public static final float SHOOT_DELAY = 60.0f;
    public static final float CHECK_RANGE = 320.0f;
    public static final ObjectIntMap<Healthc> checked = new ObjectIntMap();
    public static final BulletType hitter = new EffectBulletType(15.0f){
        {
            this.speed = 0.0f;
            this.scaledSplashDamage = true;
            this.collidesAir = true;
            this.collides = true;
            this.collidesGround = true;
            this.collidesTiles = true;
            this.damage = 500.0f;
            this.splashDamage = 600.0f;
            this.lightningDamage = 200.0f;
            this.trailColor = this.hitColor = NHColor.thurmixRed;
            this.lightningColor = this.hitColor;
            this.lightColor = this.hitColor;
            this.lightning = 5;
            this.lightningLength = 12;
            this.lightningLengthRand = 16;
            this.splashDamageRadius = 60.0f;
            this.despawnShake = 20.0f;
            this.hitShake = 20.0f;
            this.hitSound = this.despawnSound = Sounds.explosion;
            this.hitEffect = this.despawnEffect = new OptionalMultiEffect(NHFx.square45_8_45, NHFx.hitSparkHuge, NHFx.crossBlast_45);
        }

        public Color color(Bullet b) {
            return b.team.color;
        }

        public void despawned(Bullet b) {
            if (this.despawnHit) {
                this.hit(b);
            } else {
                this.createUnits(b, b.x, b.y);
            }
            if (!this.fragOnHit) {
                this.createFrags(b, b.x, b.y);
            }
            this.despawnEffect.at(b.x, b.y, b.rotation(), this.color(b));
            this.despawnSound.at((Position)b);
            Effect.shake((float)this.despawnShake, (float)this.despawnShake, (Position)b);
        }

        public void hit(Bullet b, float x, float y) {
            this.hitEffect.at(x, y, b.rotation(), this.color(b));
            this.hitSound.at(x, y, this.hitSoundPitch, this.hitSoundVolume);
            Effect.shake((float)this.hitShake, (float)this.hitShake, (Position)b);
            if (this.fragOnHit) {
                this.createFrags(b, x, y);
            }
            this.createPuddles(b, x, y);
            this.createIncend(b, x, y);
            this.createUnits(b, x, y);
            if (this.suppressionRange > 0.0f) {
                Damage.applySuppression((Team)b.team, (float)b.x, (float)b.y, (float)this.suppressionRange, (float)this.suppressionDuration, (float)0.0f, (float)this.suppressionEffectChance, (Position)new Vec2(b.x, b.y));
            }
            this.createSplashDamage(b, x, y);
            for (int i = 0; i < this.lightning; ++i) {
                Lightning.create((Bullet)b, (Color)this.color(b), (float)(this.lightningDamage < 0.0f ? this.damage : this.lightningDamage), (float)b.x, (float)b.y, (float)(b.rotation() + Mathf.range((float)(this.lightningCone / 2.0f)) + this.lightningAngle), (int)(this.lightningLength + Mathf.random((int)this.lightningLengthRand)));
            }
        }
    };
    public static final Effect toBeBlasted = new Effect(60.0f, e -> {
        Draw.color((Color)e.color, (Color)Color.white, (float)e.fin());
        Lines.stroke((float)(2.0f * e.fin()));
        Lines.circle((float)e.x, (float)e.y, (float)(e.rotation * Interp.pow4Out.apply(e.fout())));
        Lines.spikes((float)e.x, (float)e.y, (float)(1.82f * e.rotation * Interp.pow2Out.apply(e.fout())), (float)(e.fin() * e.rotation / 6.0f), (int)4, (float)45.0f);
    }).followParent(true);
    public static Building tmpBuilding = null;
    public boolean isBoss = false;
    public Teamc bossTarget;
    public Teamc lastTarget;
    public transient Vec2 lastTargetPos = new Vec2();
    public float bossWeaponReload;
    public float bossWeaponWarmup;
    public float bossWeaponProgress;
    public float bossTargetShiftLerp = 0.0f;
    public float bossTargetSearchReload = 60.0f;
    public transient float bossWeaponReload_LAST_ = 0.0f;
    public transient float bossWeaponReload_TARGET_ = 0.0f;
    public float hatredCheckReload = 12.0f;
    public float salvoReload = 0.0f;
    public transient float salvoReload_LAST_ = 0.0f;
    public transient float salvoReload_TARGET_ = 0.0f;
    public ObjectFloatMap<Healthc> hatred = new ObjectFloatMap();
    public Seq<Healthc> nextTargets = new Seq();
    protected Trail[] trails = new Trail[0];

    public int classId() {
        return EntityRegister.getID(PesterEntity.class);
    }

    public void setType(UnitType type) {
        super.setType(type);
        if (!Vars.net.active()) {
            this.lastTargetPos.set(this.x, this.y);
        }
        if (!Vars.headless && this.trails.length != 4) {
            this.trails = new Trail[4];
            for (int i = 0; i < this.trails.length; ++i) {
                this.trails[i] = new Trail(type.trailLength);
            }
        }
    }

    public Healthc findOwner(Entityc ent) {
        Healthc target = null;
        for (int itr = 0; ent instanceof Bullet && itr <= 4; ++itr) {
            if ((ent = ((Bullet)ent).owner()) instanceof Unit) {
                Unit u = (Unit)ent.as();
                if (u.controller() instanceof MissileAI) {
                    Unit o = ((MissileAI)u.controller()).shooter;
                    if (!(o.controller() instanceof MissileAI)) {
                        target = o;
                        break;
                    }
                    target = o;
                    continue;
                }
                target = u;
                break;
            }
            if (!(ent instanceof Building)) continue;
            target = (Healthc)ent;
            break;
        }
        return target;
    }

    public void collision(Hitboxc other, float x, float y) {
        if (other instanceof Bullet) {
            Bullet bullet = (Bullet)other;
            this.controller.hit(bullet);
            if (bullet.team == this.team || bullet.type.damage + bullet.type.splashDamage + bullet.type.lightningDamage < 60.0f) {
                return;
            }
            Healthc target = this.findOwner((Entityc)bullet);
            if (target != null) {
                float v = Mathf.clamp((float)(bullet.damage / bullet.type.damage), (float)0.75f, (float)1.25f) * (bullet.type.damage + bullet.type.splashDamage + bullet.type.lightningDamage);
                this.hatred.increment((Object)target, v, v);
            }
        }
    }

    public void update() {
        this.isBoss = super.isBoss() || this.hasEffect(NHStatusEffects.overphased);
        super.update();
        this.bossTargetSearchReload -= Time.delta;
        if (this.bossTargetSearchReload < 0.0f && this.isBoss) {
            this.bossTargetSearchReload = 60.0f;
            this.bossTarget = Units.bestTarget((Team)this.team, (float)this.x, (float)this.y, (float)640.0f, e -> true, e -> e.block.group != BlockGroup.walls, (Units.Sortf)NHUnitSorts.regionalHPMaximum_All);
        }
        if (this.bossTarget != null) {
            if (this.bossTargetShiftLerp <= 0.0075f && this.lastTarget == this.bossTarget) {
                this.lastTargetPos.set(this.lastTarget.x(), this.lastTarget.y());
            } else {
                if (this.bossTargetShiftLerp <= 0.0075f) {
                    this.bossTargetShiftLerp = 1.0f;
                }
                this.bossTargetShiftLerp = Mathf.lerpDelta((float)this.bossTargetShiftLerp, (float)0.0f, (float)0.075f);
                this.lastTargetPos.lerp((Position)this.bossTarget, 0.075f * Time.delta);
            }
        }
        this.lastTarget = this.bossTarget;
        if (this.lastTarget != null && this.lastTarget.isAdded()) {
            this.bossWeaponWarmup = Mathf.lerpDelta((float)this.bossWeaponWarmup, (float)1.0f, (float)0.0075f);
            this.bossWeaponProgress += Time.delta * this.bossWeaponWarmup * (0.86f + Mathf.absin((float)37.0f, (float)1.0f) + Mathf.absin((float)77.0f, (float)1.0f)) * (0.9f - this.bossWeaponReload / 600.0f * 0.7f);
            this.bossWeaponReload += Time.delta * this.bossWeaponWarmup;
        } else {
            if (this.bossWeaponWarmup <= 0.0f) {
                this.bossWeaponWarmup = 0.0f;
                this.lastTargetPos.set((Position)this);
            } else if (this.bossWeaponWarmup < 0.35f) {
                this.bossWeaponWarmup -= Time.delta / 3.0f;
            }
            this.bossWeaponWarmup = Mathf.lerpDelta((float)this.bossWeaponWarmup, (float)0.0f, (float)0.0075f);
        }
        if (this.bossWeaponReload > 600.0f) {
            this.bossWeaponProgress = 0.0f;
            this.bossWeaponWarmup = 0.0f;
            this.bossWeaponReload = 0.0f;
            this.shootBossTarget();
            this.lastTargetPos.set(this.x, this.y);
        }
        if (this.hatred.size > 0) {
            this.hatredCheckReload -= Time.delta;
        }
        if (this.hatredCheckReload < 0.0f) {
            this.hatredCheckReload = 12.0f;
            Groups.bullet.intersect(this.x - 320.0f, this.y - 320.0f, 640.0f, 640.0f, bullet -> {
                Healthc target;
                if (bullet.team != this.team && (target = this.findOwner((Entityc)bullet)) != null) {
                    float v = Mathf.clamp((float)(bullet.damage / bullet.type.damage), (float)0.75f, (float)1.25f) * (bullet.type.damage + bullet.type.splashDamage + bullet.type.lightningDamage);
                    this.hatred.increment((Object)target, v, v);
                }
            });
            for (ObjectFloatMap.Entry e2 : this.hatred.entries()) {
                if (e2.key == null) continue;
                if (!((Healthc)e2.key).isValid() || !this.within((Position)e2.key, 960.0f) || ((Teamc)e2.key).team() == this.team) {
                    this.hatred.remove((Object)((Healthc)e2.key), 0.0f);
                    continue;
                }
                if (!(e2.value > 3000.0f)) continue;
                this.nextTargets.add((Object)((Healthc)e2.key));
                e2.value -= 3000.0f;
            }
        }
        if (this.nextTargets.size > 0) {
            this.salvoReload += Time.delta * (1.0f + (float)Mathf.num((boolean)this.isBoss) * this.reloadMultiplier);
            if (this.salvoReload > 480.0f) {
                this.shootAtHatred();
                this.salvoReload = 0.0f;
            }
        }
    }

    public void shootBossTarget() {
        Bullet b = NHBullets.pesterBlackHole.create(this.self(), this.team, this.lastTargetPos.x, this.lastTargetPos.y, 0.0f, 1.0f, 1.0f, 1.0f, (Object)Float.valueOf(NHBullets.pesterBlackHole.splashDamageRadius));
    }

    public void shootAtHatred() {
        Tmp.v1.trns(this.rotation, -this.type.engineOffset).add(this.x, this.y);
        float ex = Tmp.v1.x;
        float ey = Tmp.v1.y;
        int itr = 0;
        for (Healthc hel : this.nextTargets) {
            if (!hel.isValid()) continue;
            tmpBuilding = null;
            boolean found = World.raycast((int)World.toTile((float)ex), (int)World.toTile((float)ey), (int)World.toTile((float)hel.getX()), (int)World.toTile((float)hel.getY()), (x, y) -> {
                tmpBuilding = Vars.world.build(x, y);
                return tmpBuilding != null && PesterEntity.tmpBuilding.team != this.team && checked.get((Object)tmpBuilding, 0) < 2;
            });
            Object t = found ? tmpBuilding : hel;
            int c = checked.increment(t, 0, 1);
            if (c > 3) continue;
            Time.run((float)((float)itr * 2.0f), () -> this.lambda$shootAtHatred$5((Healthc)t));
            ++itr;
        }
        checked.clear();
        this.nextTargets.clear();
        if (!Vars.headless && itr > 0) {
            NHSounds.hugeShoot.at(ex, ey);
            NHFx.crossSpinBlast.at(ex, ey, 0.0f, this.team.color, (Object)this.self());
        }
        if (NHSetting.enableDetails() && !Vars.headless && this.isBoss) {
            Rand rand = NHFunc.rand;
            for (int i = 0; i < this.trails.length; ++i) {
                Trail trail = this.trails[i];
                float scl = rand.random(0.75f, 1.5f) * (float)Mathf.sign((float)rand.range(1)) * (float)(i + 1) / 1.25f;
                float s = rand.random(0.75f, 1.25f);
                Tmp.v1.trns(Time.time * scl * rand.random(0.5f, 1.5f) + (float)i * 360.0f / (float)this.trails.length + (float)rand.random(360), this.hitSize * (1.1f + 0.5f * (float)i) * 0.75f).add((Position)this).add(Mathf.sinDeg((float)(Time.time * scl * rand.random(0.75f, 1.25f) * s)) * this.hitSize * 0.75f * ((float)i * 0.125f + 1.0f) * rand.random(-1.5f, 1.5f), Mathf.cosDeg((float)(Time.time * scl * rand.random(0.75f, 1.25f) * s)) * this.hitSize * 0.75f * ((float)i * 0.125f + 1.0f) * rand.random(-1.5f, 1.5f));
                trail.update(Tmp.v1.x, Tmp.v1.y, 1.0f + Mathf.absin((float)4.0f, (float)0.2f));
            }
        }
    }

    public void shoot(Healthc h) {
        if (Vars.state.isGame() && h.isValid()) {
            toBeBlasted.at(h.getX(), h.getY(), h instanceof Sized ? ((Sized)h).hitSize() : 30.0f, this.team.color, (Object)h);
            Fx.chainLightning.at(this.x, this.y, 0.0f, this.team.color, (Object)h);
            Time.run((float)60.0f, () -> {
                if (Vars.state.isGame() && h.isValid()) {
                    hitter.create((Entityc)this, this.team, h.getX(), h.getY(), 0.0f);
                    this.heal(500.0f);
                }
            });
        }
    }

    public void drawBossWeapon() {
        if (this.bossWeaponWarmup > 0.01f) {
            float fin = this.bossWeaponReload / 600.0f;
            float fout = 1.0f - fin;
            float fadeS = Mathf.curve((float)fout, (float)0.0225f, (float)0.06f);
            float fadeS2 = Mathf.curve((float)fout, (float)0.09f, (float)0.185f);
            float fade = this.bossWeaponWarmup * Mathf.curve((float)fout, (float)0.0f, (float)0.025f) * NHInterp.bounce5In.apply(fadeS);
            Tmp.v2.trns(this.bossWeaponProgress / 17.0f, Mathf.sin((float)this.bossWeaponProgress, (float)30.0f, (float)60.0f) * fout, Mathf.cos((float)(this.bossWeaponProgress + 177.0f), (float)17.0f, (float)35.0f) * fout);
            Tmp.v3.set(Mathf.sin((float)this.bossWeaponProgress, (float)30.0f, (float)15.0f) * fout, Mathf.sin((float)(this.bossWeaponProgress + 0.9424779f), (float)43.0f, (float)12.0f) * fout);
            float str = 3.5f * fade;
            float addtionRot = (-DrawFunc.rotator_120(DrawFunc.cycle(this.bossWeaponProgress, 45.0f, 490.0f), 0.24f) + Mathf.absin((float)33.0f, (float)220.0f)) * fadeS2 + this.bossWeaponProgress;
            Tmp.v1.trns(this.bossWeaponProgress / 6.0f, fout * 160.0f, Mathf.absin((float)this.bossWeaponProgress, (float)288.0f, (float)33.0f)).scl(Mathf.curve((float)fout, (float)0.025f, (float)0.525f));
            Tmp.v4.set(Tmp.v1).add(this.lastTargetPos).add(Tmp.v2).add(Tmp.v3);
            Lines.stroke((float)str, (Color)Tmp.c1);
            Lines.poly((float)Tmp.v4.x, (float)Tmp.v4.y, (int)3, (float)(50.0f + 80.0f * fout), (float)addtionRot);
            Lines.stroke((float)(str * 3.0f), (Color)Color.black);
            Lines.spikes((float)Tmp.v4.x, (float)Tmp.v4.y, (float)(25.0f + 40.0f * fout), (float)Lines.getStroke(), (int)3, (float)(addtionRot + 60.0f));
            Lines.stroke((float)str, (Color)Tmp.c1);
            Lines.line((float)Tmp.v4.x, (float)Tmp.v4.y, (float)this.lastTargetPos.x, (float)this.lastTargetPos.y);
            Fill.circle((float)Tmp.v4.x, (float)Tmp.v4.y, (float)(Lines.getStroke() * 1.8f));
            Tmp.v4.set(Tmp.v1).rotate(270.0f * fout + this.bossWeaponProgress * 0.035f).add(this.lastTargetPos).add(Tmp.v5.set(Tmp.v2).lerp(Tmp.v3, Mathf.absin((float)8.0f, (float)1.0f)));
            DrawFunc.circlePercent(Tmp.v4.x, Tmp.v4.y, 200.0f - 60.0f * fin, fin * 1.035f, Time.time / 2.0f);
            Lines.line((float)Tmp.v4.x, (float)Tmp.v4.y, (float)this.lastTargetPos.x, (float)this.lastTargetPos.y);
            Fill.circle((float)Tmp.v4.x, (float)Tmp.v4.y, (float)(Lines.getStroke() * 1.8f));
            float fCurveOut = Mathf.curve((float)fout, (float)0.0f, (float)0.03f) * fadeS2;
            Tmp.v4.set(Tmp.v1).rotate(130.0f * fout + this.bossWeaponProgress * 0.075f).add(this.lastTargetPos).add(Tmp.v5.set(Tmp.v3).lerp(Tmp.v2, Mathf.absin((float)12.0f, (float)2.0f) - 1.0f));
            Lines.spikes((float)Tmp.v4.x, (float)Tmp.v4.y, (float)(16.0f + 60.0f * fout), (float)(32.0f * fout + 28.0f), (int)3, (float)(addtionRot + Mathf.absin((float)33.0f, (float)220.0f) * fCurveOut - DrawFunc.rotator_120(DrawFunc.cycle(this.bossWeaponProgress, 0.0f, 360.0f), 0.14f) * 2.0f * fCurveOut + DrawFunc.rotator_120(DrawFunc.cycle(this.bossWeaponProgress, 70.0f, 450.0f), 0.22f) * fCurveOut + 60.0f));
            Lines.line((float)Tmp.v4.x, (float)Tmp.v4.y, (float)this.lastTargetPos.x, (float)this.lastTargetPos.y);
            Fill.circle((float)Tmp.v4.x, (float)Tmp.v4.y, (float)(Lines.getStroke() * 1.8f));
            Tmp.v4.set(this.lastTargetPos).add(Mathf.sin((float)Time.time, (float)36.0f, (float)12.0f) * fout, Mathf.cos((float)Time.time, (float)36.0f, (float)12.0f) * fout);
            Lines.spikes((float)Tmp.v4.x, (float)Tmp.v4.y, (float)(12.0f + 40.0f * fout), (float)(16.0f * fout + 8.0f), (int)4, (float)(45.0f + DrawFunc.rotator_90()));
            Fill.circle((float)this.lastTargetPos.x, (float)this.lastTargetPos.y, (float)(Lines.getStroke() * 5.0f));
            Draw.color((Color)Color.black);
            Fill.circle((float)this.lastTargetPos.x, (float)this.lastTargetPos.y, (float)(Lines.getStroke() * 3.8f));
            Draw.color((Color)Tmp.c1);
            for (int i : Mathf.signs) {
                float d = (float)(220 * i) * fout + (float)(2 * i);
                float phi = Mathf.absin((float)(8.0f + (float)i * 2.0f), (float)12.0f) * fout;
                Lines.lineAngle((float)(this.lastTargetPos.x + d + 1.0f * (float)i), (float)(this.lastTargetPos.y + phi), (float)(90 - i * 90), (float)((float)(682 + i * 75) + 220.0f * fin));
                Lines.lineAngleCenter((float)(this.lastTargetPos.x + d), (float)(this.lastTargetPos.y + phi), (float)45.0f, (float)((float)(188 + i * 20) * fout + 80.0f));
            }
            Lines.stroke((float)(str / 2.2f));
            Lines.spikes((float)this.lastTargetPos.x, (float)this.lastTargetPos.y, (float)NHBullets.pesterBlackHole.splashDamageRadius, (float)(12.0f * fade), (int)30, (float)(Time.time * 0.38f));
        }
    }

    public void draw() {
        super.draw();
        Tmp.c1.set(this.team.color).lerp(Color.white, Mathf.absin((float)4.0f, (float)0.3f));
        Draw.reset();
        float z = Draw.z();
        Draw.z((float)109.999f);
        this.drawBossWeapon();
        Draw.color((Color)Tmp.c1);
        if (this.isBoss) {
            Tmp.v1.trns(this.rotation, -this.type.engineOffset).add(this.x, this.y);
            float cameraFin = (1.0f + 2.0f * DrawFunc.cameraDstScl(Tmp.v1.x, Tmp.v1.y, Vars.mobile ? 200.0f : 320.0f)) / 3.0f;
            float triWidth = this.hitSize * 0.033f * cameraFin;
            for (int i : Mathf.signs) {
                Fill.tri((float)Tmp.v1.x, (float)(Tmp.v1.y + triWidth), (float)Tmp.v1.x, (float)(Tmp.v1.y - triWidth), (float)(Tmp.v1.x + (float)i * cameraFin * this.hitSize * (15.0f + Mathf.absin((float)12.0f, (float)3.0f))), (float)Tmp.v1.y);
            }
        }
        Lines.stroke((float)((3.0f + Mathf.absin((float)10.0f, (float)0.55f)) * Mathf.curve((float)(1.0f - this.salvoReload / 480.0f), (float)0.0f, (float)0.075f)));
        if (this.salvoReload > 5.0f) {
            DrawFunc.circlePercent(this.x, this.y, this.hitSize * 1.35f, this.salvoReload / 480.0f, 0.0f);
        }
        Draw.z((float)100.0f);
        if (NHSetting.enableDetails() && this.isBoss) {
            for (int i = 0; i < this.trails.length; ++i) {
                Tmp.c1.set(this.team.color).mul(1.0f + (float)i * 0.005f).lerp(Color.white, 0.015f * (float)i + Mathf.absin((float)4.0f, (float)0.3f) + Mathf.clamp((float)this.hitTime) / 5.0f);
                this.trails[i].drawCap(Tmp.c1, this.type.trailScl);
                this.trails[i].draw(Tmp.c1, this.type.trailScl);
            }
        }
        Draw.z((float)z);
    }

    public void writeSync(Writes write) {
        super.writeSync(write);
        write.f(this.salvoReload);
        write.f(this.bossWeaponReload);
    }

    public void readSync(Reads read) {
        super.readSync(read);
        if (!this.isLocal()) {
            this.salvoReload_LAST_ = this.salvoReload;
            this.salvoReload_TARGET_ = read.f();
            this.bossWeaponReload_LAST_ = this.bossWeaponReload;
            this.bossWeaponReload_TARGET_ = read.f();
        } else {
            read.f();
            this.salvoReload_LAST_ = this.salvoReload;
            this.salvoReload_TARGET_ = this.salvoReload;
            read.f();
            this.bossWeaponReload_LAST_ = this.bossWeaponReload;
            this.bossWeaponReload_TARGET_ = this.bossWeaponReload;
        }
    }

    public void writeSyncManual(FloatBuffer buffer) {
        super.writeSyncManual(buffer);
    }

    public void readSyncManual(FloatBuffer buffer) {
        super.readSyncManual(buffer);
    }

    public void interpolate() {
        super.interpolate();
    }

    public void snapSync() {
        super.snapSync();
        this.salvoReload_LAST_ = this.salvoReload_TARGET_;
        this.salvoReload = this.salvoReload_TARGET_;
        this.bossWeaponReload_LAST_ = this.bossWeaponReload_TARGET_;
        this.bossWeaponReload = this.bossWeaponReload_TARGET_;
    }

    public void snapInterpolation() {
        super.snapInterpolation();
        this.salvoReload_LAST_ = this.salvoReload;
        this.salvoReload_TARGET_ = this.salvoReload;
        this.bossWeaponReload_LAST_ = this.bossWeaponReload;
        this.bossWeaponReload_TARGET_ = this.bossWeaponReload;
    }

    public boolean isSyncHidden(Player player) {
        return this.nextTargets.isEmpty() && this.hatred.isEmpty() && !this.isShooting() && this.inFogTo(player.team());
    }

    public boolean isBoss() {
        return this.isBoss;
    }

    private /* synthetic */ void lambda$shootAtHatred$5(Healthc t) {
        this.shoot(t);
    }
}

